// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDONMM_DATE_BUTTON_H
#define _HILDONMM_DATE_BUTTON_H


#include <glibmm.h>

/*
 * Copyright (c) 2009  The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <hildonmm/picker-button.h>
#include <hildonmm/date-selector.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonDateButton HildonDateButton;
typedef struct _HildonDateButtonClass HildonDateButtonClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class DateButton_Class; } // namespace Hildon
namespace Hildon
{

/** Button displaying and allowing selection of a date.
 *
 * Hildon::DateButton is a widget that shows a text label and a date, and
 * allows the user to select a different date. Visually, it's a button that,
 * once clicked, presents a Hildon::PickerDialog containing a
 * Hildon::DateSelector. Once the user selects a different date from the
 * selector, this will be shown in the button.
 *
 * @see Hildon::PickerButton, Hildon::TimeButton
 */

class DateButton : public PickerButton
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef DateButton CppObjectType;
  typedef DateButton_Class CppClassType;
  typedef HildonDateButton BaseObjectType;
  typedef HildonDateButtonClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~DateButton();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class DateButton_Class;
  static CppClassType datebutton_class_;

  // noncopyable
  DateButton(const DateButton&);
  DateButton& operator=(const DateButton&);

protected:
  explicit DateButton(const Glib::ConstructParams& construct_params);
  explicit DateButton(HildonDateButton* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonDateButton*       gobj()       { return reinterpret_cast<HildonDateButton*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonDateButton* gobj() const { return reinterpret_cast<HildonDateButton*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:


public:
  DateButton();
  explicit DateButton(Gtk::Hildon::SizeType size, ButtonArrangement arrangement = BUTTON_ARRANGEMENT_HORIZONTAL);
             
  
  DateButton(Gtk::Hildon::SizeType size, ButtonArrangement arrangement, int min_year, int max_year);

  
  void set_date(guint year, guint month, guint day);
  
  void get_date(guint& year, guint& month, guint& day) const;

  // Typed forwarding methods:
  inline void set_selector(DateSelector& selector)
    { PickerButton::set_selector(selector); }
    
  inline DateSelector* get_selector()
    { return dynamic_cast<DateSelector*>(PickerButton::get_selector()); }
    
  inline const DateSelector* get_selector() const
    { return static_cast<const DateSelector*>(PickerButton::get_selector()); }


};

} // namespace Hildon


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Hildon::DateButton
   */
  Hildon::DateButton* wrap(HildonDateButton* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDONMM_DATE_BUTTON_H */

