/*******************************************************************************
 * Copyright (c) 2009 - Dart.
 *
 * This is an control panel applet done to enale or disable
 *  Maemo's web browser user agent.
 *
 */

/*
 ============================================================================
 Name        : main.c
 Author      : Dart
 Version     : 0.1
 Description : Control Panel Applet to customize MicroB useragent.
 ============================================================================
 */


#ifndef _
#define _(String) gettext(String)
#endif

#ifndef N_
#define N_(String) (String)
#endif

#include <libintl.h>
#include <locale.h>
#include <glib/gi18n.h>
#include <hildon-cp-plugin/hildon-cp-plugin-interface.h>
#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <hildon/hildon-note.h>


#define RESPONSE_SET 100
#define RESPONSE_REMOVE 200

void displayresult (GtkWidget *parent, const char *Text)
{
  GtkWidget *banner;

  /*banner = hildon_banner_show_information (parent, NULL, "toto");
  hildon_banner_set_timeout (HILDON_BANNER (banner), 9000);
printf("ta mere2");*/

  banner = hildon_note_new_information(parent, Text);
  gint retcode = gtk_dialog_run (GTK_DIALOG (banner));
  gtk_widget_destroy (banner);
  return;
}

osso_return_t execute(osso_context_t *osso, gpointer data, gboolean user_activated)
{
	GtkWidget *dialog;
	char line[10];
	gint response, res;
	GtkWidget *LabelStatus, *LabelText;

	setlocale(LC_ALL, "");
	bindtextdomain("hideuseragent", "/usr/share/locale");
	bind_textdomain_codeset("hideuseragent", "UTF-8");
	textdomain("hideuseragent");

	FILE* result = popen(N_("/opt/HideUserAgent/MicroBUserAgent.sh get"), N_("r"));
	if (fgets(line, 8, result)==NULL) {
		printf (N_("ERROR fgets\n"));
	}
	pclose(result);

	LabelStatus = gtk_label_new("");
	if (!g_strcmp0(line, N_("default"))) {
		gtk_label_set_markup(GTK_LABEL(LabelStatus), _("<span color=\"red\">The user agent is not currently customized.</span>"));
	} else {
		gtk_label_set_markup(GTK_LABEL(LabelStatus), _("<span color=\"red\">The user agent is currently customized.</span>"));
	}

	/* Create dialog with OK and Cancel buttons. Leave the separator out,
	 * as we do not have any content. */
	dialog = gtk_dialog_new_with_buttons(
		_("Hide MicroB User Agent"),
		GTK_WINDOW(data),
		GTK_DIALOG_MODAL | GTK_DIALOG_NO_SEPARATOR,
		_("Set"),
		RESPONSE_SET,
		_("Remove"),
		RESPONSE_REMOVE,
		NULL);

	LabelText = gtk_label_new(_("Please choose whether you want to set or remove the customization of Maemo Browser's user agent."));
	gtk_label_set_justify(GTK_LABEL(LabelText), GTK_JUSTIFY_LEFT);
	gtk_label_set_line_wrap(GTK_LABEL(LabelText), TRUE);
    gtk_container_add (GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), LabelText);
    gtk_container_add (GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), LabelStatus);


	gtk_widget_show_all (dialog);

	/* Wait until user finishes the dialog. */
	response = gtk_dialog_run(GTK_DIALOG(dialog));
	if (response == RESPONSE_SET)
	{
		/* This correspond to the set command */
		res=system(N_("/opt/HideUserAgent/MicroBUserAgent.sh set"));
		if (!res) {
			displayresult(dialog, _("User agent successfully updated. Browser will be restarted."));
		} else {
			displayresult(dialog, _("Error during user agent update"));
		}
	}
	else if (response == RESPONSE_REMOVE)
	{
		/* This is a remove command */
		res=system(N_("/opt/HideUserAgent/MicroBUserAgent.sh remove"));
		if (!res) {
			displayresult(dialog, _("User agent successfully updated. Browser will be restarted."));
		} else {
			displayresult(dialog, _("Error during user agent update"));
		}
	}

	/* Free the dialog (and it's children) */
	gtk_widget_destroy(GTK_WIDGET(dialog));
	return OSSO_OK;
}

osso_return_t save_state(osso_context_t *osso, gpointer data)
{
	return OSSO_OK;
}
