import gtk
import hildon
import gobject
import evolution
from ctypes import *
from pygobject import *

class ContactView(hildon.PannableArea):
  """Widget which shows a list of contacts in a pannable area.
       
     Copyright (c) Andrew Flegg <andrew@bleb.org> 2009.
     Released under the Artistic Licence."""


  # -----------------------------------------------------------------------
  def __init__(self, contacts):
    """Constructor. Passed a list of EContacts."""
    
    hildon.PannableArea.__init__(self)
    self.contacts = contacts
    self.treestore = gtk.ListStore(str, gtk.gdk.Pixbuf, gobject.TYPE_PYOBJECT)
    for contact in self.contacts:
      if not contact.get_name():
        continue
        
      photo = contact.get_property('photo')
      pi = cast(c_void_p(hash(photo)), POINTER(EContactPhoto))
      pixbuf = None
      if pi.contents.data.uri.startswith("image/"):
        data = string_at(pi.contents.data.inlined.data, pi.contents.data.inlined.length)
        pixbuf_loader = gtk.gdk.PixbufLoader()
        pixbuf_loader.write(data)
        pixbuf_loader.close()
        pixbuf = pixbuf_loader.get_pixbuf()
      elif pi.contents.data.uri.startswith("file://"):
        filename = pi.contents.data.uri[7:]
        pixbuf = gtk.gdk.pixbuf_new_from_file(filename)
            
      if pixbuf:
        size = min(pixbuf.get_width(), pixbuf.get_height())
        pixbuf = pixbuf.subpixbuf(0, 0, size, size).scale_simple(48, 48, gtk.gdk.INTERP_BILINEAR)
      self.treestore.append(row = [contact.get_name(), pixbuf, contact])

    self.treeview = gtk.TreeView(self.treestore)
    tvcolumn = gtk.TreeViewColumn('Name', gtk.CellRendererText(), text = 0)
    self.treeview.append_column(tvcolumn)

    cell = gtk.CellRendererPixbuf()
    cell.set_property('xalign', 1.0)
    tvcolumn = gtk.TreeViewColumn('Picture', cell, pixbuf = 1)
    self.treeview.append_column(tvcolumn)
    
    self.treeview.set_search_column(0)
    self.treeview.connect('row-activated', self._activated)
    self.add(self.treeview)
    self.set_size_request(600, 380)
    
    
  # -----------------------------------------------------------------------
  def _activated(self, treeview, path, column):
    """Used to emit the `contact-activated' signal once a row has been
       selected."""
       
    iter    = treeview.get_model().get_iter(path)
    contact = treeview.get_model().get_value(iter, 2)
    self.emit('contact-activated', contact)


_contact_activated = gobject.signal_new('contact-activated', ContactView, gobject.SIGNAL_ACTION, gobject.TYPE_NONE, [gobject.TYPE_PYOBJECT])



