// Copyright (C) 2005-2007 Code Synthesis Tools CC
//
// This program was generated by CodeSynthesis XSD, an XML Schema to
// C++ data binding compiler.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//
// In addition, as a special exception, Code Synthesis Tools CC gives
// permission to link this program with the Xerces-C++ library (or with
// modified versions of Xerces-C++ that use the same license as Xerces-C++),
// and distribute linked combinations including the two. You must obey
// the GNU General Public License version 2 in all respects for all of
// the code used other than Xerces-C++. If you modify this copy of the
// program, you may extend this exception to your version of the program,
// but you are not obligated to do so. If you do not wish to do so, delete
// this exception statement from your version.
//
// Furthermore, Code Synthesis Tools CC makes a special exception for
// the Free/Libre and Open Source Software (FLOSS) which is described
// in the accompanying FLOSSE file.
//

#ifndef ROOM_XML_HPP
#define ROOM_XML_HPP

// Begin prologue.
//
//
// End prologue.

#include <xsd/cxx/version.hxx>

#if (XSD_INT_VERSION != 3000000L)
#error XSD runtime version mismatch
#endif

#include <xsd/cxx/pre.hxx>

#ifndef XSD_USE_CHAR
#define XSD_USE_CHAR
#endif

#ifndef XSD_CXX_TREE_USE_CHAR
#define XSD_CXX_TREE_USE_CHAR
#endif

#include <xsd/cxx/tree/exceptions.hxx>
#include <xsd/cxx/tree/elements.hxx>
#include <xsd/cxx/tree/types.hxx>

#include <xsd/cxx/xml/error-handler.hxx>

#include <xsd/cxx/tree/parsing.hxx>

namespace xml_schema
{
  // anyType and anySimpleType.
  //
  typedef ::xsd::cxx::tree::type type;
  typedef ::xsd::cxx::tree::simple_type<type> simple_type;

  // 8-bit
  //
  typedef signed char byte;
  typedef unsigned char unsigned_byte;

  // 16-bit
  //
  typedef short short_;
  typedef unsigned short unsigned_short;

  // 32-bit
  //
  typedef int int_;
  typedef unsigned int unsigned_int;

  // 64-bit
  //
  typedef long long long_;
  typedef unsigned long long unsigned_long;

  // Supposed to be arbitrary-length integral types.
  //
  typedef long long integer;
  typedef integer non_positive_integer;
  typedef integer non_negative_integer;
  typedef integer positive_integer;
  typedef integer negative_integer;

  // Boolean.
  //
  typedef bool boolean;

  // Floating-point types.
  //
  typedef float float_;
  typedef double double_;
  typedef double decimal;

  // String types.
  //
  typedef ::xsd::cxx::tree::string< char, simple_type > string;
  typedef ::xsd::cxx::tree::normalized_string< char, string > normalized_string;
  typedef ::xsd::cxx::tree::token< char, normalized_string > token;
  typedef ::xsd::cxx::tree::name< char, token > name;
  typedef ::xsd::cxx::tree::nmtoken< char, token > nmtoken;
  typedef ::xsd::cxx::tree::nmtokens< char, simple_type, nmtoken> nmtokens;
  typedef ::xsd::cxx::tree::ncname< char, name > ncname;
  typedef ::xsd::cxx::tree::language< char, token > language;

  // ID/IDREF.
  //
  typedef ::xsd::cxx::tree::id< char, ncname > id;
  typedef ::xsd::cxx::tree::idref< type, char, ncname > idref;
  typedef ::xsd::cxx::tree::idrefs< char, simple_type, idref > idrefs;

  // URI.
  //
  typedef ::xsd::cxx::tree::uri< char, simple_type > uri;

  // Qualified name.
  //
  typedef ::xsd::cxx::tree::qname< char, simple_type, uri, ncname > qname;

  // Binary.
  //
  typedef ::xsd::cxx::tree::buffer< char > buffer;
  typedef ::xsd::cxx::tree::base64_binary< char, simple_type > base64_binary;
  typedef ::xsd::cxx::tree::hex_binary< char, simple_type > hex_binary;

  // Date/time.
  //
  typedef ::xsd::cxx::tree::date< char, simple_type > date;
  typedef ::xsd::cxx::tree::date_time< char, simple_type > date_time;
  typedef ::xsd::cxx::tree::duration< char, simple_type > duration;
  typedef ::xsd::cxx::tree::day< char, simple_type > day;
  typedef ::xsd::cxx::tree::month< char, simple_type > month;
  typedef ::xsd::cxx::tree::month_day< char, simple_type > month_day;
  typedef ::xsd::cxx::tree::year< char, simple_type > year;
  typedef ::xsd::cxx::tree::year_month< char, simple_type > year_month;
  typedef ::xsd::cxx::tree::time< char, simple_type > time;

  // Entity.
  //
  typedef ::xsd::cxx::tree::entity< char, ncname > entity;
  typedef ::xsd::cxx::tree::entities< char, simple_type, entity > entities;

  // Flags and properties.
  //
  typedef ::xsd::cxx::tree::flags flags;
  typedef ::xsd::cxx::tree::properties< char > properties;

  // DOM user data key for back pointers to tree nodes.
  //
#ifndef XSD_CXX_TREE_TREE_NODE_KEY_IN___XML_SCHEMA
#define XSD_CXX_TREE_TREE_NODE_KEY_IN___XML_SCHEMA

  const XMLCh* const tree_node_key = ::xsd::cxx::tree::user_data_keys::node;

#endif

  // Exceptions.
  //
  typedef ::xsd::cxx::tree::exception< char > exception;
  typedef ::xsd::cxx::tree::parsing< char > parsing;
  typedef ::xsd::cxx::tree::expected_element< char > expected_element;
  typedef ::xsd::cxx::tree::unexpected_element< char > unexpected_element;
  typedef ::xsd::cxx::tree::expected_attribute< char > expected_attribute;
  typedef ::xsd::cxx::tree::unexpected_enumerator< char > unexpected_enumerator;
  typedef ::xsd::cxx::tree::expected_text_content< char > expected_text_content;
  typedef ::xsd::cxx::tree::no_type_info< char > no_type_info;
  typedef ::xsd::cxx::tree::not_derived< char > not_derived;
  typedef ::xsd::cxx::tree::duplicate_id< char > duplicate_id;
  typedef ::xsd::cxx::tree::serialization< char > serialization;
  typedef ::xsd::cxx::tree::no_namespace_mapping< char > no_namespace_mapping;
  typedef ::xsd::cxx::tree::no_prefix_mapping< char > no_prefix_mapping;
  typedef ::xsd::cxx::tree::xsi_already_in_use< char > xsi_already_in_use;
  typedef ::xsd::cxx::tree::bounds< char > bounds;

  // Parsing/serialization diagnostics.
  //
  typedef ::xsd::cxx::tree::severity severity;
  typedef ::xsd::cxx::tree::error< char > error;
  typedef ::xsd::cxx::tree::diagnostics< char > diagnostics;

  // Error handler interface.
  //
  typedef ::xsd::cxx::xml::error_handler< char > error_handler;
}

// Forward declarations.
//
namespace rxml
{
  class RoomXML;
  class floorType;
  class triple_room_data;
  class floor;
  class walls;
  class items;
  class northeast;
  class southeast;
  class northwest;
  class southwest;
  class eastnorth;
  class eastsouth;
  class westnorth;
  class westsouth;
  class bound_x;
  class bound_y;
  class tile;
  class wall;
  class item;
  class axis;
  class direction;
  class type;
}


#include <memory>    // std::auto_ptr
#include <algorithm> // std::binary_search

#include <xsd/cxx/tree/exceptions.hxx>
#include <xsd/cxx/tree/elements.hxx>
#include <xsd/cxx/tree/containers.hxx>
#include <xsd/cxx/tree/list.hxx>

#include <xsd/cxx/xml/dom/parsing-header.hxx>

namespace rxml
{
  class RoomXML: public ::xml_schema::type
  {
    public:
    // name
    // 
    typedef ::xml_schema::string name_type;
    typedef ::xsd::cxx::tree::traits< name_type, char > name_traits;

    const name_type&
    name () const;

    name_type&
    name ();

    void
    name (const name_type& x);

    void
    name (::std::auto_ptr< name_type > p);

    // scenery
    // 
    typedef ::xml_schema::string scenery_type;
    typedef ::xsd::cxx::tree::traits< scenery_type, char > scenery_traits;

    const scenery_type&
    scenery () const;

    scenery_type&
    scenery ();

    void
    scenery (const scenery_type& x);

    void
    scenery (::std::auto_ptr< scenery_type > p);

    // xTiles
    // 
    typedef ::xml_schema::int_ xTiles_type;
    typedef ::xsd::cxx::tree::traits< xTiles_type, char > xTiles_traits;

    const xTiles_type&
    xTiles () const;

    xTiles_type&
    xTiles ();

    void
    xTiles (const xTiles_type& x);

    // yTiles
    // 
    typedef ::xml_schema::int_ yTiles_type;
    typedef ::xsd::cxx::tree::traits< yTiles_type, char > yTiles_traits;

    const yTiles_type&
    yTiles () const;

    yTiles_type&
    yTiles ();

    void
    yTiles (const yTiles_type& x);

    // width
    // 
    typedef ::xml_schema::int_ width_type;
    typedef ::xsd::cxx::tree::traits< width_type, char > width_traits;

    const width_type&
    width () const;

    width_type&
    width ();

    void
    width (const width_type& x);

    // floorType
    // 
    typedef ::rxml::floorType floorType_type;
    typedef ::xsd::cxx::tree::traits< floorType_type, char > floorType_traits;

    const floorType_type&
    floorType () const;

    floorType_type&
    floorType ();

    void
    floorType (const floorType_type& x);

    void
    floorType (::std::auto_ptr< floorType_type > p);

    // deltaX
    // 
    typedef ::xml_schema::int_ deltaX_type;
    typedef ::xsd::cxx::tree::optional< deltaX_type > deltaX_optional;
    typedef ::xsd::cxx::tree::traits< deltaX_type, char > deltaX_traits;

    const deltaX_optional&
    deltaX () const;

    deltaX_optional&
    deltaX ();

    void
    deltaX (const deltaX_type& x);

    void
    deltaX (const deltaX_optional& x);

    // deltaY
    // 
    typedef ::xml_schema::int_ deltaY_type;
    typedef ::xsd::cxx::tree::optional< deltaY_type > deltaY_optional;
    typedef ::xsd::cxx::tree::traits< deltaY_type, char > deltaY_traits;

    const deltaY_optional&
    deltaY () const;

    deltaY_optional&
    deltaY ();

    void
    deltaY (const deltaY_type& x);

    void
    deltaY (const deltaY_optional& x);

    // triple-room-data
    // 
    typedef ::rxml::triple_room_data triple_room_data_type;
    typedef ::xsd::cxx::tree::optional< triple_room_data_type > triple_room_data_optional;
    typedef ::xsd::cxx::tree::traits< triple_room_data_type, char > triple_room_data_traits;

    const triple_room_data_optional&
    triple_room_data () const;

    triple_room_data_optional&
    triple_room_data ();

    void
    triple_room_data (const triple_room_data_type& x);

    void
    triple_room_data (const triple_room_data_optional& x);

    void
    triple_room_data (::std::auto_ptr< triple_room_data_type > p);

    // floor
    // 
    typedef ::rxml::floor floor_type;
    typedef ::xsd::cxx::tree::traits< floor_type, char > floor_traits;

    const floor_type&
    floor () const;

    floor_type&
    floor ();

    void
    floor (const floor_type& x);

    void
    floor (::std::auto_ptr< floor_type > p);

    // walls
    // 
    typedef ::rxml::walls walls_type;
    typedef ::xsd::cxx::tree::optional< walls_type > walls_optional;
    typedef ::xsd::cxx::tree::traits< walls_type, char > walls_traits;

    const walls_optional&
    walls () const;

    walls_optional&
    walls ();

    void
    walls (const walls_type& x);

    void
    walls (const walls_optional& x);

    void
    walls (::std::auto_ptr< walls_type > p);

    // items
    // 
    typedef ::rxml::items items_type;
    typedef ::xsd::cxx::tree::traits< items_type, char > items_traits;

    const items_type&
    items () const;

    items_type&
    items ();

    void
    items (const items_type& x);

    void
    items (::std::auto_ptr< items_type > p);

    // Constructors.
    //
    RoomXML (const name_type&,
             const scenery_type&,
             const xTiles_type&,
             const yTiles_type&,
             const width_type&,
             const floorType_type&,
             const floor_type&,
             const items_type&);

    RoomXML (const ::xercesc::DOMElement& e,
             ::xml_schema::flags f = 0,
             ::xml_schema::type* c = 0);

    RoomXML (const RoomXML& x,
             ::xml_schema::flags f = 0,
             ::xml_schema::type* c = 0);

    virtual RoomXML*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::type* c = 0) const;

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    private:
    ::xsd::cxx::tree::one< name_type > name_;
    ::xsd::cxx::tree::one< scenery_type > scenery_;
    ::xsd::cxx::tree::one< xTiles_type > xTiles_;
    ::xsd::cxx::tree::one< yTiles_type > yTiles_;
    ::xsd::cxx::tree::one< width_type > width_;
    ::xsd::cxx::tree::one< floorType_type > floorType_;
    deltaX_optional deltaX_;
    deltaY_optional deltaY_;
    triple_room_data_optional triple_room_data_;
    ::xsd::cxx::tree::one< floor_type > floor_;
    walls_optional walls_;
    ::xsd::cxx::tree::one< items_type > items_;
  };

  class floorType: public ::xml_schema::string
  {
    public:
    enum value
    {
      none,
      regular,
      mortal
    };

    floorType (value v);

    floorType (const ::xml_schema::string& v);

    floorType (const ::xercesc::DOMElement& e,
               ::xml_schema::flags f = 0,
               ::xml_schema::type* c = 0);

    floorType (const ::xercesc::DOMAttr& a,
               ::xml_schema::flags f = 0,
               ::xml_schema::type* c = 0);

    floorType (const ::std::string& s,
               const ::xercesc::DOMElement* e,
               ::xml_schema::flags f = 0,
               ::xml_schema::type* c = 0);

    floorType (const floorType& x,
               ::xml_schema::flags f = 0,
               ::xml_schema::type* c = 0);

    virtual floorType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::type* c = 0) const;

    floorType&
    operator= (value v);

    virtual
    operator value () const
    {
      return _xsd_floorType_convert ();
    }

    protected:
    value
    _xsd_floorType_convert () const;

    public:
    static const char* const _xsd_floorType_literals_[3];
    static const value _xsd_floorType_indexes_[3];
  };

  class triple_room_data: public ::xml_schema::type
  {
    public:
    // northeast
    // 
    typedef ::rxml::northeast northeast_type;
    typedef ::xsd::cxx::tree::optional< northeast_type > northeast_optional;
    typedef ::xsd::cxx::tree::traits< northeast_type, char > northeast_traits;

    const northeast_optional&
    northeast () const;

    northeast_optional&
    northeast ();

    void
    northeast (const northeast_type& x);

    void
    northeast (const northeast_optional& x);

    void
    northeast (::std::auto_ptr< northeast_type > p);

    // southeast
    // 
    typedef ::rxml::southeast southeast_type;
    typedef ::xsd::cxx::tree::optional< southeast_type > southeast_optional;
    typedef ::xsd::cxx::tree::traits< southeast_type, char > southeast_traits;

    const southeast_optional&
    southeast () const;

    southeast_optional&
    southeast ();

    void
    southeast (const southeast_type& x);

    void
    southeast (const southeast_optional& x);

    void
    southeast (::std::auto_ptr< southeast_type > p);

    // northwest
    // 
    typedef ::rxml::northwest northwest_type;
    typedef ::xsd::cxx::tree::optional< northwest_type > northwest_optional;
    typedef ::xsd::cxx::tree::traits< northwest_type, char > northwest_traits;

    const northwest_optional&
    northwest () const;

    northwest_optional&
    northwest ();

    void
    northwest (const northwest_type& x);

    void
    northwest (const northwest_optional& x);

    void
    northwest (::std::auto_ptr< northwest_type > p);

    // southwest
    // 
    typedef ::rxml::southwest southwest_type;
    typedef ::xsd::cxx::tree::optional< southwest_type > southwest_optional;
    typedef ::xsd::cxx::tree::traits< southwest_type, char > southwest_traits;

    const southwest_optional&
    southwest () const;

    southwest_optional&
    southwest ();

    void
    southwest (const southwest_type& x);

    void
    southwest (const southwest_optional& x);

    void
    southwest (::std::auto_ptr< southwest_type > p);

    // eastnorth
    // 
    typedef ::rxml::eastnorth eastnorth_type;
    typedef ::xsd::cxx::tree::optional< eastnorth_type > eastnorth_optional;
    typedef ::xsd::cxx::tree::traits< eastnorth_type, char > eastnorth_traits;

    const eastnorth_optional&
    eastnorth () const;

    eastnorth_optional&
    eastnorth ();

    void
    eastnorth (const eastnorth_type& x);

    void
    eastnorth (const eastnorth_optional& x);

    void
    eastnorth (::std::auto_ptr< eastnorth_type > p);

    // eastsouth
    // 
    typedef ::rxml::eastsouth eastsouth_type;
    typedef ::xsd::cxx::tree::optional< eastsouth_type > eastsouth_optional;
    typedef ::xsd::cxx::tree::traits< eastsouth_type, char > eastsouth_traits;

    const eastsouth_optional&
    eastsouth () const;

    eastsouth_optional&
    eastsouth ();

    void
    eastsouth (const eastsouth_type& x);

    void
    eastsouth (const eastsouth_optional& x);

    void
    eastsouth (::std::auto_ptr< eastsouth_type > p);

    // westnorth
    // 
    typedef ::rxml::westnorth westnorth_type;
    typedef ::xsd::cxx::tree::optional< westnorth_type > westnorth_optional;
    typedef ::xsd::cxx::tree::traits< westnorth_type, char > westnorth_traits;

    const westnorth_optional&
    westnorth () const;

    westnorth_optional&
    westnorth ();

    void
    westnorth (const westnorth_type& x);

    void
    westnorth (const westnorth_optional& x);

    void
    westnorth (::std::auto_ptr< westnorth_type > p);

    // westsouth
    // 
    typedef ::rxml::westsouth westsouth_type;
    typedef ::xsd::cxx::tree::optional< westsouth_type > westsouth_optional;
    typedef ::xsd::cxx::tree::traits< westsouth_type, char > westsouth_traits;

    const westsouth_optional&
    westsouth () const;

    westsouth_optional&
    westsouth ();

    void
    westsouth (const westsouth_type& x);

    void
    westsouth (const westsouth_optional& x);

    void
    westsouth (::std::auto_ptr< westsouth_type > p);

    // bound-x
    // 
    typedef ::rxml::bound_x bound_x_type;
    typedef ::xsd::cxx::tree::traits< bound_x_type, char > bound_x_traits;

    const bound_x_type&
    bound_x () const;

    bound_x_type&
    bound_x ();

    void
    bound_x (const bound_x_type& x);

    void
    bound_x (::std::auto_ptr< bound_x_type > p);

    // bound-y
    // 
    typedef ::rxml::bound_y bound_y_type;
    typedef ::xsd::cxx::tree::traits< bound_y_type, char > bound_y_traits;

    const bound_y_type&
    bound_y () const;

    bound_y_type&
    bound_y ();

    void
    bound_y (const bound_y_type& x);

    void
    bound_y (::std::auto_ptr< bound_y_type > p);

    // Constructors.
    //
    triple_room_data (const bound_x_type&,
                      const bound_y_type&);

    triple_room_data (const ::xercesc::DOMElement& e,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::type* c = 0);

    triple_room_data (const triple_room_data& x,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::type* c = 0);

    virtual triple_room_data*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::type* c = 0) const;

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    private:
    northeast_optional northeast_;
    southeast_optional southeast_;
    northwest_optional northwest_;
    southwest_optional southwest_;
    eastnorth_optional eastnorth_;
    eastsouth_optional eastsouth_;
    westnorth_optional westnorth_;
    westsouth_optional westsouth_;
    ::xsd::cxx::tree::one< bound_x_type > bound_x_;
    ::xsd::cxx::tree::one< bound_y_type > bound_y_;
  };

  class floor: public ::xml_schema::type
  {
    public:
    // tile
    // 
    typedef ::rxml::tile tile_type;
    typedef ::xsd::cxx::tree::sequence< tile_type > tile_sequence;
    typedef tile_sequence::iterator tile_iterator;
    typedef tile_sequence::const_iterator tile_const_iterator;
    typedef ::xsd::cxx::tree::traits< tile_type, char > tile_traits;

    const tile_sequence&
    tile () const;

    tile_sequence&
    tile ();

    void
    tile (const tile_sequence& s);

    // Constructors.
    //
    floor ();

    floor (const ::xercesc::DOMElement& e,
           ::xml_schema::flags f = 0,
           ::xml_schema::type* c = 0);

    floor (const floor& x,
           ::xml_schema::flags f = 0,
           ::xml_schema::type* c = 0);

    virtual floor*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::type* c = 0) const;

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    private:
    tile_sequence tile_;
  };

  class walls: public ::xml_schema::type
  {
    public:
    // wall
    // 
    typedef ::rxml::wall wall_type;
    typedef ::xsd::cxx::tree::sequence< wall_type > wall_sequence;
    typedef wall_sequence::iterator wall_iterator;
    typedef wall_sequence::const_iterator wall_const_iterator;
    typedef ::xsd::cxx::tree::traits< wall_type, char > wall_traits;

    const wall_sequence&
    wall () const;

    wall_sequence&
    wall ();

    void
    wall (const wall_sequence& s);

    // Constructors.
    //
    walls ();

    walls (const ::xercesc::DOMElement& e,
           ::xml_schema::flags f = 0,
           ::xml_schema::type* c = 0);

    walls (const walls& x,
           ::xml_schema::flags f = 0,
           ::xml_schema::type* c = 0);

    virtual walls*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::type* c = 0) const;

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    private:
    wall_sequence wall_;
  };

  class items: public ::xml_schema::type
  {
    public:
    // item
    // 
    typedef ::rxml::item item_type;
    typedef ::xsd::cxx::tree::sequence< item_type > item_sequence;
    typedef item_sequence::iterator item_iterator;
    typedef item_sequence::const_iterator item_const_iterator;
    typedef ::xsd::cxx::tree::traits< item_type, char > item_traits;

    const item_sequence&
    item () const;

    item_sequence&
    item ();

    void
    item (const item_sequence& s);

    // Constructors.
    //
    items ();

    items (const ::xercesc::DOMElement& e,
           ::xml_schema::flags f = 0,
           ::xml_schema::type* c = 0);

    items (const items& x,
           ::xml_schema::flags f = 0,
           ::xml_schema::type* c = 0);

    virtual items*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::type* c = 0) const;

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    private:
    item_sequence item_;
  };

  class northeast: public ::xml_schema::type
  {
    public:
    // x
    // 
    typedef ::xml_schema::int_ x_type;
    typedef ::xsd::cxx::tree::traits< x_type, char > x_traits;

    const x_type&
    x () const;

    x_type&
    x ();

    void
    x (const x_type& x);

    // y
    // 
    typedef ::xml_schema::int_ y_type;
    typedef ::xsd::cxx::tree::traits< y_type, char > y_traits;

    const y_type&
    y () const;

    y_type&
    y ();

    void
    y (const y_type& x);

    // Constructors.
    //
    northeast (const x_type&,
               const y_type&);

    northeast (const ::xercesc::DOMElement& e,
               ::xml_schema::flags f = 0,
               ::xml_schema::type* c = 0);

    northeast (const northeast& x,
               ::xml_schema::flags f = 0,
               ::xml_schema::type* c = 0);

    virtual northeast*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::type* c = 0) const;

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    private:
    ::xsd::cxx::tree::one< x_type > x_;
    ::xsd::cxx::tree::one< y_type > y_;
  };

  class southeast: public ::xml_schema::type
  {
    public:
    // x
    // 
    typedef ::xml_schema::int_ x_type;
    typedef ::xsd::cxx::tree::traits< x_type, char > x_traits;

    const x_type&
    x () const;

    x_type&
    x ();

    void
    x (const x_type& x);

    // y
    // 
    typedef ::xml_schema::int_ y_type;
    typedef ::xsd::cxx::tree::traits< y_type, char > y_traits;

    const y_type&
    y () const;

    y_type&
    y ();

    void
    y (const y_type& x);

    // Constructors.
    //
    southeast (const x_type&,
               const y_type&);

    southeast (const ::xercesc::DOMElement& e,
               ::xml_schema::flags f = 0,
               ::xml_schema::type* c = 0);

    southeast (const southeast& x,
               ::xml_schema::flags f = 0,
               ::xml_schema::type* c = 0);

    virtual southeast*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::type* c = 0) const;

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    private:
    ::xsd::cxx::tree::one< x_type > x_;
    ::xsd::cxx::tree::one< y_type > y_;
  };

  class northwest: public ::xml_schema::type
  {
    public:
    // x
    // 
    typedef ::xml_schema::int_ x_type;
    typedef ::xsd::cxx::tree::traits< x_type, char > x_traits;

    const x_type&
    x () const;

    x_type&
    x ();

    void
    x (const x_type& x);

    // y
    // 
    typedef ::xml_schema::int_ y_type;
    typedef ::xsd::cxx::tree::traits< y_type, char > y_traits;

    const y_type&
    y () const;

    y_type&
    y ();

    void
    y (const y_type& x);

    // Constructors.
    //
    northwest (const x_type&,
               const y_type&);

    northwest (const ::xercesc::DOMElement& e,
               ::xml_schema::flags f = 0,
               ::xml_schema::type* c = 0);

    northwest (const northwest& x,
               ::xml_schema::flags f = 0,
               ::xml_schema::type* c = 0);

    virtual northwest*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::type* c = 0) const;

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    private:
    ::xsd::cxx::tree::one< x_type > x_;
    ::xsd::cxx::tree::one< y_type > y_;
  };

  class southwest: public ::xml_schema::type
  {
    public:
    // x
    // 
    typedef ::xml_schema::int_ x_type;
    typedef ::xsd::cxx::tree::traits< x_type, char > x_traits;

    const x_type&
    x () const;

    x_type&
    x ();

    void
    x (const x_type& x);

    // y
    // 
    typedef ::xml_schema::int_ y_type;
    typedef ::xsd::cxx::tree::traits< y_type, char > y_traits;

    const y_type&
    y () const;

    y_type&
    y ();

    void
    y (const y_type& x);

    // Constructors.
    //
    southwest (const x_type&,
               const y_type&);

    southwest (const ::xercesc::DOMElement& e,
               ::xml_schema::flags f = 0,
               ::xml_schema::type* c = 0);

    southwest (const southwest& x,
               ::xml_schema::flags f = 0,
               ::xml_schema::type* c = 0);

    virtual southwest*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::type* c = 0) const;

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    private:
    ::xsd::cxx::tree::one< x_type > x_;
    ::xsd::cxx::tree::one< y_type > y_;
  };

  class eastnorth: public ::xml_schema::type
  {
    public:
    // x
    // 
    typedef ::xml_schema::int_ x_type;
    typedef ::xsd::cxx::tree::traits< x_type, char > x_traits;

    const x_type&
    x () const;

    x_type&
    x ();

    void
    x (const x_type& x);

    // y
    // 
    typedef ::xml_schema::int_ y_type;
    typedef ::xsd::cxx::tree::traits< y_type, char > y_traits;

    const y_type&
    y () const;

    y_type&
    y ();

    void
    y (const y_type& x);

    // Constructors.
    //
    eastnorth (const x_type&,
               const y_type&);

    eastnorth (const ::xercesc::DOMElement& e,
               ::xml_schema::flags f = 0,
               ::xml_schema::type* c = 0);

    eastnorth (const eastnorth& x,
               ::xml_schema::flags f = 0,
               ::xml_schema::type* c = 0);

    virtual eastnorth*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::type* c = 0) const;

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    private:
    ::xsd::cxx::tree::one< x_type > x_;
    ::xsd::cxx::tree::one< y_type > y_;
  };

  class eastsouth: public ::xml_schema::type
  {
    public:
    // x
    // 
    typedef ::xml_schema::int_ x_type;
    typedef ::xsd::cxx::tree::traits< x_type, char > x_traits;

    const x_type&
    x () const;

    x_type&
    x ();

    void
    x (const x_type& x);

    // y
    // 
    typedef ::xml_schema::int_ y_type;
    typedef ::xsd::cxx::tree::traits< y_type, char > y_traits;

    const y_type&
    y () const;

    y_type&
    y ();

    void
    y (const y_type& x);

    // Constructors.
    //
    eastsouth (const x_type&,
               const y_type&);

    eastsouth (const ::xercesc::DOMElement& e,
               ::xml_schema::flags f = 0,
               ::xml_schema::type* c = 0);

    eastsouth (const eastsouth& x,
               ::xml_schema::flags f = 0,
               ::xml_schema::type* c = 0);

    virtual eastsouth*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::type* c = 0) const;

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    private:
    ::xsd::cxx::tree::one< x_type > x_;
    ::xsd::cxx::tree::one< y_type > y_;
  };

  class westnorth: public ::xml_schema::type
  {
    public:
    // x
    // 
    typedef ::xml_schema::int_ x_type;
    typedef ::xsd::cxx::tree::traits< x_type, char > x_traits;

    const x_type&
    x () const;

    x_type&
    x ();

    void
    x (const x_type& x);

    // y
    // 
    typedef ::xml_schema::int_ y_type;
    typedef ::xsd::cxx::tree::traits< y_type, char > y_traits;

    const y_type&
    y () const;

    y_type&
    y ();

    void
    y (const y_type& x);

    // Constructors.
    //
    westnorth (const x_type&,
               const y_type&);

    westnorth (const ::xercesc::DOMElement& e,
               ::xml_schema::flags f = 0,
               ::xml_schema::type* c = 0);

    westnorth (const westnorth& x,
               ::xml_schema::flags f = 0,
               ::xml_schema::type* c = 0);

    virtual westnorth*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::type* c = 0) const;

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    private:
    ::xsd::cxx::tree::one< x_type > x_;
    ::xsd::cxx::tree::one< y_type > y_;
  };

  class westsouth: public ::xml_schema::type
  {
    public:
    // x
    // 
    typedef ::xml_schema::int_ x_type;
    typedef ::xsd::cxx::tree::traits< x_type, char > x_traits;

    const x_type&
    x () const;

    x_type&
    x ();

    void
    x (const x_type& x);

    // y
    // 
    typedef ::xml_schema::int_ y_type;
    typedef ::xsd::cxx::tree::traits< y_type, char > y_traits;

    const y_type&
    y () const;

    y_type&
    y ();

    void
    y (const y_type& x);

    // Constructors.
    //
    westsouth (const x_type&,
               const y_type&);

    westsouth (const ::xercesc::DOMElement& e,
               ::xml_schema::flags f = 0,
               ::xml_schema::type* c = 0);

    westsouth (const westsouth& x,
               ::xml_schema::flags f = 0,
               ::xml_schema::type* c = 0);

    virtual westsouth*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::type* c = 0) const;

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    private:
    ::xsd::cxx::tree::one< x_type > x_;
    ::xsd::cxx::tree::one< y_type > y_;
  };

  class bound_x: public ::xml_schema::type
  {
    public:
    // minimum
    // 
    typedef ::xml_schema::int_ minimum_type;
    typedef ::xsd::cxx::tree::traits< minimum_type, char > minimum_traits;

    const minimum_type&
    minimum () const;

    minimum_type&
    minimum ();

    void
    minimum (const minimum_type& x);

    // maximum
    // 
    typedef ::xml_schema::int_ maximum_type;
    typedef ::xsd::cxx::tree::traits< maximum_type, char > maximum_traits;

    const maximum_type&
    maximum () const;

    maximum_type&
    maximum ();

    void
    maximum (const maximum_type& x);

    // Constructors.
    //
    bound_x (const minimum_type&,
             const maximum_type&);

    bound_x (const ::xercesc::DOMElement& e,
             ::xml_schema::flags f = 0,
             ::xml_schema::type* c = 0);

    bound_x (const bound_x& x,
             ::xml_schema::flags f = 0,
             ::xml_schema::type* c = 0);

    virtual bound_x*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::type* c = 0) const;

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    private:
    ::xsd::cxx::tree::one< minimum_type > minimum_;
    ::xsd::cxx::tree::one< maximum_type > maximum_;
  };

  class bound_y: public ::xml_schema::type
  {
    public:
    // minimum
    // 
    typedef ::xml_schema::int_ minimum_type;
    typedef ::xsd::cxx::tree::traits< minimum_type, char > minimum_traits;

    const minimum_type&
    minimum () const;

    minimum_type&
    minimum ();

    void
    minimum (const minimum_type& x);

    // maximum
    // 
    typedef ::xml_schema::int_ maximum_type;
    typedef ::xsd::cxx::tree::traits< maximum_type, char > maximum_traits;

    const maximum_type&
    maximum () const;

    maximum_type&
    maximum ();

    void
    maximum (const maximum_type& x);

    // Constructors.
    //
    bound_y (const minimum_type&,
             const maximum_type&);

    bound_y (const ::xercesc::DOMElement& e,
             ::xml_schema::flags f = 0,
             ::xml_schema::type* c = 0);

    bound_y (const bound_y& x,
             ::xml_schema::flags f = 0,
             ::xml_schema::type* c = 0);

    virtual bound_y*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::type* c = 0) const;

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    private:
    ::xsd::cxx::tree::one< minimum_type > minimum_;
    ::xsd::cxx::tree::one< maximum_type > maximum_;
  };

  class tile: public ::xml_schema::type
  {
    public:
    // x
    // 
    typedef ::xml_schema::int_ x_type;
    typedef ::xsd::cxx::tree::traits< x_type, char > x_traits;

    const x_type&
    x () const;

    x_type&
    x ();

    void
    x (const x_type& x);

    // y
    // 
    typedef ::xml_schema::int_ y_type;
    typedef ::xsd::cxx::tree::traits< y_type, char > y_traits;

    const y_type&
    y () const;

    y_type&
    y ();

    void
    y (const y_type& x);

    // offsetX
    // 
    typedef ::xml_schema::int_ offsetX_type;
    typedef ::xsd::cxx::tree::traits< offsetX_type, char > offsetX_traits;

    const offsetX_type&
    offsetX () const;

    offsetX_type&
    offsetX ();

    void
    offsetX (const offsetX_type& x);

    // offsetY
    // 
    typedef ::xml_schema::int_ offsetY_type;
    typedef ::xsd::cxx::tree::traits< offsetY_type, char > offsetY_traits;

    const offsetY_type&
    offsetY () const;

    offsetY_type&
    offsetY ();

    void
    offsetY (const offsetY_type& x);

    // bitmap
    // 
    typedef ::xml_schema::string bitmap_type;
    typedef ::xsd::cxx::tree::traits< bitmap_type, char > bitmap_traits;

    const bitmap_type&
    bitmap () const;

    bitmap_type&
    bitmap ();

    void
    bitmap (const bitmap_type& x);

    void
    bitmap (::std::auto_ptr< bitmap_type > p);

    // Constructors.
    //
    tile (const x_type&,
          const y_type&,
          const offsetX_type&,
          const offsetY_type&,
          const bitmap_type&);

    tile (const ::xercesc::DOMElement& e,
          ::xml_schema::flags f = 0,
          ::xml_schema::type* c = 0);

    tile (const tile& x,
          ::xml_schema::flags f = 0,
          ::xml_schema::type* c = 0);

    virtual tile*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::type* c = 0) const;

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    private:
    ::xsd::cxx::tree::one< x_type > x_;
    ::xsd::cxx::tree::one< y_type > y_;
    ::xsd::cxx::tree::one< offsetX_type > offsetX_;
    ::xsd::cxx::tree::one< offsetY_type > offsetY_;
    ::xsd::cxx::tree::one< bitmap_type > bitmap_;
  };

  class wall: public ::xml_schema::type
  {
    public:
    // axis
    // 
    typedef ::rxml::axis axis_type;
    typedef ::xsd::cxx::tree::traits< axis_type, char > axis_traits;

    const axis_type&
    axis () const;

    axis_type&
    axis ();

    void
    axis (const axis_type& x);

    void
    axis (::std::auto_ptr< axis_type > p);

    // index
    // 
    typedef ::xml_schema::int_ index_type;
    typedef ::xsd::cxx::tree::traits< index_type, char > index_traits;

    const index_type&
    index () const;

    index_type&
    index ();

    void
    index (const index_type& x);

    // bitmap
    // 
    typedef ::xml_schema::string bitmap_type;
    typedef ::xsd::cxx::tree::traits< bitmap_type, char > bitmap_traits;

    const bitmap_type&
    bitmap () const;

    bitmap_type&
    bitmap ();

    void
    bitmap (const bitmap_type& x);

    void
    bitmap (::std::auto_ptr< bitmap_type > p);

    // Constructors.
    //
    wall (const axis_type&,
          const index_type&,
          const bitmap_type&);

    wall (const ::xercesc::DOMElement& e,
          ::xml_schema::flags f = 0,
          ::xml_schema::type* c = 0);

    wall (const wall& x,
          ::xml_schema::flags f = 0,
          ::xml_schema::type* c = 0);

    virtual wall*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::type* c = 0) const;

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    private:
    ::xsd::cxx::tree::one< axis_type > axis_;
    ::xsd::cxx::tree::one< index_type > index_;
    ::xsd::cxx::tree::one< bitmap_type > bitmap_;
  };

  class item: public ::xml_schema::type
  {
    public:
    // label
    // 
    typedef ::xml_schema::short_ label_type;
    typedef ::xsd::cxx::tree::traits< label_type, char > label_traits;

    const label_type&
    label () const;

    label_type&
    label ();

    void
    label (const label_type& x);

    // direction
    // 
    typedef ::rxml::direction direction_type;
    typedef ::xsd::cxx::tree::traits< direction_type, char > direction_traits;

    const direction_type&
    direction () const;

    direction_type&
    direction ();

    void
    direction (const direction_type& x);

    void
    direction (::std::auto_ptr< direction_type > p);

    // behavior
    // 
    typedef ::xml_schema::int_ behavior_type;
    typedef ::xsd::cxx::tree::traits< behavior_type, char > behavior_traits;

    const behavior_type&
    behavior () const;

    behavior_type&
    behavior ();

    void
    behavior (const behavior_type& x);

    // type
    // 
    typedef ::rxml::type type_type;
    typedef ::xsd::cxx::tree::traits< type_type, char > type_traits;

    const type_type&
    type () const;

    type_type&
    type ();

    void
    type (const type_type& x);

    void
    type (::std::auto_ptr< type_type > p);

    // extra
    // 
    typedef ::xml_schema::int_ extra_type;
    typedef ::xsd::cxx::tree::sequence< extra_type > extra_sequence;
    typedef extra_sequence::iterator extra_iterator;
    typedef extra_sequence::const_iterator extra_const_iterator;
    typedef ::xsd::cxx::tree::traits< extra_type, char > extra_traits;

    const extra_sequence&
    extra () const;

    extra_sequence&
    extra ();

    void
    extra (const extra_sequence& s);

    // x
    // 
    typedef ::xml_schema::int_ x_type;
    typedef ::xsd::cxx::tree::traits< x_type, char > x_traits;

    const x_type&
    x () const;

    x_type&
    x ();

    void
    x (const x_type& x);

    // y
    // 
    typedef ::xml_schema::int_ y_type;
    typedef ::xsd::cxx::tree::traits< y_type, char > y_traits;

    const y_type&
    y () const;

    y_type&
    y ();

    void
    y (const y_type& x);

    // z
    // 
    typedef ::xml_schema::int_ z_type;
    typedef ::xsd::cxx::tree::traits< z_type, char > z_traits;

    const z_type&
    z () const;

    z_type&
    z ();

    void
    z (const z_type& x);

    // Constructors.
    //
    item (const label_type&,
          const direction_type&,
          const behavior_type&,
          const type_type&,
          const x_type&,
          const y_type&,
          const z_type&);

    item (const ::xercesc::DOMElement& e,
          ::xml_schema::flags f = 0,
          ::xml_schema::type* c = 0);

    item (const item& x,
          ::xml_schema::flags f = 0,
          ::xml_schema::type* c = 0);

    virtual item*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::type* c = 0) const;

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    private:
    ::xsd::cxx::tree::one< label_type > label_;
    ::xsd::cxx::tree::one< direction_type > direction_;
    ::xsd::cxx::tree::one< behavior_type > behavior_;
    ::xsd::cxx::tree::one< type_type > type_;
    extra_sequence extra_;
    ::xsd::cxx::tree::one< x_type > x_;
    ::xsd::cxx::tree::one< y_type > y_;
    ::xsd::cxx::tree::one< z_type > z_;
  };

  class axis: public ::xml_schema::string
  {
    public:
    enum value
    {
      x,
      y
    };

    axis (value v);

    axis (const ::xml_schema::string& v);

    axis (const ::xercesc::DOMElement& e,
          ::xml_schema::flags f = 0,
          ::xml_schema::type* c = 0);

    axis (const ::xercesc::DOMAttr& a,
          ::xml_schema::flags f = 0,
          ::xml_schema::type* c = 0);

    axis (const ::std::string& s,
          const ::xercesc::DOMElement* e,
          ::xml_schema::flags f = 0,
          ::xml_schema::type* c = 0);

    axis (const axis& x,
          ::xml_schema::flags f = 0,
          ::xml_schema::type* c = 0);

    virtual axis*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::type* c = 0) const;

    axis&
    operator= (value v);

    virtual
    operator value () const
    {
      return _xsd_axis_convert ();
    }

    protected:
    value
    _xsd_axis_convert () const;

    public:
    static const char* const _xsd_axis_literals_[2];
    static const value _xsd_axis_indexes_[2];
  };

  class direction: public ::xml_schema::string
  {
    public:
    enum value
    {
      none,
      south,
      west,
      north,
      east,
      northeast,
      southeast,
      southwest,
      northwest,
      eastnorth,
      eastsouth,
      westnorth,
      westsouth
    };

    direction (value v);

    direction (const ::xml_schema::string& v);

    direction (const ::xercesc::DOMElement& e,
               ::xml_schema::flags f = 0,
               ::xml_schema::type* c = 0);

    direction (const ::xercesc::DOMAttr& a,
               ::xml_schema::flags f = 0,
               ::xml_schema::type* c = 0);

    direction (const ::std::string& s,
               const ::xercesc::DOMElement* e,
               ::xml_schema::flags f = 0,
               ::xml_schema::type* c = 0);

    direction (const direction& x,
               ::xml_schema::flags f = 0,
               ::xml_schema::type* c = 0);

    virtual direction*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::type* c = 0) const;

    direction&
    operator= (value v);

    virtual
    operator value () const
    {
      return _xsd_direction_convert ();
    }

    protected:
    value
    _xsd_direction_convert () const;

    public:
    static const char* const _xsd_direction_literals_[13];
    static const value _xsd_direction_indexes_[13];
  };

  class type: public ::xml_schema::string
  {
    public:
    enum value
    {
      wall,
      door,
      griditem,
      freeitem
    };

    type (value v);

    type (const ::xml_schema::string& v);

    type (const ::xercesc::DOMElement& e,
          ::xml_schema::flags f = 0,
          ::xml_schema::type* c = 0);

    type (const ::xercesc::DOMAttr& a,
          ::xml_schema::flags f = 0,
          ::xml_schema::type* c = 0);

    type (const ::std::string& s,
          const ::xercesc::DOMElement* e,
          ::xml_schema::flags f = 0,
          ::xml_schema::type* c = 0);

    type (const type& x,
          ::xml_schema::flags f = 0,
          ::xml_schema::type* c = 0);

    virtual type*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::type* c = 0) const;

    type&
    operator= (value v);

    virtual
    operator value () const
    {
      return _xsd_type_convert ();
    }

    protected:
    value
    _xsd_type_convert () const;

    public:
    static const char* const _xsd_type_literals_[4];
    static const value _xsd_type_indexes_[4];
  };
}

#include <iosfwd>

#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMInputSource.hpp>
#include <xercesc/dom/DOMErrorHandler.hpp>

namespace rxml
{
  // Parse a URI or a local file.
  //

  ::std::auto_ptr< ::rxml::RoomXML >
  room (const ::std::string& uri,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::auto_ptr< ::rxml::RoomXML >
  room (const ::std::string& uri,
        ::xml_schema::error_handler& eh,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::auto_ptr< ::rxml::RoomXML >
  room (const ::std::string& uri,
        ::xercesc::DOMErrorHandler& eh,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse std::istream.
  //

  ::std::auto_ptr< ::rxml::RoomXML >
  room (::std::istream& is,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::auto_ptr< ::rxml::RoomXML >
  room (::std::istream& is,
        ::xml_schema::error_handler& eh,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::auto_ptr< ::rxml::RoomXML >
  room (::std::istream& is,
        ::xercesc::DOMErrorHandler& eh,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::auto_ptr< ::rxml::RoomXML >
  room (::std::istream& is,
        const ::std::string& id,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::auto_ptr< ::rxml::RoomXML >
  room (::std::istream& is,
        const ::std::string& id,
        ::xml_schema::error_handler& eh,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::auto_ptr< ::rxml::RoomXML >
  room (::std::istream& is,
        const ::std::string& id,
        ::xercesc::DOMErrorHandler& eh,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::DOMInputSource.
  //

  ::std::auto_ptr< ::rxml::RoomXML >
  room (const ::xercesc::DOMInputSource& is,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::auto_ptr< ::rxml::RoomXML >
  room (const ::xercesc::DOMInputSource& is,
        ::xml_schema::error_handler& eh,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::auto_ptr< ::rxml::RoomXML >
  room (const ::xercesc::DOMInputSource& is,
        ::xercesc::DOMErrorHandler& eh,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::DOMDocument.
  //

  ::std::auto_ptr< ::rxml::RoomXML >
  room (const ::xercesc::DOMDocument& d,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::auto_ptr< ::rxml::RoomXML >
  room (::xercesc::DOMDocument* d,
        ::xml_schema::flags f = 0,
        const ::xml_schema::properties& p = ::xml_schema::properties ());
}

#include <xsd/cxx/post.hxx>

// Begin epilogue.
//
//
// End epilogue.

#endif // ROOM_XML_HPP
