#!/usr/bin/python2.5
import sys
from PyQt4 import QtGui,QtCore
from hangmanHelper import *
import hangmanSolver

class MyForm(QtGui.QMainWindow):
	def __init__(self, parent=None):
		# Build parent user interface
		QtGui.QWidget.__init__(self, parent)
		self.ui = Ui_MainWindow()
		self.ui.setupUi(self)
		# Setup hangmanSolver class
		self.hs = hangmanSolver.hangmanSolver()
		# Connect solve button to solve function
		QtCore.QObject.connect(self.ui.btnSolve, QtCore.SIGNAL('clicked()'), self.solve)
		self.firstSolve = True
		
	def solve(self):
		# Figure out if is the first time pressing the solve button. Then we need to load the dictionary.
		if self.firstSolve:
			self.hs.setDictionary("/opt/hangmanHelper/wordlist.txt")
			self.firstSolve = False
		self.hs.setMask(str(self.ui.txtPuzzleWord.text()).lower())
		self.hs.setIChars(str(self.ui.txtGuessedLetters.text()).lower())
		self.hs.solve()
		letters = self.getLetters(self.hs.getLetterRecommendations(), 10)
		self.ui.txtLetterRecommendations.setText(letters)
		self.updateSolutionsList(self.hs.getPossibleSolutions())
	
	def updateSolutionsList(self, solutionsList):
		qlist = QtCore.QStringList(map(QtCore.QString, solutionsList))
		self.ui.lstPossibleSolutions.clear()
		self.ui.lstPossibleSolutions.addItems(qlist)
	
	def getLetters(self, letterRecommendations, n):
		"""Returns first n letters separated by spaces"""
		result = ""
		max = len(letterRecommendations)
		if max > n: max = n;
		for x in range(0, max):
			result = result + " " + letterRecommendations[x][0]
		return result

if __name__ == "__main__":
	app = QtGui.QApplication(sys.argv)
	myapp = MyForm()
	myapp.show()
	sys.exit(app.exec_())
