#!/bin/sh

CFG_DIR=$HOME/.config/handy-gui
CFG_FILE=$CFG_DIR/handy-gui.cfg
mkdir -p $CFG_DIR 2> /dev/null
if [ ! -r $CFG_FILE ]
then
	echo "exec_path /opt/handy" > $CFG_FILE
	echo "exit_after_launch false" >> $CFG_FILE
	echo "rom_path notset" >> $CFG_FILE
	echo "sound true" >> $CFG_FILE
	echo "fullscreen true" >> $CFG_FILE
	echo "lcd true" >> $CFG_FILE
fi
# Set missing values
grep ^exec_path $CFG_FILE >/dev/null || echo "exec_path /opt/handy" >> $CFG_FILE
grep ^exit_after_launch $CFG_FILE >/dev/null || echo "exit_after_launch false" >> $CFG_FILE
grep "^rom_path " $CFG_FILE >/dev/null || echo "rom_path notset" >> $CFG_FILE
grep ^sound $CFG_FILE >/dev/null || echo "sound true" >> $CFG_FILE
grep ^lcd $CFG_FILE >/dev/null || echo "lcd true" >> $CFG_FILE
grep ^fullscreen $CFG_FILE >/dev/null || echo "fullscreen true" >> $CFG_FILE
 
cd /opt/handy-gui/
python handy-gui.py
