#ifndef FILESYSTEMMODEL_H
#define FILESYSTEMMODEL_H

#include <QDebug>

#include <QSortFilterProxyModel>
#include <QStandardItemModel>
#include <QFileSystemWatcher>
#include <QDir>
#include <QDateTime>

#include <hildon-thumbnail/hildon-thumbnail-factory.h>
#include <libgnomevfs/gnome-vfs-mime-utils.h>
#include <gio/gio.h>

Q_DECLARE_METATYPE(QFileInfo)

class FileSystemModel : public QSortFilterProxyModel
{
    Q_OBJECT

public:
    enum {
        FileInfoRole = Qt::UserRole+100,
        SymLinkRole,
        BrokenRole,
        FirstDetailRole,
        SecondDetailRole
    };

    enum Detail {
        Size,
        Date
    };

    FileSystemModel(QObject *parent);

    QString location();
    void setLocation(QString path);
    void setDetails(Detail firstDetail, Detail secondDetail);

    void enableDotDot(bool enable);
    void enableHidden(bool enable);
    void enableThumbnails(bool enable);
    void sortByName();
    void sortByTime();
    void sortBySize();
    void sortByType();

    static QIcon icon(QFileInfo info);
    static QIcon thumbnail(QFileInfo info);
    static QString sizeString(qint64 size);
    static QString detailString(QFileInfo info, Detail detail);

private:
    QStandardItemModel *model;
    QFileSystemWatcher *watcher;

    bool showDotDot;
    bool showHidden;
    bool showThumbnails;
    void rebuildFilter();

    QDir currentDir;
    bool filterAcceptsRow(int sourceRow, const QModelIndex &sourceParent) const;

    Detail firstDetail;
    Detail secondDetail;

private slots:
    void reload();
};

#endif // FILESYSTEMMODEL_H
