#include <stdio.h>
#include <glib.h>
#include <unistd.h>

#include "gweled.h"
#include "sound.h"
#include "graphics.h"
#include "board.h"
#include "sge_core.h"

#ifdef MAEMO
#define SETTINGS_PATH "/home/user/.gweled"
#else
#define SETTINGS_PATH get_path(0)
#endif

int g_timer_mode = 1;

SDL_mutex 	*game_mutex = NULL;

void game_lock(void)
{
	SDL_mutexP(game_mutex);
//	pthread_mutex_lock(&board_mutex);
}

void game_unlock(void)
{
	SDL_mutexV(game_mutex);
//	pthread_mutex_unlock(&board_mutex);
}

GRand *g_random_generator;
#ifndef MAEMO
char *get_path(int n)
{
	struct passwd *pw;
	static char path[255];
	pw = getpwuid(getuid());
	if (!pw) {
		strcpy(path, "/tmp");
	} else 
		snprintf(path, sizeof(path) - 32, "%s", pw->pw_dir);
	switch (n) {
	case 0:
		strcat(path,"/.gweled");
		break;
	case 1:
		strcat(path,"/.gweled-save");
		break;	
	}
	return path;
}
#endif
static void game_save_settings(void)
{
	FILE *f = fopen(SETTINGS_PATH,"w");
	if (!f)
		return;
	if (fwrite(&g_music_on, sizeof(g_music_on), 1, f) != 1)
		goto err;
	if (fwrite(&gi_high_score, sizeof(gi_high_score), 1, f) != 1)
		goto err;
	if (fwrite(&gi_notime_high_score, sizeof(gi_notime_high_score), 1, f) != 1)
		goto err;
	if (fwrite(&g_timer_mode, sizeof(g_timer_mode), 1, f) != 1)
		goto err;
	if (fwrite(&g_sound_on, sizeof(g_sound_on), 1, f) != 1)
		goto err;
err:		
	fclose(f);	
}

static int game_load_settings(void)
{
	FILE *f = fopen(SETTINGS_PATH,"r");
	if (!f)
		return -1;
	if (fread(&g_music_on, sizeof(g_music_on), 1, f) != 1)
		goto err;
	if (fread(&gi_high_score, sizeof(gi_high_score), 1, f) != 1)
		goto err;
	if (fread(&gi_notime_high_score, sizeof(gi_notime_high_score), 1, f) != 1)
		goto err;
	if (fread(&g_timer_mode, sizeof(g_timer_mode), 1, f) != 1)
		goto err;
	if (fread(&g_sound_on, sizeof(g_sound_on), 1, f) != 1)
		g_sound_on = 1;
	fclose(f);
	game_timer_mode = g_timer_mode;
	return 0;	
err:
	fclose(f);
	return -1;
}

static Uint32 callback(Uint32 interval)
{
	game_lock();
	board_engine_loop (NULL);
	if (sge_main_loop (NULL)) {
		gfx_update(BOARD_X,BOARD_Y,TILE_WIDTH * BOARD_WIDTH,TILE_HEIGHT * BOARD_HEIGHT);
	}
	game_unlock();
	return interval;
}

static void music_status(void)
{
//Hack 20100104 to add sound mute
	gfx_clear(4, 352, 40, 40);
	if (!g_sound_on)
		gfx_draw(sge_get_pixbuf(gi_not_pixbuf),4,352);
	gfx_update(4, 352, 40, 40);	
//end hack

	gfx_clear(4, 438, 40, 40);
	if (!g_music_on)
		gfx_draw(sge_get_pixbuf(gi_not_pixbuf),4,438);
	gfx_update(4, 438, 40, 40);	

}

static void timer_status(void)
{
	gfx_clear(4, 396, 40, 40);
	if (!g_timer_mode)
		gfx_draw(sge_get_pixbuf(gi_not_pixbuf), 4, 396);
	gfx_update(4, 396, 40, 40);
	display_hi_score();
}


static int game_loop() {
    // Main loop
	static int running = 1;
	SDL_Event event;
	while (running) {
		if (SDL_WaitEvent(&event)) {
			if (event.key.state == SDL_PRESSED) {
				if (event.key.keysym.sym == SDLK_ESCAPE
				|| event.key.keysym.sym == SDLK_F4
				|| event.key.keysym.sym == SDLK_F5 
				|| event.key.keysym.sym == SDLK_F6)
				running = 0;
			}
			game_lock();
			switch (event.type) { 
// Quit the game
			case SDL_QUIT:
				running = 0;
				break;
// Button pressed
			case SDL_MOUSEBUTTONDOWN:
				if (event.button.x < 46 && event.button.y > 396 && event.button.y < 438) {
					g_timer_mode ^= 1;
					timer_status();	
				} else if (event.button.x < 46 && event.button.y>438 && g_sound_on) {
					g_music_on ^= 1;
					if (g_music_on) {
						if (!snd_music_start())
							g_music_on = 0;
					} else 
						snd_music_stop();
					music_status();	
//20100104 Sound mute hack--Flandry
				} else if (event.button.x < 46 && event.button.y < 396 && event.button.y > 350) {
					g_sound_on ^= 1;
					if (!g_sound_on) {
						g_music_on = 0;
						snd_music_stop();
					}
					music_status();
//end hack
				} else if (event.button.x > BOARD_X && event.button.y > BOARD_Y &&
					 event.button.x < (BOARD_X + BOARD_W) &&
					 event.button.y < (BOARD_Y + BOARD_H) &&
					!gi_game_running)
					gweled_start_new_game(1);
				else if ( event.button.x > RESTART_X && event.button.y > RESTART_Y && 
					event.button.x < (RESTART_X + RESTART_W) && 
					event.button.y < (RESTART_Y + RESTART_H)) {
					gi_game_running = 0;
					gweled_start_new_game(0);
				} else if ( event.button.x > QUIT_X && event.button.y > QUIT_Y && 
					event.button.x < (QUIT_X + QUIT_W) && 
					event.button.y < (QUIT_Y + QUIT_H)) {
					running = 0;
				}
				else gweled_click(event.button.x, event.button.y);
	 	             	break;
			case SDL_MOUSEBUTTONUP:
//				fprintf(stderr,"Mouse up\n");
				gweled_release(event.button.x, event.button.y);
	                	break;
	            	}
			game_unlock();
		}
		
	}
	game_lock();
	if (gi_game_running)
		gweled_save_game();
	else
		remove(SAVE_PATH);	
	game_unlock();	
	return 0;
}

int main(int argc, char **argv)
{
	if (!(g_random_generator = g_rand_new_with_seed (time (NULL))))
		return 1;
	if (!(game_mutex = SDL_CreateMutex()))
		return 1;
	if (board_init())
		return 1;
	game_load_settings();
	if (gfx_init()) {
		gfx_done();
		return 1;
	}
	snd_init();
	gweled_draw_board ();
	gweled_draw_message ("get ready!");
	display_hi_score();
	display_current_score();
	music_status();
	timer_status();
	display_time(1.0);
//	display_time();
	gfx_update(0,0,800,480);
	gi_game_running = 0;
//	gweled_start_new_game(1);
//	gfx_draw_text("SCORE:", 480, 100, 1);
	SDL_SetTimer(20, callback);
	game_loop();
	game_lock();
	SDL_SetTimer(0, NULL);
	game_unlock();
	snd_done();
	gfx_done();
	g_rand_free (g_random_generator);
	game_save_settings();
	board_done();
	SDL_DestroyMutex(game_mutex);
	return 0;
}
