#!/usr/bin/python

from gvoice import *
from gvSMSPeople import Ui_MainWindow
from gvSMSMsg import Ui_MsgWindow
from gvAccount import *
import sys, os, time
import ConfigParser
from PyQt4.QtCore import *
from PyQt4.QtGui import *
import ctypes, sqlite3, uuid

# Information taken from:
# http://docs.python.org/library/uuid.html#uuid.uuid4
# http://docs.python.org/library/ctypes.html
# http://www.dalkescientific.com/writings/NBN/ctypes.html
# Class constructed from: http://maemo.gitorious.org/maemo-rtcom/rtcom-eventlogger/blobs/master/rtcom-eventlogger/event.h
# credits to gri for doing the hard work with this

class RTComElEvent(ctypes.Structure):
    _fields_ = [("_mask", ctypes.c_int),
                ("fld_id", ctypes.c_int),
                ("fld_service_id", ctypes.c_int),
                ("fld_event_type_id", ctypes.c_int),
                ("fld_storage_time", ctypes.c_long), # time_t
                ("fld_start_time", ctypes.c_long), # time_t
                ("fld_end_time", ctypes.c_long), # time_t
                ("fld_is_read", ctypes.c_int), # Boolean is int
                ("fld_flags", ctypes.c_int),
                ("fld_bytes_sent", ctypes.c_int),
                ("fld_bytes_received", ctypes.c_int),
                ("fld_local_uid", ctypes.c_char_p),
                ("fld_local_name", ctypes.c_char_p),
                ("fld_remote_uid", ctypes.c_char_p),
                ("fld_remote_name", ctypes.c_char_p),
                ("fld_remote_ebook_uid", ctypes.c_char_p),
                ("fld_channel", ctypes.c_char_p),
                ("fld_free_text", ctypes.c_char_p),
                ("fld_group_uid", ctypes.c_char_p),
                ("fld_service", ctypes.c_char_p),
                ("fld_event_type", ctypes.c_char_p),
                ("fld_additional_text", ctypes.c_char_p),
                ("fld_icon_name", ctypes.c_char_p),
                ("fld_pango_markup", ctypes.c_char_p)]

def put_to_sent_sms(name, number, uniqueid, groupid, message):
#    rtcom = ctypes.CDLL('librtcom-eventlogger.so.1') # PR 1.2
    rtcom = ctypes.CDLL('librtcom-eventlogger.so.0') # PR 1.1

    el = ctypes.cast(rtcom.rtcom_el_new(), ctypes.c_void_p)
    event = ctypes.cast(rtcom.rtcom_el_event_new(), ctypes.POINTER(RTComElEvent))[0]

    event._mask       |= 1 << 18
    event.fld_service  = 'RTCOM_EL_SERVICE_SMS'

    event._mask       |= 1 << 19
    event.fld_event_type = 'RTCOM_EL_EVENTTYPE_SMS_OUTBOUND'

    event._mask       |= 1 << 4
    event.fld_start_time = int(time.time())

    event._mask       |= 1 << 5
    event.fld_end_time = int(time.time())

    event._mask       |= 1 << 6
    event.fld_is_read = 1 # TRUE

    event._mask       |= 1 << 10
    event.fld_remote_ebook_uid = uniqueid

    event._mask       |= 1 << 11
    event.fld_local_uid = 'ring/tel/ring'

    event._mask       |= 1 << 12
    event.fld_local_name = '<SelfHandle>'

    event._mask       |= 1 << 13
    event.fld_remote_uid = number

    event._mask       |= 1 << 14
    event.fld_remote_name = name

    event._mask       |= 1 << 17
    event.fld_group_uid = groupid

    event._mask       |= 1 << 16
    event.fld_free_text = message.data()

    rtcom.rtcom_el_add_event.argtypes = [el, ctypes.c_void_p, ctypes.c_void_p]
    eventId = rtcom.rtcom_el_add_event(el, ctypes.byref(event), None)

    # the follwing block doesnt seem to be needed for SMS
    # Add the message that it shows up in conversations
    rtcom.rtcom_el_add_header.argtypes = [el, ctypes.c_int, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_void_p]
    rtcom.rtcom_el_add_header(el, eventId, 'message-token', str(uuid.uuid4()), None)

    rtcom.rtcom_el_event_free(ctypes.byref(event))

def write_to_rtcomm(message, number):
    connection = sqlite3.connect(os.path.join(os.environ['HOME'],
                                     '.rtcom-eventlogger', 'el.db'))
    cursor = connection.cursor()
    cursor.execute('SELECT id FROM Events')
    id_array = cursor.fetchall()
    seq_id = max(id_array)[0] + 1
        
    strippednumber = number[-7:]

    own_number = ""
        
    put_to_sent_sms(own_number, number, 0, strippednumber, message)

def octify(str):
    '''     
    Returns a list of octet bytes representing
    each char of the input str.               
    '''                                       

    bytes = map(ord, str)
    bitsconsumed = 0
    referencebit = 7
    octets = []
    bitstocopy = 0

    while len(bytes):
            byte = bytes.pop(0)
            byte = byte >> bitsconsumed
                                       
            try:
                    nextbyte = bytes[0]
                    bitstocopy = (nextbyte & (0xff >> referencebit)) << referencebit
                    octet = (byte | bitstocopy)

            except:
                    octet = (byte | 0x00)

            if bitsconsumed != 7:
                    octets.append(byte | bitstocopy)
                    bitsconsumed += 1
                    referencebit -= 1
            else:
                    bitsconsumed = 0
                    referencebit = 7

    return octets

def semi_octify(str):
    '''
    Expects a string containing two digits.
    Returns an octet -
    first nibble in the octect is the first
    digit and the second nibble represents
    the second digit.
    '''
    try:
            digit_1 = int(str[0])
            digit_2 = int(str[1])
            octet = (digit_2 << 4) | digit_1
    except:
            octet = (1 << 4) | digit_1

    return octet

def resetnumber(number):
        '''
        Adds trailing F to number if length is
        odd.
        '''
        length = len(number)
        if (length % 2) != 0:
            number = number + 'F'
        return number

def createPDUstring(number, msg):
    '''
    Returns a list of bytes to represent a valid PDU message
    '''
    octifiedmsg = octify(msg)
    number = resetnumber(number)
    octifiednumber = [ semi_octify(number[i:i+2]) for i in range(0, len(number), 2) ]
        
    HEADER = 1
    FIRSTOCTETOFSMSDELIVERMSG = 10
    ADDR_TYPE = 129 #unknown format
    number_length = len(number)
    msg_length = len(msg)
    pdu_message = [HEADER, FIRSTOCTETOFSMSDELIVERMSG, number_length, ADDR_TYPE]
    pdu_message.extend(octifiednumber)
    pdu_message.append(0)
    pdu_message.append(0)
    pdu_message.append(msg_length)
    pdu_message.extend(octifiedmsg)
    return pdu_message

# remove unnecessary characters from phone number
def cleansenumber(number):
    stripchars = '()- '
    
    cleannumber = number
    for c in stripchars:
        cleannumber = cleannumber.replace(c, "")
    return(cleannumber)


class SMS(object):
    '''
    Sends sms messages
    '''
    
    def __init__(self, msg, number):
        self.pdustring = createPDUstring(number, msg)
        write_to_rtcomm(msg, number)

    def send(self):
        self.__dbus_send(self.pdustring)

    def __dbus_send(self, pdu_string):
        import dbus
        bus = dbus.SystemBus()
        smsobject = bus.get_object('com.nokia.phone.SMS', '/com/nokia/phone/SMS/ba212ae1')
        smsiface = dbus.Interface(smsobject, 'com.nokia.csd.SMS.Outgoing')
        arr = dbus.Array(pdu_string)
        msgdeliver = dbus.Array([arr]) 
        smsiface.Send(msgdeliver,'')
        self.response = True

    def print_pdustring(self):
        print self.pdustring
        self.response = True

class MainWindow(QMainWindow, Ui_MainWindow):

    def __init__(self, parent=None):
        super(MainWindow, self).__init__(parent)
        self.setupUi(self)
        self.pushButtonNext.setEnabled(False)
        self.email = ""
        self.password = ""
        self.msgWindow = MsgWindow(self)
        self.msgWindow.hide()
        self.mobile_numbers = []

        #pyside 0.2.2 bug? auto-connect of signals is not working
        #self.connect(self.pushButtonSend, SIGNAL("released()"), self.on_pushButtonSend_released)

    def load_config(self, loadconfig=True):
        if loadconfig == True:
            try:
                config = ConfigParser.ConfigParser()
                config.readfp(open(os.path.expanduser('~') + '/.gvSMS'))
                try:
                    email = config.get("credentials", "email")
                    #self.email = base64.b64decode(email)
                    self.email = email
                    password = config.get("credentials", "password")
                    #self.password = base64.b64decode(password)
                    self.password = password
                except ConfigParser.NoSectionError:
                    self.prompt()
                except ConfigParser.NoOptionError:
                    self.prompt()
            except IOError:
                # couldn't find the file set uid so we can prompt info
                self.prompt()
        else:
            self.prompt()
        if len(self.email) > 0 and len(self.password) > 0:
            self.plainTextEditStatus.appendPlainText("Logging in...")
            QTimer.singleShot(40, self.login)

    def save_config(self):
        try:
            f = open(os.path.expanduser('~') + '/.gvSMS', 'w')
            f.write("[credentials]\n")
            #f.write("email = " + base64.b64encode(self.email) + "\n")
            #f.write("password = " + base64.b64encode(self.password) + "\n")
            f.write(str("email = " + self.email + "\n"))
            f.write(str("password = " + self.password + "\n"))
    	except IOError, e:
    		self.plainTextEditStatus.appendPlainText('failed to write config file')

    def prompt(self):
        mydialog = QtGui.QDialog(self)
        uidialog = Ui_Dialog()
        uidialog.setupUi(mydialog)
        uidialog.lineEditPassword.setEchoMode(QLineEdit.Password)
        uidialog.lineEditAccount.insert(self.email)
        uidialog.lineEditPassword.insert(self.password)
        mydialog.show()
        if mydialog.exec_():
            dialogaccount = uidialog.lineEditAccount.text()
            dialogpassword = uidialog.lineEditPassword.text()
            if len(dialogaccount) > 0 and len(dialogpassword) > 0:
                self.email = dialogaccount
                self.password = dialogpassword
                if uidialog.checkBox.isChecked():
                    self.save_config()
                else:
                    try:
                        f = open(os.path.expanduser('~') + '/.gvSMS', 'w')
                    except IOError, e:
                        self.plainTextEditStatus.appendPlainText('failed to remove config file')

        if len(self.email) == 0 or len(self.password) == 0:
            self.plainTextEditStatus.appendPlainText("No credentials supplied")

    def login(self):
        self.gv = GoogleVoiceLogin(self.email, self.password)
        if not self.gv.logged_in:
           self.plainTextEditStatus.appendPlainText("Could not log in with provided credentials")
        else:
            self.listWidgetGroups.clear()
            self.plainTextEditStatus.appendPlainText("Login successful!")
            # Use the ContactLoader to download Google Contacts
            contact_loader = ContactLoader(self.gv.opener)
            # Use the ContactSelector to select the group and
            # final list of contacts to contact
            self.contact_selector = ContactSelector(contact_loader.contacts_by_group_list)
            # save a copy to reload after any deletes
            #self.save_contacts_by_group_list = copy.deepcopy(contact_loader.contacts_by_group_list)
            group_list = self.contact_selector.get_group_list()
            for group_item in group_list:
                self.listWidgetGroups.addItem(group_item[1])

    def on_listWidgetGroups_itemClicked(self, item):
        # reload original list in case user has deleted any
        #local_contacts_by_group_list = copy.deepcopy(ui.save_contacts_by_group_list)
        #self.contact_selector = ContactSelector(local_contacts_by_group_list)
        selected_group = self.listWidgetGroups.row(item) + 1
        self.contact_selector.set_selected_group(selected_group)
        self.listWidgetPeople.clear()
        self.mobile_numbers = []
        for contact_item in self.contact_selector.get_contacts_list():
            lwi = QListWidgetItem('%s' % contact_item[1], self.listWidgetPeople)
            lwi.setFlags(Qt.ItemIsEnabled)
            lwi.setCheckState(Qt.Checked)
            self.mobile_numbers.append(cleansenumber(contact_item[1].mobile))
            #self.listWidgetPeople.addItem('%s' % contact_item[1])
        if self.listWidgetPeople.count() > 0:
           self.pushButtonNext.setEnabled(True)
        else:
             self.pushButtonNext.setEnabled(False)

    def on_listWidgetPeople_itemClicked(self, item):
        if item.flags() & Qt.ItemIsEnabled:
            item.setCheckState(Qt.Unchecked)
            item.setFlags(Qt.NoItemFlags)
        else:
            item.setCheckState(Qt.Checked)
            item.setFlags(Qt.ItemIsEnabled)
        
        '''
        reply = QtGui.QMessageBox.question(self, 'Remove?',
        "Remove " + '%s' % item.text() + " from list?", QtGui.QMessageBox.Yes, QtGui.QMessageBox.No)
        if reply == QtGui.QMessageBox.Yes:
           index = self.listWidgetPeople.row(item)
           self.listWidgetPeople.takeItem(index)
           contact_list = [index+1]
           self.contact_selector.remove_from_contact_list(contact_list)
           if self.listWidgetPeople.count() > 0:
              self.pushButtonNext.setEnabled(True)
           else:
              self.pushButtonNext.setEnabled(False)
        '''

    @QtCore.pyqtSlot()
    def on_actionLog_In_triggered(self):
        if not self.gv.logged_in:
            self.load_config(False)
        else:
            self.plainTextEditStatus.appendPlainText("Currently logged in") 
        
    def on_pushButtonNext_released(self):
        self.msgWindow.show()

class MsgWindow(QMainWindow, Ui_MsgWindow):

    def __init__(self, parent=None):
        super(MsgWindow, self).__init__(parent)
        self.setupUi(self)
        self.radioButtonPhone.setChecked(True)
        self.pushButtonSend.setEnabled(False)
        # fix up the LCD color
        palette = self.lcdNumberCharacterCount.palette();
        palette.setColor(QPalette.Normal, QPalette.Foreground, Qt.red);
        palette.setColor(QPalette.Normal, QPalette.Background, Qt.black);
        palette.setColor(QPalette.Normal, QPalette.Light, Qt.white);
        palette.setColor(QPalette.Normal, QPalette.Dark, Qt.lightGray);
        self.lcdNumberCharacterCount.setPalette(palette);

    def on_pushButtonSend_released(self):
        text_sender = TextSender(ui.gv.opener, ui.gv.key)
        text_sender.text = self.plainTextEditMessage.toPlainText()
        
        itemcount = ui.listWidgetPeople.count()
        i = 0
        while i < itemcount:
            number = ui.mobile_numbers[i]
            thisitem = ui.listWidgetPeople.item(i)
            name = thisitem.text()
            if thisitem.flags() & Qt.ItemIsEnabled:
                if number == '':
                    self.plainTextEditStatus.appendPlainText('%s does not have a mobile number' % name)
                else:
                    message = 'Sending message to %s at %s...' % (name, number)
                    if self.radioButtonPhone.isChecked():
                        sms = SMS(text_sender.text.toAscii(), number)
                        sms.send()
                        #sms.print_pdustring()
                        sending_result = sms.response
                    else: #send via Google
                      text_sender.send_text(number)
                      sending_result = text_sender.response
                    if sending_result:
                        self.plainTextEditStatus.appendPlainText(message + "Success!")
                    else:
                        self.plainTextEditStatus.appendPlainText(message + "Failed!!")
                    time.sleep(3)
            i = i + 1
            
        '''
        for contact in ui.contact_selector.get_contacts_list():
            number = contact[1].mobile
            if number == '':
               self.plainTextEditStatus.appendPlainText('%s does not have a mobile number' % contact[1])
            else:
                 message = 'Sending message to %s at %s...' % (contact[1], contact[1].mobile)
                 if self.radioButtonPhone.isChecked():
                    sms = SMS(text_sender.text.toAscii(), contact[1].mobile)
                    sms.send()
                    #sms.print_pdustring()
                    sending_result = sms.response
                 else: #send via Google
                      text_sender.send_text(contact[1].mobile)
                      sending_result = text_sender.response
                 if sending_result:
                    self.plainTextEditStatus.appendPlainText(message + "Success!")
                 else:
                      self.plainTextEditStatus.appendPlainText(message + "Failed!!")
        '''

    def on_plainTextEditMessage_textChanged(self):
        message = self.plainTextEditMessage.toPlainText()
        self.lcdNumberCharacterCount.display(message.length())
        if (message.length() > 0):
           self.pushButtonSend.setEnabled(True)
        else:
             self.pushButtonSend.setEnabled(False)


if __name__ == "__main__":
    import sys
    app = QtGui.QApplication(sys.argv)
    ui = MainWindow()
    ui.show()
    QTimer.singleShot(50, ui.load_config)
    sys.exit(app.exec_())
