#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

#include <libsoup/soup.h>
#include <hildon/hildon.h>

#include "lang.h"

char translated_text[100];
GtkWidget* input;
GtkWidget* output;

GtkWidget* src_lang;
GtkWidget* tra_lang;

GtkWidget* window;
GtkWidget* button;
GtkWidget* table;
GtkWidget* hbox;
HildonAppMenu* menu;

/* FOR DIALOG */
GtkWidget* treeview;
GtkTreeViewColumn* column = NULL;
GtkWidget* dialog;

int i;

/* Converts an integer value to its hex character*/
char to_hex(char code) {
	static char hex[] = "0123456789abcdef";
	return hex[code & 15];
}

/* Returns a url-encoded version of str */
/* IMPORTANT: be sure to free() the returned string after use */
char *url_encode(char *str)
{
	char *pstr = str, *buf = malloc(strlen(str) * 3 + 1), *pbuf = buf;
	while (*pstr)
	{
		if (isalnum(*pstr) || *pstr == '-' || *pstr == '_' || *pstr == '.' || *pstr == '~') 
			*pbuf++ = *pstr;
		else if (*pstr == ' ') 
			*pbuf++ = '+';
		else 
			*pbuf++ = '%', *pbuf++ = to_hex(*pstr >> 4), *pbuf++ = to_hex(*pstr & 15);
		pstr++;
	}
	
	*pbuf = '\0';
	
	return buf;
}

/*char* url_encode(char *string)
{
        char *target;
	int i,j;
	//char k;
	target=malloc(strlen(string)*3 + 2);
	i=j=0;
	while(string[i]!=0)
	{
		if(isalnum(string[i]))
		{
			target[j]=string[i];
			j++;
		}
		else if(string[i]==' ')
		{
			target[j]='+';
			j++;
		}
		else
		{
			sprintf(&target[j],"%%%02x",string[i]);
			j+=3;
		}
		i++;
	}
	
	target[j]=0;
	return target;
}*/

gchar *replace(gchar *str, gchar *oldchaine, gchar *newchaine)
{
	gchar *wstr,*temp,*pos;
	
	if (str==NULL || strlen(oldchaine)==0) {return NULL; }
	wstr=(gchar *) strdup(str);
	//free(str);
	
	while ((pos=strstr(wstr,oldchaine))!=NULL)
	{
		//pos=strstr(wstr,oldchaine);
		temp=(gchar*) malloc(strlen(wstr)-strlen(oldchaine)+strlen(newchaine)+1);
		strncpy(temp,wstr,pos-wstr);
		temp[pos-wstr]=0;
		strcat(temp,newchaine);
		strcat(temp,pos+strlen(oldchaine)),
		temp[strlen(wstr)-strlen(oldchaine)+strlen(newchaine)]=0;
		free(wstr);
		wstr=temp;
	}
	
	return wstr;
}

static void get(GtkWidget* widget, gpointer data)
{
	//printf("Button pressed!\n");
	
	static SoupSession *session;
	const char *cafile = NULL;
	const char *name;
	
	session = soup_session_async_new_with_options (
		SOUP_SESSION_SSL_CA_FILE, cafile,
		SOUP_SESSION_USER_AGENT, "get ",
		NULL);
		
	SoupMessage *msg;
	
	GtkTextBuffer *buffer;
	GtkTextIter start;
	GtkTextIter end;
	gchar* input_text;

	buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(input));
	
	gtk_text_buffer_get_start_iter(buffer, &start);
	gtk_text_buffer_get_end_iter  (buffer, &end);
	input_text = gtk_text_buffer_get_text(buffer, &start, &end, FALSE);
	//printf("%s\n", input_text);
	
	char* encoded = url_encode(input_text);
	//printf("Encoded: %s\n", encoded);
	
	g_free(input_text);
	
	gchar* url = g_strdup_printf("http://ajax.googleapis.com/ajax/services/language/translate?q=%s&v=1.0&langpair=%s|%s",
		encoded,
		languages[src_lang_num].str_short,
		languages[tra_lang_num].str_short);
		
	//printf("%s\n", url);
	
	free(encoded);
	
	//sprintf(url, "http://ajax.googleapis.com/ajax/services/language/translate?q=\"%s\"&v=1.0&langpair=fi|en", input_text);

	msg = soup_message_new("GET", url);
	soup_session_send_message (session, msg);
	name = soup_message_get_uri (msg)->path;
	
	if (!msg)
	{
		GtkWidget *banner;
		banner = hildon_banner_show_information(NULL, NULL, "Cannot connect to Google Translate!");
		hildon_banner_set_timeout(HILDON_BANNER(banner), 5000);
	}
	
	g_free(url);
	
	//printf ("%s: %d %s\n", name, msg->status_code, msg->reason_phrase);
	
	//fwrite(msg->response_body->data, 1, msg->response_body->length, stdout);
	
	//{"responseData": null, "responseDetails": "invalid translation language pair", "responseStatus": 400}
	//printf("%s\n", msg->response_body->data);
	
	buffer = gtk_text_buffer_new(NULL);
	
	sscanf(msg->response_body->data, "%*s {\"translatedText\":\"%[^'\"']}, %*s", translated_text);
	
	gchar* tmp = strdup(translated_text);
	tmp = replace(tmp, "\\u0026quot;", "\"");
	tmp = replace(tmp, "\\u0026gt;",   ">");
	tmp = replace(tmp, "\\u0026lt;",   "<");
	tmp = replace(tmp, "\\u003d",      "=");
	tmp = replace(tmp, "\\u003c",      "@");
	tmp = replace(tmp, "\\u0026#39;",  "'");
	tmp = replace(tmp, "\\u0026amp;",  "&");
	
	//printf("Got this: %s\n", tmp/*translated_text*/);
	
	//translated_text = (char*)msg->response_body->data;
	
	/*char* tmp_text = strtok((char*)msg->response_body->data, "\"");
	
	while (tmp_text != NULL)
	{
		if (strcmp(tmp_text, "translatedText") == 0)
		{
			//printf("%s\n", tmp_text);
			tmp_text = strtok(NULL, "\"");
			tmp_text = strtok(NULL, "\"");
			gtk_text_buffer_set_text(buffer, tmp_text, -1);
			break;
		}
		tmp_text = strtok(NULL, "\"");
	}*/
	
	gtk_text_buffer_set_text(buffer, tmp, -1);
                               
	gtk_text_view_set_buffer(GTK_TEXT_VIEW(output), buffer);
	
	g_free(tmp);
}

static void row_activated_callback(GtkWidget *tree_view, GtkTreePath *path, GtkTreeViewColumn *column, gpointer user_data)
{
	/* Get the index number od the selected item */
	gint index = (gtk_tree_path_get_indices(path))[0];
	//g_print ("row-activated emitted. %d\n", index);
	
	/* Then save the value */
	if ((gint)user_data == 1)
	{
		g_object_ref(flags[index]);
		hildon_button_set_image(HILDON_BUTTON(src_lang), flags[index]);
		hildon_button_set_value(HILDON_BUTTON(src_lang), languages[index].str_long);
		src_lang_num = index;
	}
	else
	{
		tra_lang_num = index;
		g_object_ref(flags2[index]);
		hildon_button_set_image(HILDON_BUTTON(tra_lang), flags2[index]);
		hildon_button_set_value(HILDON_BUTTON(tra_lang), languages[index].str_long);
	}
	
	/* Close dialog */
	gtk_widget_destroy(dialog);
}

static void create_selector(GtkWidget* widget, gint data)
{
	//GtkWidget *selector;
	/*GtkListStore* flags_store;
	GtkCellRenderer* renderer;
	GtkCellRenderer* renderer2;
	
	flags_store = gtk_list_store_new(2, G_TYPE_STRING, GDK_TYPE_PIXBUF);
	
	treeview = hildon_gtk_tree_view_new(HILDON_UI_MODE_NORMAL);

	//selector = hildon_touch_selector_new(); //hildon_touch_selector_new_text();
	
	renderer2 = gtk_cell_renderer_pixbuf_new();
                                               
	column = gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(treeview),
                                               -1,      
                                               "Flag",  
                                               renderer2,
                                               "pixbuf", 1,
                                               NULL);
	
	renderer = gtk_cell_renderer_text_new();
	
	column = gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(treeview),
                                               -1,      
                                               "Name",  
                                               renderer,
                                               "text", 0,
                                               NULL);

	//GtkTreeSelection* selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(treeview));
	//g_signal_connect(selection, "changed", G_CALLBACK(on_changed), NULL);
		
	//g_signal_connect_swapped(G_OBJECT(treeview), "hildon-row-tapped", G_CALLBACK(treeview_tap), selection);
	
	g_signal_connect(G_OBJECT(treeview), "row-activated", G_CALLBACK(row_activated_callback), (gpointer)data);

	for (i = 0; i < 42; i++)
	{
		GtkTreeIter iter;
		
		gtk_list_store_append(flags_store, &iter);
		gtk_list_store_set(flags_store, &iter,
					0, languages[i].str_long,
					//1, 0 pflags[i],
					-1);
	}
	
	gtk_tree_view_set_model(GTK_TREE_VIEW(treeview), GTK_TREE_MODEL(flags_store));*/

	//g_object_unref(GTK_TREE_MODEL(flags_store));
	
	//for (i = 0; i < 42; i++)
	//{
	//	hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR(selector), languages[i].str_long);
	//}
	
	GtkCellRenderer *renderer;
	GtkCellRenderer *renderer2;
	GtkTreeModel    *model;
	GtkWidget       *view;
	
	GtkListStore   *store;
	GtkTreeIter     iter;
	
	view = gtk_tree_view_new();
	
	renderer2 = gtk_cell_renderer_pixbuf_new();
	gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW (view),
							-1,
							"Flag",  
							renderer2,
							"pixbuf", 1,
							NULL);	
	
	renderer = gtk_cell_renderer_text_new();
	gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW (view),
							-1,
							"Name",  
							renderer,
							"text", 0,
							NULL);
	
	store = gtk_list_store_new(2, G_TYPE_STRING, GDK_TYPE_PIXBUF);
	
	for (i = 0; i < 51; i++)
	{
		//GdkPixbuf* pixbuf = gdk_pixbuf_copy(pflags[i]);
	
		gtk_list_store_append(store, &iter);
		gtk_list_store_set(store, &iter,
				   0, languages[i].str_long,
				   1, pflags[i],
				   -1);
				   
		//g_object_unref(pflags[i]);
	}
	
	model = GTK_TREE_MODEL(store);
	gtk_tree_view_set_model(GTK_TREE_VIEW(view), model);
	
	g_signal_connect(G_OBJECT(view), "row-activated", G_CALLBACK(row_activated_callback), (gpointer)data);
	
	g_object_unref(model);
	
	GtkWidget* scroll = hildon_pannable_area_new();
	gtk_widget_set_size_request(scroll, 800, 300);
	
	dialog = gtk_dialog_new();
	gtk_window_set_transient_for(GTK_WINDOW (dialog), GTK_WINDOW (window));
	gtk_window_set_title(GTK_WINDOW (dialog), "Select a language");
	
	gtk_container_add(GTK_CONTAINER(scroll), view);
	//hildon_pannable_area_add_with_viewport(HILDON_PANNABLE_AREA(scroll), treeview);
	gtk_container_add(GTK_CONTAINER(gtk_dialog_get_content_area(GTK_DIALOG(dialog))), scroll);
	
	gtk_widget_show_all(GTK_WIDGET(dialog));
	gtk_dialog_run(GTK_DIALOG(dialog));

	//return selector;
}

/*static HildonAppMenu* create_menu()
{
	HildonAppMenu* menu = HILDON_APP_MENU(hildon_app_menu_new());
	GtkWidget* button;
	
	button = hildon_gtk_button_new(HILDON_SIZE_AUTO);
	gtk_button_set_label(GTK_BUTTON (button), "Change Font");
	//g_signal_connect_after(button, "clicked", G_CALLBACK(menu_button_clicked), label);
	hildon_app_menu_append(HILDON_APP_MENU(menu), GTK_BUTTON(button));
	
	gtk_widget_show_all(GTK_WIDGET(menu));
	
	return menu;
}*/

int main(int argc, char *argv[])
{
	g_thread_init(NULL);

	hildon_gtk_init(&argc, &argv);
	
	for (i = 0; i < 51; i++)
	{
		gchar* filename = g_strdup_printf(DATAPREFIX"/%s.png", languages[i].str_short);
		//g_print("%s\n", filename);
		GError *error = NULL;
		
		//flags[i]  = gtk_image_new_from_file(filename);
		//flags2[i] = gtk_image_new_from_file(filename);
		pflags[i] = gdk_pixbuf_new_from_file(filename, &error);
		
		if (error)
		{
			g_critical ("Could not load pixbuf: %s\n", error->message);
			g_error_free(error);
		}
		
		g_free(filename);
		
		flags[i] = gtk_image_new_from_pixbuf(pflags[i]);
		flags2[i] = gtk_image_new_from_pixbuf(pflags[i]);
	}
	
	//menu = create_menu();

	window = hildon_window_new();
	gtk_window_set_title(GTK_WINDOW(window), "gTranslate");
	gtk_container_set_border_width(GTK_CONTAINER(window), 4);
	//hildon_window_set_app_menu(HILDON_WINDOW(window), HILDON_APP_MENU(menu));
	
	table = gtk_table_new(2, 200, FALSE);
	//gtk_table_set_row_spacings(GTK_TABLE(table), 10);
	//gtk_table_set_col_spacings(GTK_TABLE(table), 10);
	
	//GtkWidget* src_selector = create_selector();
	//GtkWidget* tar_selector = create_selector();
	
	src_lang = hildon_button_new(HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
	hildon_button_set_title (HILDON_BUTTON(src_lang), "Source Language");
        //hildon_button_set_image(HILDON_BUTTON(src_lang), flags[1]);
        //hildon_picker_button_set_selector(HILDON_PICKER_BUTTON(src_lang), HILDON_TOUCH_SELECTOR(src_selector));
	//g_signal_connect(G_OBJECT(src_lang), "value-changed", G_CALLBACK(on_picker_value_changed), NULL);
	g_signal_connect(G_OBJECT(src_lang), "clicked", G_CALLBACK(create_selector), (gpointer)1);
	//hildon_picker_button_set_active(HILDON_PICKER_BUTTON(src_lang), 10);
                                		
	/*tra_lang = hildon_button_new_with_text(HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT,
                                		HILDON_BUTTON_ARRANGEMENT_VERTICAL,
                                		"Target Language", "Swedish");
        hildon_button_set_image(HILDON_BUTTON(tra_lang), flags[2]);*/
        
	tra_lang = hildon_button_new(HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
	hildon_button_set_title (HILDON_BUTTON(tra_lang), "Target Language");
	
	g_object_ref(flags[src_lang_num]);
	hildon_button_set_image(HILDON_BUTTON(src_lang), flags[src_lang_num]);
	hildon_button_set_value(HILDON_BUTTON(src_lang), languages[src_lang_num].str_long);

	g_object_ref(flags2[tra_lang_num]);
	hildon_button_set_image(HILDON_BUTTON(tra_lang), flags2[tra_lang_num]);
	hildon_button_set_value(HILDON_BUTTON(tra_lang), languages[tra_lang_num].str_long);
	
        //hildon_button_set_image(HILDON_BUTTON(tra_lang), flags[1]);
        //hildon_picker_button_set_selector(HILDON_PICKER_BUTTON(tra_lang), HILDON_TOUCH_SELECTOR(tar_selector));
	//g_signal_connect(G_OBJECT(tra_lang), "value-changed", G_CALLBACK(on_picker_value_changed2), NULL);
	g_signal_connect(G_OBJECT(tra_lang), "clicked", G_CALLBACK(create_selector), (gpointer)2);
	//hildon_picker_button_set_active(HILDON_PICKER_BUTTON(tra_lang), 13);
	
	/*src_lang = gtk_combo_box_new_text();
	tra_lang = gtk_combo_box_new_text();*/
	
	//int i;
	
	/*for (i = 0; i < 4; i++)
	{
		gtk_combo_box_append_text(GTK_COMBO_BOX(src_lang), languages[i].str_long);
		gtk_combo_box_append_text(GTK_COMBO_BOX(tra_lang), languages[i].str_long);
	}*/
	
	hbox = gtk_hbox_new(TRUE, 0);
	
	input  = hildon_text_view_new();
	hildon_gtk_text_view_set_placeholder_text(GTK_TEXT_VIEW(input), "Type the text here");
	
	output = hildon_text_view_new();
	hildon_gtk_text_view_set_placeholder_text(GTK_TEXT_VIEW(output), "Translated text will be here...");
	
	gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(input),  GTK_WRAP_WORD);
	gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(output), GTK_WRAP_WORD);
	
	GtkWidget* input_scroll  = hildon_pannable_area_new();
	GtkWidget* output_scroll = hildon_pannable_area_new();
	
	//gtk_container_add(GTK_CONTAINER(input_scroll),  input);
	//gtk_container_add(GTK_CONTAINER(output_scroll), output);
	hildon_pannable_area_add_with_viewport(HILDON_PANNABLE_AREA(input_scroll),  input);
	hildon_pannable_area_add_with_viewport(HILDON_PANNABLE_AREA(output_scroll), output);
	
	gtk_box_pack_start(GTK_BOX(hbox), input_scroll,  FALSE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), output_scroll, FALSE, TRUE, 0);
	
	button = hildon_button_new_with_text(HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT,
                                		HILDON_BUTTON_ARRANGEMENT_VERTICAL,
                                		"Translate", NULL);
	g_signal_connect_swapped(G_OBJECT(button), "clicked", G_CALLBACK(get), NULL);
	
	gtk_table_attach_defaults(GTK_TABLE(table), src_lang, 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), tra_lang, 1, 2, 0, 1);
	/*gtk_table_attach_defaults(GTK_TABLE(table), input,    0, 1, 1, 9);
	gtk_table_attach_defaults(GTK_TABLE(table), output,   1, 2, 1, 9);*/
	gtk_table_attach_defaults(GTK_TABLE(table), hbox,     0, 2, 1, 199);
	gtk_table_attach_defaults(GTK_TABLE(table), button,   0, 2, 199,200);
	
	gtk_container_add(GTK_CONTAINER(window), table);
	gtk_widget_show_all(window);

	g_signal_connect_swapped(G_OBJECT(window), "destroy", G_CALLBACK(gtk_main_quit), NULL);

	gtk_main();

	return 0;
}

