// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_EVENTBOX_H
#define _GTKMM_EVENTBOX_H


#include <glibmm.h>

/* $Id$ */

/* eventbox.h
 * 
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/bin.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkEventBox GtkEventBox;
typedef struct _GtkEventBoxClass GtkEventBoxClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class EventBox_Class; } // namespace Gtk
namespace Gtk
{

/** Event capturing box.
 *
 * This widget adds an X Window where one does not
 * normally appear, allowing you to capture events.
 * It will receive any event which is specified
 * with set_events().
 *
 * This widget is generally used to add Gtk::Tooltips, button presses,
 * and clipping to widgets derived from Gtk::Misc.
 *
 * @ingroup Widgets
 */

class EventBox : public Bin
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef EventBox CppObjectType;
  typedef EventBox_Class CppClassType;
  typedef GtkEventBox BaseObjectType;
  typedef GtkEventBoxClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~EventBox();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class EventBox_Class;
  static CppClassType eventbox_class_;

  // noncopyable
  EventBox(const EventBox&);
  EventBox& operator=(const EventBox&);

protected:
  explicit EventBox(const Glib::ConstructParams& construct_params);
  explicit EventBox(GtkEventBox* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkEventBox*       gobj()       { return reinterpret_cast<GtkEventBox*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkEventBox* gobj() const { return reinterpret_cast<GtkEventBox*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

public:
  EventBox();

  
  /** Return value: <tt>true</tt> if the event box window is visible
   * @return <tt>true</tt> if the event box window is visible
   * 
   * @newin{2,4}.
   */
  bool get_visible_window() const;
  
  /** Set whether the event box uses a visible or invisible child
   * window. The default is to use visible windows.
   * 
   * In an invisible window event box, the window that the
   * event box creates is a Gdk::INPUT_ONLY window, which 
   * means that it is invisible and only serves to receive
   * events.
   * 
   * A visible window event box creates a visible (Gdk::INPUT_OUTPUT)
   * window that acts as the parent window for all the widgets  
   * contained in the event box.
   * 
   * You should generally make your event box invisible if
   * you just want to trap events. Creating a visible window
   * may cause artifacts that are visible to the user, especially
   * if the user is using a theme with gradients or pixmaps.
   * 
   * The main reason to create a non input-only event box is if
   * you want to set the background to a different color or
   * draw on it.
   * 
   * &lt;note&gt;
   * There is one unexpected issue for an invisible event box that has its
   * window below the child. (See set_above_child().)
   * Since the input-only window is not an ancestor window of any windows
   * that descendent widgets of the event box create, events on these 
   * windows aren't propagated up by the windowing system, but only by GTK+.
   * The practical effect of this is if an event isn't in the event
   * mask for the descendant window (see Gtk::Widget::add_events()),  
   * it won't be received by the event box. 
   * 
   * This problem doesn't occur for visible event boxes, because in
   * that case, the event box window is actually the ancestor of the
   * descendant windows, not just at the same place on the screen.
   * &lt;/note&gt;
   * 
   * @newin{2,4}
   * @param visible_window Boolean value.
   */
  void set_visible_window(bool visible_window = true);
  
  /** Return value: <tt>true</tt> if the event box window is above the window
   * @return <tt>true</tt> if the event box window is above the window
   * of its child.
   * 
   * @newin{2,4}.
   */
  bool get_above_child() const;
  
  /** Set whether the event box window is positioned above the windows of its child,
   * as opposed to below it. If the window is above, all events inside the
   * event box will go to the event box. If the window is below, events
   * in windows of child widgets will first got to that widget, and then
   * to its parents.
   * 
   * The default is to keep the window below the child.
   * 
   * @newin{2,4}
   * @param above_child <tt>true</tt> if the event box window is above the windows of its child.
   */
  void set_above_child(bool above_child = true);

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the event box is visible
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_visible_window() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the event box is visible
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_visible_window() const;
#endif //#GLIBMM_PROPERTIES_ENABLED
 
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the event-trapping window of the eventbox is above the window of the child widget as opposed to below it.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_above_child() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the event-trapping window of the eventbox is above the window of the child widget as opposed to below it.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_above_child() const;
#endif //#GLIBMM_PROPERTIES_ENABLED
 

};

} /* namespace Gtk */


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::EventBox
   */
  Gtk::EventBox* wrap(GtkEventBox* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_EVENTBOX_H */

