#ifndef _ENTRIES_WINDOW_H
#define _ENTRIES_WINDOW_H

#include <QMainWindow>
#include <QListView>
#include <QStyledItemDelegate>
#include "googlereader.h"

class EntriesWindow : public QMainWindow {
	Q_OBJECT

	public:
		EntriesWindow(QWidget *parent = 0, Feed *f = 0);
		virtual ~EntriesWindow();

	private slots:
		void sync();
		void markRead();
		void entriesUpdated();
		void entrySelected(const QModelIndex &);

	private:
		QListView *list;
		QAction *show_all;
		QAction *show_updated;
		Feed *feed;
};

class EntryListModel : public QAbstractListModel {
	Q_OBJECT

	public:
		EntryListModel(QObject *parent = 0, QList<Entry *>list = QList<Entry *>(), bool updated = false)
			: QAbstractListModel(parent) {
			entry_list = list;
			show_updated = updated;
		}

		int rowCount(const QModelIndex &model = QModelIndex()) const;

		QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const;

	public slots:
		void showUpdated(bool);

	private:
		QList<Entry *> entry_list;
		bool show_updated;
};

class EntryListDelegate : public QStyledItemDelegate {
	Q_OBJECT

	public:
		EntryListDelegate(QObject *parent = 0) 
			: QStyledItemDelegate(parent) {};
			   
		void paint(QPainter *painter, const QStyleOptionViewItem &option,
			const QModelIndex &index) const;
};

#endif

