//    GroupSMS
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#ifndef CONTACTSWINDOW_H
#define CONTACTSWINDOW_H

#include <QDialog>
#include <QTimer>
#ifdef Q_OS_SYMBIAN
    #include <applications/qtcontacts.h>
    using namespace QtMobility;
#endif
#ifdef Q_WS_MAEMO_5
    #include "qtcontacts.h"
    using namespace QtMobility;
#endif
#include "contact.h"
#include "group.h"

namespace Ui {
    class ContactsWindow;
}

class ContactsWindow : public QDialog
{
    Q_OBJECT

public:
    explicit ContactsWindow(QWidget *parent = 0, Group* group=0);
    ~ContactsWindow();

    void Init();
    QList<Contact*> GetSelectedContacts();
    void FillContactsList();

private:
    Ui::ContactsWindow *ui;

    Group* m_Group;
    QTimer* m_Timer;
    QList<Contact*> m_Contacts;
    QList<Contact*> m_Selected;
    void AddContactToList(Contact* c, int index, QPixmap* defaultImage);

private slots:
    void TimerSlot();
    void CercaSlot();
    void ClearSlot();
    void OkSlot();
    void ContactDoubleClicked();
};

#endif // CONTACTSWINDOW_H
