#ifndef ROMINFO_H
#define ROMINFO_H

#include <QString>
#include <QFile>

#include <zlib.h>

class RomInfo
{
public:
    RomInfo(QString romFile);

    bool isAvailable();

    QString title();
    QString code();
    QString maker();

private:
    QString m_title;
    QString m_code;
    QString m_maker;

    void extractGba(QString romFile);
    void extractZip(QString romFile);

    void parseRomInfo(const char *data);
};

#endif // ROMINFO_H
