#include "keys.h"



void sh_key::keyPressEvent ( QKeyEvent * event ){
this->setText(QString("%1").arg(event->nativeScanCode()));
event->ignore();
}

sh_key::sh_key(QWidget *parent) :
        QLineEdit(parent)
{
    this->setAlignment(Qt::AlignCenter);
}



keys::keys(QWidget *parent) :
        QWidget(parent)
{

 ks=QStringList()<<tr("Up")<<tr("Left")<<tr("Down")<<tr("Right")
                 <<tr("Start")<<tr("Select")
                 <<tr("L")<<tr("R")<<tr("A")<<tr("B")
                 <<tr("Fast forward")
                 <<tr("Up+Left")<<tr("Up+Right")
                 <<tr("Down+Left")<<tr("Down+Right")
                 <<tr("Load")<<tr("Save")
                 <<tr("Quit");

this->setWindowFlags(this->windowFlags() | Qt::Window);
this->setAttribute(Qt::WA_Maemo5StackedWindow);
QScrollArea *area=new QScrollArea(this);
QVBoxLayout *lay=new QVBoxLayout(this);
lay->addWidget(area);
QWidget *wg=new QWidget();
area->setWidget(wg);
wg->setMinimumSize(600,1200);
QGridLayout *grid=new QGridLayout(wg);
wg->show();
area->show();
grid->setHorizontalSpacing(25);
grid->setVerticalSpacing(25);




// load current

QFile file("/opt/gpspm/conf.gpsp");
if (!file.open(QIODevice::ReadOnly | QIODevice::Text)){
    QMessageBox msg;
    msg.setText(tr("Couldn't open previous key config"));
    msg.exec();
}

int o=0;
     QTextStream in(&file);
     while ((o<ks.count())) {
         QString line="0";
         if (!in.atEnd())
         line = in.readLine();

         QLabel *lbl=new QLabel(ks.at(o),wg);
         grid->addWidget(lbl,o,1,1,1);

         nkey[o]=new sh_key(wg);
         nkey[o]->setParent(wg);
         nkey[o]->setMinimumSize(150,60);

         grid->addWidget(nkey[o],o,0,1,1);
         grid->setRowMinimumHeight(o,80);
         nkey[o]->show();
         nkey[o]->setText(line.trimmed());
         o++;
     }

}
void keys::hideEvent(QHideEvent *){
    if (!this->isVisible()){
        QDialog *dlg=new QDialog(this);
        QGridLayout *lay=new QGridLayout(dlg);
        QLabel *lbl=new QLabel(tr("Do you want to save settings?"),dlg);
        lay->addWidget(lbl,1,0,1,2);
        QPushButton *yes=new QPushButton(tr("Yes"),dlg);
        QPushButton *no=new QPushButton(tr("No"),dlg);
        connect (yes,SIGNAL(clicked()),dlg,SLOT(accept()));
        connect (no,SIGNAL(clicked()),dlg,SLOT(reject()));
        connect (dlg,SIGNAL(accepted()),this,SLOT(save()));
        lay->addWidget(yes,2,0);
        lay->addWidget(no ,2,1);
        dlg->exec();
    }
}

void keys::save(){
QString sv="";
for (int i=0;i<ks.count();i++)
    sv=sv+QString("%1\n").arg(nkey[i]->text());

QFile file("/opt/gpspm/conf.gpsp");
if (!file.open(QIODevice::WriteOnly | QIODevice::Text)){
    QMessageBox msg;
    msg.setText("Somethings goes wrong, check permission to keys file");
    msg.exec();
    return;}

     QTextStream out(&file);
     out <<sv;

}

keys::~keys()
{

}
