/*
  GPSJinni - show raw data from the GPS subsystem.
  Copyright (C) 2010  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "Speed.h"

#include <Lum/OS/Font.h>

#include "Util.h"

Speed::Speed()
{
  // no code
}

bool Speed::SetModel(Lum::Base::Model* model)
{
  this->model=dynamic_cast<Lum::Model::Double*>(model);

  Lum::Control::SetModel(this->model);

  return this->model.Valid();
}

void Speed::CalcSize()
{
  width=25;
  height=25;

  minWidth=width;
  minHeight=height;

  Lum::Control::CalcSize();
}

void Speed::Draw(int x, int, size_t w, size_t h)
{
  Lum::Control::Draw(x,y,w,h);

  if (!Intersect(x,y,w,h)) {
    return;
  }

  /* --- */

  std::wstring       value;
  std::wstring       unit;
  Lum::OS::DrawInfo  *draw=GetDrawInfo();
  Lum::OS::FontRef   font=Lum::OS::display->GetFont();
  Lum::OS::FontRef   bigFont=Lum::OS::display->GetFont(750);
  size_t             valueWidth;

  if (!model.Valid() || model->IsNull()) {
    value=L"-,--";
    unit=L"m/s";
  }
  else if (model->Get()>=1/3.6) {
    value=DoubleToString(model->Get()*3600.0/1000);
    unit=L"km/h";
  }
  else {
    value=DoubleToString(model->Get());
    unit=L"m/s";
  }

  draw->PushForeground(Lum::OS::display->GetColor(Lum::OS::Display::textColor));
  draw->PushFont(bigFont);

  valueWidth=bigFont->StringWidth(value);

  draw->DrawString(this->x+(width-valueWidth)/2,
                   this->y+(height-bigFont->height)/2+bigFont->ascent,
                   value);

  draw->PopFont();

  draw->PushFont(font);

  valueWidth=font->StringWidth(unit);

  draw->DrawString(this->x+(width-valueWidth),
                   this->y+(height-font->height)+font->ascent,
                   unit);

  draw->PopFont();
  draw->PopForeground();
}

void Speed::Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg)
{
  if (model==this->model) {
    Redraw();
  }

  Control::Resync(model,msg);
}

Speed* Speed::Create(Lum::Base::Model* model,
                     bool horizontalFlex,
                     bool verticalFlex)
{
  Speed *speed=new Speed();

  speed->SetFlex(horizontalFlex,verticalFlex);
  speed->SetModel(model);

  return speed;
}

