#ifndef TIMELINE_H
#define TIMELINE_H

/*
  GPSJinni - show raw data from the GPS subsystem.
  Copyright (C) 2009  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <Lum/Model/DataStream.h>

#include <Lum/Object.h>

class TimeLine : public Lum::Scrollable
{
private:
  struct Entry
  {
    double value;
  };

private:
  Lum::Model::DoubleDataStreamRef       model;
  Lum::OS::FontRef                      font;

  size_t                                verticalScaleWidth;
  size_t                                digitWidth;
  size_t                                verticalScalePrecision;
  double                                verticalScaleStep;

  double                                bottom;
  double                                top;
  double                                lastDrawnBottom;
  double                                lastDrawnTop;

  int                                   gestureStartX;
  int                                   gestureStartY;

  std::map<Lum::Base::SystemTime,Entry> data;

  void UpdateDimensions();

  unsigned long GetSecondsCovered() const;

  int TransformValue(double y);

  void CalculateVerticalScale();
  void PrintData(Lum::OS::DrawInfo* draw,
                 const Lum::Base::SystemTime& start,
                 const Lum::Base::SystemTime& end);
  void PrintHorizontalScale(Lum::OS::DrawInfo* draw,
                            const Lum::Base::SystemTime& start);
  void PrintVerticalScale(Lum::OS::DrawInfo* draw);

public:
  TimeLine();

  bool SetModel(Lum::Base::Model* model);

  void CalcSize();
  void Draw(int x, int y, size_t w, size_t h);

  void Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg);

  static TimeLine* Create(bool horizontalFlex=false, bool verticalFlex=false);
  static TimeLine* Create(Lum::Base::Model* model, bool horizontalFlex=false, bool verticalFlex=false);
};

#endif
