#include <gconf/gconf.h>
#include <gconf/gconf-client.h>

#include "settings.h"

#define GCONF_PATH "/apps/gps-data-logger"
#define GCONF_METHOD_AGNSS_KEY GCONF_PATH"/method_agnss"
#define GCONF_METHOD_GNSS_KEY  GCONF_PATH"/method_gnss"
#define GCONF_METHOD_ACWP_KEY  GCONF_PATH"/method_acwp"
#define GCONF_METHOD_CWP_KEY   GCONF_PATH"/method_cwp"
#define GCONF_INTERVAL_KEY     GCONF_PATH"/interval"
#define GCONF_LOG_FOLDER_KEY   GCONF_PATH"/log_folder"

GpsDataLoggerSettings *
settings_load (void)
{
    GpsDataLoggerSettings *settings;
    GConfClient           *client;

    settings = g_malloc0 (sizeof (GpsDataLoggerSettings));

    /* Get the default client */
    client = gconf_client_get_default();
    settings->method_agnss = gconf_client_get_bool(client,
		    		GCONF_METHOD_AGNSS_KEY,
				NULL);
    settings->method_gnss = gconf_client_get_bool(client,
		    		GCONF_METHOD_GNSS_KEY,
				NULL);
    settings->method_acwp = gconf_client_get_bool(client,
		    		GCONF_METHOD_ACWP_KEY,
				NULL);
    settings->method_cwp = gconf_client_get_bool(client,
		    		GCONF_METHOD_CWP_KEY,
				NULL);
    /* One of the methods must be set */
    if (! (settings->method_agnss &&
           settings->method_gnss &&
	   settings->method_acwp &&
	   settings->method_cwp))
        settings->method_gnss = TRUE;
    
    settings->interval = gconf_client_get_int(client,
		    		GCONF_INTERVAL_KEY,
				NULL);
    if ((settings->interval < 0) ||
        (settings->interval > 7))
        settings->interval = 1; /* 2 seconds */

    settings->log_folder = gconf_client_get_string(client,
		    		GCONF_LOG_FOLDER_KEY,
				NULL);
    if ((! settings->log_folder) ||
        (! g_file_test(settings->log_folder, 
		        (G_FILE_TEST_EXISTS | G_FILE_TEST_IS_DIR))))
	    settings->log_folder = g_strdup("/home/user/MyDocs");
    
    g_object_unref (G_OBJECT (client)); 
    return settings;
}

gboolean settings_save (GpsDataLoggerSettings * settings)
{
    GConfClient           *client;

    client = gconf_client_get_default();
    if (! gconf_client_set_bool(client,
			    GCONF_METHOD_AGNSS_KEY,
			    settings->method_agnss,
			    NULL)) {
        g_object_unref (G_OBJECT (client));	    
        return FALSE;
    }
    if (! gconf_client_set_bool(client,
			    GCONF_METHOD_GNSS_KEY,
			    settings->method_gnss,
			    NULL)) {
        g_object_unref (G_OBJECT (client));
        return FALSE;
    }
    if (! gconf_client_set_bool(client,
			    GCONF_METHOD_ACWP_KEY,
			    settings->method_acwp,
			    NULL)) {
        g_object_unref (G_OBJECT (client));
        return FALSE;
    }
    if (! gconf_client_set_bool(client,
			    GCONF_METHOD_CWP_KEY,
			    settings->method_cwp,
			    NULL)) {
        g_object_unref (G_OBJECT (client));
        return FALSE;
    }
    if (! gconf_client_set_int(client,
			    GCONF_INTERVAL_KEY,
			    settings->interval,
			    NULL)) {
        g_object_unref (G_OBJECT (client));
        return FALSE;
    }
    if (! gconf_client_set_string(client,
			    GCONF_LOG_FOLDER_KEY,
			    settings->log_folder,
			    NULL)) {
        g_object_unref (G_OBJECT (client));
        return FALSE;
    }
    g_object_unref (G_OBJECT (client));
    return TRUE;
}

void 
settings_free (GpsDataLoggerSettings * settings)
{
    g_free(settings->log_folder);
}
