#ifndef LATITUDE_H
#define LATITUDE_H

#include <QtGui>
#include <QtWebKit>
#include "glatitude.h"

class LatitudeGUI : public QMainWindow {
    Q_OBJECT

public slots:

public:
    LatitudeGUI(QMainWindow *parent = 0);

private slots:
    void get_loc();
    void get_cell();
    void get_gps();
    void set();
    void set_OK();
    void set_ERROR();
    void save();
    void show_map();
    void show_lat();
    void maps_login();

private:
    GoogleLatitude *glatitude;
    QSettings *setting;
    QWebView *maps;
    QWidget *location;
    QUrl urllogin;

    QLineEdit *login_user;
    QLineEdit *login_pass;
    QLineEdit *location_lat;
    QLineEdit *location_lon;
    QLineEdit *location_acc;

    QFormLayout *do_login();
    QFormLayout *do_location();
};

#endif // LATITUDE_H
