#ifndef GOOGLELATITUDE_H
#define GOOGLELATITUDE_H

#include <QObject>
#include <QNetworkAccessManager>
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QRegExp>
#include <QStringList>
#include <QDebug>

class GoogleLatitude : public QObject {
    Q_OBJECT

signals:
    void setOK();
    void setERROR();
    void getOK();

public slots:
    void get();    

public:
    GoogleLatitude();
    void login(QString username, QString password);
    void set(double latitude, double longitude, double accuracy=1000.);
    double get_lat() { return latitude; }
    double get_lon() { return longitude; }
    double get_acc() { return accuracy; }

private slots:
    void finishedreply(QNetworkReply *r);

private:
    // info
    QString user;
    QString pass;
    double latitude;
    double longitude;
    double accuracy;
    // stuff
    QNetworkAccessManager *worker;
    QUrl urllogin;
    QUrl urldologin;
    QUrl urlupdate;
    QUrl urlloc;
};

#endif // GOOGLELATITUDE_H
