#include "latitudewidget.h"

LatitudeWidget::LatitudeWidget() {
    load();
    glatitude.get();
    timer = new QTimer();
    // login
    login_user = new QLineEdit();
    login_user->setText(user);
    login_pass = new QLineEdit();
    login_pass->setText(pass);
    login_pass->setEchoMode(QLineEdit::Password);
    login_up = new QPushButton(tr("&Update Location"));
    login_layout = new QFormLayout();
    login_layout->addRow(tr("&Username"), login_user);
    login_layout->addRow(tr("&Password"), login_pass);
    login_layout->addRow(login_up);
    // location
    location_lat = new QLineEdit();
    location_lat ->setText(QString::number(latitude));
    location_lon = new QLineEdit();
    location_lon->setText(QString::number(longitude));
    location_acc = new QLineEdit();
    location_acc->setText(QString::number(accuracy));
    location_layout = new QFormLayout();
    location_layout->addRow(tr("lat :"), location_lat);
    location_layout->addRow(tr("lon :"), location_lon);
    location_layout->addRow(tr("acc :"), location_acc);
    // window
    menu = new QWidget();
    menu->setWindowTitle(tr("Google Latitude Updater"));
    menu_layout = new QHBoxLayout();
    menu_layout->addLayout(login_layout);
    menu_layout->addLayout(location_layout);
    menu->setLayout(menu_layout);
    menu->show();

    connect(login_up, SIGNAL(clicked()), this, SLOT(set()));
    connect(timer, SIGNAL(timeout()), this, SLOT(gset()));
    connect(&glatitude, SIGNAL(getOK()), this, SLOT(get()));
    connect(&glatitude, SIGNAL(setOK()), this, SLOT(gsetOK()));
    connect(&glatitude, SIGNAL(setERROR()), this, SLOT(gsetERROR()));
}

void LatitudeWidget::get() {
    location_lat->setText(QString::number(glatitude.get_lat()));
    location_lon->setText(QString::number(glatitude.get_lon()));
    location_acc->setText(QString::number(glatitude.get_acc()));
}

void LatitudeWidget::set() {
    save();
    glatitude.login(user, pass);
    glatitude.set(latitude, longitude, accuracy);
}

void LatitudeWidget::gsetOK() {
    login_up->setText(tr("Location Updated !"));
    timer->start(5000);
}
void LatitudeWidget::gsetERROR() {
    login_up->setText(tr("Error in Authentification !"));
    timer->start(2000);
}

void LatitudeWidget::gset() {
    login_up->setText(tr("&Update Location"));
}

void LatitudeWidget::load() {
    // from file
    if ( QFile::exists(QDir::homePath()+"/.glatitude") ) {
        QFile *config = new QFile(QDir::homePath()+"/.glatitude");
        config->open(QIODevice::ReadOnly);
        QTextStream sconfig(config);
        sconfig >> user >> pass;
        sconfig >> latitude >> longitude >> accuracy;
        config->close();
    } else {
        user = "my_username";
        pass = "my_password";
        latitude = 0.;
        longitude = 0.;
        accuracy = 0.;
    }
}

void LatitudeWidget::save() {
    // extract info
    user = login_user->text();
    pass = login_pass->text();
    latitude = location_lat->text().toDouble();
    longitude = location_lon->text().toDouble();
    accuracy = location_acc->text().toDouble();
    // to file
    QFile *config = new QFile(QDir::homePath()+"/.glatitude");
    config->open(QIODevice::WriteOnly);
    QTextStream sconfig(config);
    sconfig << user << " " << pass << " ";
    sconfig << latitude << " " << longitude << " " << accuracy;
    config->close();
}
