/*
 * This file is part of gnokii-gconf
 *
 * Copyright (C) 2008 FLL.
 *
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
 
#include <glib.h> 
#include <gconf/gconf.h>
#include <gconf/gconf-client.h>

#include <gnokii-gconf-private.h>

gchar ** getGnokiiCfg(GConfClient *gc_client, GError **error) {
	GError *locError = NULL;
	gchar *btMac;
	gchar *model;
	gchar *rfcomm;
	gchar *gnokiiCfg;
	gchar **lines;
	gboolean initGConf = FALSE;

	if (gc_client == NULL) {
	/* Init type system */
		g_type_init();

	/* Load default GConf path */
		gc_client = gconf_client_get_default();
		initGConf = TRUE;
	}

	if (gc_client == NULL) {
		return NULL;
	}

	/* Get string variable */
	btMac = gconf_client_get_string(gc_client, GNOKII_GCONF_BT_KEY, &locError);
	if (locError != NULL) {
		g_propagate_error(error, locError);
	}
	model = gconf_client_get_string(gc_client, GNOKII_GCONF_MODEL_KEY, &locError);
	if (locError != NULL) {
		g_propagate_error(error, locError);
	}
	rfcomm = gconf_client_get_string(gc_client, GNOKII_GCONF_RFCOMM_KEY, &locError);
	if (locError != NULL) {
		g_propagate_error(error, locError);
	}

	if (!btMac) {
		/* Get preferred phone */
		btMac = gconf_client_get_string(gc_client, "/system/osso/connectivity/BT/preferred", &locError);
		if (locError != NULL) {
			g_propagate_error(error, locError);
		}
		if (!btMac) {
			return NULL;
		}
	}
	if (!model) {
		model = g_strdup("AT");
	}
	if (!rfcomm) {
		rfcomm = g_strdup("1");
	}
	
	gnokiiCfg = g_strdup_printf(GNOKII_CFG, btMac, model, rfcomm);
	lines = g_strsplit(gnokiiCfg, "\n", -1);
	
	g_free(gnokiiCfg);
	if (initGConf) {
		/* Free gconf settings object */
		g_object_unref(gc_client);
	}
	
	return lines;
	
 }

 gboolean isGnokiiRcFileUsed(GConfClient *gc_client, GError **error) {
	GError *locError = NULL;
	gboolean initGConf = FALSE;
	gboolean use = FALSE;

	if (gc_client == NULL) {
	/* Init type system */
		g_type_init();

	/* Load default GConf path */
		gc_client = gconf_client_get_default();
		initGConf = TRUE;
	}

	if (gc_client == NULL) {
		return use;
	}

	use = gconf_client_get_bool(gc_client, GNOKII_GCONF_USE_GNOKIIRC_KEY, &locError);
	if (locError != NULL) {
		g_propagate_error(error, locError);
	}

	if (initGConf) {
		/* Free gconf settings object */
		g_object_unref(gc_client);
	}
	
	 return use;
 }