#!/usr/bin/env python

""" glogarchive v 0.2 (C) 2010 by Kurt Fleisch
    http://www.bananenfisch.net/n900/

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

import pygtk
pygtk.require('2.0')
import sys, os.path, shutil, sqlite3, time, gtk, hildon, cgi

EL_PATH = "/home/user/.rtcom-eventlogger/el.db"
ARCHIVE_PATH = "/home/user/.rtcom-eventlogger/el_archive.db"

class fenster:

    def close_application(self, widget, data=None):
        gtk.main_quit()
        return False

    def show_about(self, widget):
        about = gtk.AboutDialog()
        about.set_name("glogarchive")
        about.set_logo_icon_name("glogarchive")
        about.set_comments("to archive SMS/IM messages and calling-history from the eventlogger to an extra DB")
        about.set_version("0.2")
        about.set_copyright("by Kurt Fleisch")
        about.set_website("www.bananenfisch.net/n900")
        about.run()
        about.hide()

    def __init__(self):
        window = hildon.StackableWindow()
        window.set_title("glogevent")
        window.connect("delete_event", self.close_application)
        window.set_border_width(0)

        gmenu = hildon.AppMenu()
        butabout = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL, "About")
        butabout.connect("clicked", self.show_about)
        gmenu.append(butabout)
        butquit = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL, "Quit")
        butquit.connect("clicked", self.close_application)
        gmenu.append(butquit)
        gmenu.show_all()
        window.set_app_menu(gmenu)

        boxlines = gtk.VBox(False, 0)
        line1 = gtk.HBox(True, 0)
        butarch = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL, "archive now!")
        butarch.connect("clicked", archive)
        line1.pack_start(butarch, True, True, 0)
        butarch.show()
        butsum = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL, "full stats")
        butsum.connect("clicked", listall)
        line1.pack_start(butsum, True, True, 0)
        butsum.show()
        line1.show()
        boxlines.pack_start(line1, False, False, 0)

        datebox = gtk.HBox(True, 0)
        butfrom = hildon.DateButton(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
        butfrom.set_text("from", "")
        datebox.pack_start(butfrom, True, True, 0)
        butfrom.show()
        butto = hildon.DateButton(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
        butto.set_text("to", "")
        datebox.pack_start(butto, True, True, 0)
        butto.show()
        butdate = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL, "date stats")
        butdate.connect("clicked", listall, butfrom, butto)
        datebox.pack_start(butdate, True, True, 0)
        butdate.show()
        boxlines.pack_start(datebox, False, False, 0)
        datebox.show()

        line3 = gtk.HBox(True, 0)
        butgrpnum = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL, "group by uid")
        butgrpnum.connect("clicked", viewuid)
        line3.pack_start(butgrpnum, True, True, 0)
        butgrpnum.show()
        butgrpevt = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL, "group by event")
        butgrpevt.connect("clicked", viewevt)
        line3.pack_start(butgrpevt, True, True, 0)
        butgrpevt.show()
        line3.show()
        boxlines.pack_start(line3, False, False, 0)

        boxlines.show()
        window.add(boxlines)

        self.outlines = gtk.VBox(False, 0)
        scrolled_window = hildon.PannableArea()
        boxlines.pack_start(scrolled_window, True, True, 0)
        scrolled_window.show()
        scrolled_window.add_with_viewport(self.outlines)

        self.outlines.show()
        window.show()

def archive(widget):
  for child in ui.outlines.get_children()[:]: ui.outlines.remove(child) # child.destroy()
  label = gtk.Label("Archive")
  label.set_alignment(0, 0)
  ui.outlines.pack_start(label, False, False, 0)
  label.show()
  if os.path.isfile(EL_PATH):
    if os.path.isfile(ARCHIVE_PATH):
      conn = sqlite3.connect(EL_PATH)
      conn2 = sqlite3.connect(ARCHIVE_PATH)
      cur = conn.cursor()
      curnew = conn2.cursor()
      curins = conn2.cursor()

      curnew.execute("select service_id, event_type_id, storage_time, start_time, end_time, is_read, flags, bytes_sent, bytes_received, local_uid, local_name, remote_uid, channel, free_text, group_uid from events")
      allnew = curnew.fetchall()
      cur.execute("select service_id, event_type_id, storage_time, start_time, end_time, is_read, flags, bytes_sent, bytes_received, local_uid, local_name, remote_uid, channel, free_text, group_uid from events")
      for row in cur: 
        if row not in allnew:
          curins.execute("insert into events (service_id, event_type_id, storage_time, start_time, end_time, is_read, flags, bytes_sent, bytes_received, local_uid, local_name, remote_uid, channel, free_text, group_uid) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", row)
          label = gtk.Label("insert to events... type: %s, timestamp: %s" % (row[1], row[3]))
          label.set_alignment(0, 0)
          ui.outlines.pack_start(label, False, False, 0)
          label.show()
      conn2.commit()

      curnew.execute("select * from remotes")
      allnew = curnew.fetchall()

      cur.execute("select * from remotes")
      for row in cur:
        if row not in allnew:
          if row[1] in zip(*allnew)[1]:
            curins.execute("update remotes set local_uid = ?, remote_name = ?, abook_uid = ? where remote_uid = ?", (row[0], row[2], row[3], row[1]))
            label = gtk.Label("update remotes... %s %s %s %s" % row)
            label.set_alignment(0, 0)
            ui.outlines.pack_start(label, False, False, 0)
            label.show()
          else:
            curins.execute("insert into remotes values (?,?,?,?)", row)
            label = gtk.Label("insert to remotes... %s %s %s %s" % row)
            label.set_alignment(0, 0)
            ui.outlines.pack_start(label, False, False, 0)
            label.show()
      conn2.commit()
      cur.close()
      curnew.close()
      curins.close()
    else:
      label = gtk.Label("Archive not found, copying all from el.db")
      label.set_alignment(0, 0)
      ui.outlines.pack_start(label, False, True, 0)
      label.show()
      shutil.copy(EL_PATH, ARCHIVE_PATH)
  else:
    print("Unable to open eventlogger file")
    sys.exit(1)

def listall(widget, a = None, b = None):
  for child in ui.outlines.get_children()[:]: ui.outlines.remove(child) # child.destroy()
  label = gtk.Label("Summary")
  label.set_alignment(0, 0)
  ui.outlines.pack_start(label, False, False, 0)
  label.show()
  if os.path.isfile(ARCHIVE_PATH):
    conn = sqlite3.connect(ARCHIVE_PATH)
    cur = conn.cursor()
    if a == None or b == None:
      cur.execute("select eventtypes.name, count(events.id) from events LEFT JOIN eventtypes ON events.event_type_id = eventtypes.id group by events.event_type_id")
    else:
      (ayear, amonth, aday) = a.get_date()
      (byear, bmonth, bday) = b.get_date()
      amonth = amonth+1
      bmonth = bmonth+1
      daten1 = "%d-%02d-%02d" % (ayear, amonth, aday)
      daten2 = "%d-%02d-%02d" % (byear, bmonth, bday)
      stampfrom = time.mktime(time.strptime(daten1, "%Y-%m-%d"))
      stampto = time.mktime(time.strptime(daten2+" 23:59:59", "%Y-%m-%d %H:%M:%S"))
      cur.execute("select eventtypes.name, count(events.id) from events LEFT JOIN eventtypes ON events.event_type_id = eventtypes.id where events.start_time >= ? and events.start_time <= ? group by events.event_type_id", (stampfrom, stampto))
    for row in cur:
      label = gtk.Label("%s: %d" % (gettype(row[0]), row[1]))
      label.set_alignment(0, 0)
      ui.outlines.pack_start(label, False, False, 0)
      label.show()
    cur.close()
  else:
    label = gtk.Label("Unable to open eventlogger-archive file\narchive first!")
    label.set_alignment(0, 0)
    ui.outlines.pack_start(label, False, False, 0)
    label.show()

def viewuid(widget):
  if os.path.isfile(ARCHIVE_PATH):
    winuid = hildon.StackableWindow()
    winuid.set_title("glogevent: uid")
    winuid.set_border_width(0)
    gruppen = gtk.VBox(False, 0)
    scrolled_window = hildon.PannableArea()
    winuid.add(scrolled_window)
    scrolled_window.add_with_viewport(gruppen)

    conn = sqlite3.connect(ARCHIVE_PATH)
    cur = conn.cursor()
    cur.execute("select count(Events.id), Events.start_time, Events.remote_uid, Remotes.remote_name from Events left join Remotes on Events.remote_uid = Remotes.remote_uid group by Events.remote_uid order by Events.start_time desc")
    for row in cur:
      button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
      button.set_style(hildon.BUTTON_STYLE_PICKER)
      if row[3] != None:
        ol1 = "%s (%s)" % (row[3], row[2]) 
      else:
        ol1 = "%s" % (row[2])
      lasttime = time.strftime("%d.%m.%Y %H:%M:%S", time.localtime(row[1]))
      ol2 = "%d events, last: %s" % (row[0], lasttime)
      button.set_text(ol1, ol2)
      button.set_alignment(0, 0, 0, 0)
      button.connect("clicked", viewdetail, row[2], "user")
      gruppen.pack_start(button, False, False, 0)
      button.show()

    gruppen.show()
    scrolled_window.show()
    winuid.show()
    cur.close()

  else:
    label = gtk.Label("Unable to open eventlogger-archive file\narchive first!")
    label.set_alignment(0, 0)
    ui.outlines.pack_start(label, False, False, 0)
    label.show()

def viewevt(widget):
  if os.path.isfile(ARCHIVE_PATH):
    winuid = hildon.StackableWindow()
    winuid.set_title("glogevent: event")
    winuid.set_border_width(0)

    gruppen = gtk.VBox(False, 0)
    scrolled_window = hildon.PannableArea()
    winuid.add(scrolled_window)
    scrolled_window.add_with_viewport(gruppen)

    conn = sqlite3.connect(ARCHIVE_PATH)
    cur = conn.cursor()
    cur.execute("select id, name from EventTypes")
    for row in cur:
      button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
      button.set_style(hildon.BUTTON_STYLE_PICKER)
      button.set_text(gettype(row[1]), row[1])
      button.set_alignment(0, 0, 0, 0)
      button.connect("clicked", viewdetail, row[0], "event")
      gruppen.pack_start(button, False, False, 0)
      button.show()

    gruppen.show()
    scrolled_window.show()
    winuid.show()
    cur.close()

  else:
    label = gtk.Label("Unable to open eventlogger-archive file\narchive first!")
    label.set_alignment(0, 0)
    ui.outlines.pack_start(label, False, False, 0)
    label.show()

def viewdetail(widget, did, viewtype):
  winuid = hildon.StackableWindow()
  winuid.set_title("glogevent: "+str(did))
  winuid.set_border_width(0)

  gruppen = gtk.VBox(False, 0)
  scrolled_window = hildon.PannableArea()
  winuid.add(scrolled_window)
  scrolled_window.add_with_viewport(gruppen)

  conn = sqlite3.connect(ARCHIVE_PATH)
  cur = conn.cursor()
  if viewtype == "user":
    cur.execute("select Eventtypes.name, Events.start_time, Events.free_text from Events left join Eventtypes on Events.event_type_id = Eventtypes.id where Events.remote_uid = ? order by Events.start_time desc", (did,))
  else:
    cur.execute("select Remotes.remote_name, Events.start_time, Events.free_text, Events.remote_uid from Events left join Remotes on Events.remote_uid = Remotes.remote_uid where Events.event_type_id = ? order by Events.start_time desc", (did,))
  for row in cur:
    lasttime = time.strftime("%d.%m.%Y %H:%M:%S", time.localtime(row[1]))
    if viewtype == "user":
      ol1 = "<b>%s</b> <small>(%s)</small>" % (gettype(row[0]), lasttime)
    else:
      if row[0] == None:
        ol1 = "%s <small>(%s)</small>" % (cgi.escape(row[3]), lasttime)
      else:
        ol1 = "%s <small>(%s)</small>" % (cgi.escape(row[0]), lasttime)
    if row[2] != None: ol1 = ol1 + "\n<small><i>" + cgi.escape(row[2]) + "</i></small>"
    button = gtk.Label()
    button.set_markup(ol1)
    button.set_alignment(0, 0)
    button.set_line_wrap(True)
    gruppen.pack_start(button, False, False, 3)
    sep = gtk.HSeparator()
    gruppen.pack_start(sep, False, False, 3)
    sep.show()
    button.show()

  gruppen.show()
  scrolled_window.show()
  winuid.show()
  cur.close()

def gettype(typename):
  if typename == "RTCOM_EL_EVENTTYPE_CALL_INBOUND": return "in CALL"
  if typename == "RTCOM_EL_EVENTTYPE_CALL_OUTBOUND": return "out CALL"
  if typename == "RTCOM_EL_EVENTTYPE_CALL_MISSED": return "missed CALL"
  if typename == "RTCOM_EL_EVENTTYPE_CALL_VOICEMAIL": return "voicemail CALL"
  if typename == "RTCOM_EL_EVENTTYPE_CHAT_INBOUND": return "in CHAT"
  if typename == "RTCOM_EL_EVENTTYPE_CHAT_OUTBOUND": return "out CHAT"
  if typename == "RTCOM_EL_EVENTTYPE_SMS_INBOUND": return "in SMS"
  if typename == "RTCOM_EL_EVENTTYPE_SMS_OUTBOUND": return "out SMS"
  return "unknown type"

if __name__ == "__main__":
  ui = fenster()
  gtk.main()
