#include "oauthwizard.h"
#include "core.h"
#include "engines/gmwengine.h"
#include "data/gmwitemmodel.h"

#include <QHBoxLayout>
#include <QLabel>
#include <QPushButton>
#include <QDebug>

OAuthSetupUi::OAuthSetupUi(QWidget *parent) :
    QDialog(parent)
{
    QVBoxLayout *layout = new QVBoxLayout();
    setLayout(layout);
    QLabel *textLabel = new QLabel(tr("To be able to create bookings for cars you need to be signed in with your car2go account. Note that there may be costs associated with it. Please visit http://www.car2go.com for detailed informations."));
    textLabel->setWordWrap(true);
    layout->addWidget(textLabel);

    QGridLayout *gridLayout = new QGridLayout();

    gridLayout->addWidget(new QLabel(tr("1. Sign in at car2go:")), 0, 0, 1, 2);
    QPushButton *pb = new QPushButton("Sign in");
    connect(pb, SIGNAL(clicked()), SLOT(initAuth()));
    gridLayout->addWidget(pb, 0, 2);

    gridLayout->addWidget(new QLabel(tr("2. Enter access code:")), 1, 0);
    m_lineEdit = new QLineEdit();
    m_lineEdit->setEnabled(false);
    connect(m_lineEdit, SIGNAL(textEdited(QString)), SLOT(lineEditChanged()));
    gridLayout->addWidget(m_lineEdit, 1, 1);

    m_pbSetCode = new QPushButton(tr("Set Code"));
    m_pbSetCode->setEnabled(false);
    connect(m_pbSetCode, SIGNAL(clicked()), SLOT(setCode()));
    gridLayout->addWidget(m_pbSetCode, 1, 2);

    m_label = new QLabel();
    gridLayout->addWidget(m_label, 2, 0);

    m_pbOk = new QPushButton(tr("Cancel"));
    connect(m_pbOk, SIGNAL(clicked()), SLOT(accept()));
    gridLayout->addWidget(m_pbOk, 2, 2);


    layout->addLayout(gridLayout);

}


void OAuthSetupUi::initAuth()
{
    if(Core::engine()->startAuthentication()) {
        m_lineEdit->setEnabled(true);
    } else {
        m_label->setText(tr("Error signing in at car2go."));
    }
}

void OAuthSetupUi::setCode()
{
    if(Core::engine()->setAccessCode(m_lineEdit->text())) {
        m_label->setText("Authenticated successfully.");
        m_pbOk->setText(tr("OK"));
    } else {
        m_label->setText("Error authenticating to service.");
    }
}

void OAuthSetupUi::lineEditChanged()
{
    m_pbSetCode->setEnabled(!m_lineEdit->text().isEmpty());
}

void OAuthSetupUi::book()
{
    Core::engine()->createBooking(dynamic_cast<GMWVehicle*>(Core::model()->nearestItem(GMWItem::TypeVehicle)));
}
