#include "gmwbooking.h"

#include <QObject>

GMWBooking::GMWBooking(int id, GMWAccount account):
    m_id(id),
    m_account(account)
{
}

bool GMWBooking::isValid() const
{
    return m_id > -1 && m_expriationTime.isValid();
}

int GMWBooking::id() const
{
    return m_id;
}

void GMWBooking::setId(int id)
{
    m_id = id;
}

void GMWBooking::setAccount(const GMWAccount &account)
{
    m_account = account;
}

GMWAccount GMWBooking::account() const
{
    return m_account;
}

void GMWBooking::setTime(const QDateTime &time)
{
    m_time = time;
}

QDateTime GMWBooking::time() const
{
    return m_time;
}

void GMWBooking::setExpirationTime(const QDateTime &time)
{
    m_expriationTime = time;
}

QDateTime GMWBooking::expirationTime() const
{
    m_expriationTime;
}

QString GMWBooking::toString() const
{
    if(QDateTime::currentDateTime() < m_expriationTime) {
        return QObject::tr("Booked - Expires: %1  (%2min)")
                .arg(m_expriationTime.toString("hh:mm"))
                .arg(QDateTime::currentDateTime().secsTo(m_expriationTime) / 60);
   } else {
        return QObject::tr("Booking expired at %1")
                .arg(m_expriationTime.toString("hh:mm"));

    }
}

bool GMWBooking::isExpired() const
{
    return QDateTime::currentDateTime() > m_expriationTime;
}
