#include "accountselectordialog.h"

#include <QGridLayout>
#include <QListView>
#include <QStandardItemModel>
#include <QPushButton>

AccountSelectorDialog::AccountSelectorDialog(const QList<GMWAccount> &accounts, QWidget *parent) :
    QDialog(parent)
{
    QGridLayout *layout = new QGridLayout();

    m_view = new QListView();
    layout->addWidget(m_view);

    m_model = new QStandardItemModel(this);

    foreach(const GMWAccount &account, accounts) {
        QStandardItem *item = new QStandardItem(account.description());
        item->setData(qVariantFromValue(account), Qt::UserRole);
        m_model->appendRow(item);

    }

    m_view->setModel(m_model);
    m_view->setCurrentIndex(m_model->index(0, 0));

    QPushButton *closeButton = new QPushButton("OK");
    connect(closeButton, SIGNAL(clicked()), SLOT(accept()));

    layout->addWidget(closeButton);

    setLayout(layout);

}

GMWAccount AccountSelectorDialog::selectedAccount()
{
    return m_model->data(m_view->currentIndex(), Qt::UserRole).value<GMWAccount>();
}
