/*****************************************************************************
 * Copyright: 2010-2011 Christian Fetzer <fetzer.ch@googlemail.com>          *
 * Copyright: 2010-2011 Michael Zanetti <mzanetti@kde.org>                   *
 *                                                                           *
 * This program is free software: you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation, either version 3 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This program is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.     *
 *                                                                           *
 ****************************************************************************/

#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include <QDialog>

class QCheckBox;
class QStandardItemModel;
class QMaemo5ListPickSelector;
class QComboBox;

class SettingsDialog : public QDialog
{
    Q_OBJECT

public:
    explicit SettingsDialog(QWidget *parent = 0);

    bool mapCachingEnabled();
    void setMapCachingEnabled(bool enabled);

    bool rotationEnabled();
    void setRotationEnabled(bool enabled);

    QString location();
    void setLocations(const QStringList &locations, const QString &currentSelection);

    QString mapProvider();
    void setMapProviders(const QStringList &providers, const QString &currentProvider);

private:
    QCheckBox *m_cbEnableRotation;
    QStandardItemModel *m_locationModel;
    QStandardItemModel *m_mapProviderModel;

#ifdef Q_WS_MAEMO_5
    QMaemo5ListPickSelector *m_locationSelector;
    QMaemo5ListPickSelector *m_mapProviderSelector;
#else
    QComboBox *m_locationBox;
    QComboBox *m_mapProviderBox;
#endif

};

#endif // SETTINGSDIALOG_H
