/*****************************************************************************
 * Copyright: 2010-2011 Christian Fetzer <fetzer.ch@googlemail.com>          *
 * Copyright: 2010-2011 Michael Zanetti <mzanetti@kde.org>                   *
 *                                                                           *
 * This program is free software: you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation, either version 3 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This program is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.     *
 *                                                                           *
 ****************************************************************************/

#ifndef NAVIGATOR_H
#define NAVIGATOR_H

#include "mobilitymap.h"

#include <QtCore/QObject>

#include <QtLocation/QGeoRoutingManager>
#include <QtLocation/QGeoRouteRequest>
#include <QtLocation/QGeoMapRouteObject>

class Navigator : public QObject
{
    Q_OBJECT

public:
    Navigator(QGeoRoutingManager *routingManager, MobilityMap *mapWidget, const QGeoCoordinate &destination);
    ~Navigator();

    void start();
    QGeoRoute route() const;

signals:
    void finished();
    void error(QGeoRouteReply::Error error, QString errorString);

private slots:
    void routingFinished();
    void routingError(QGeoRouteReply::Error error, QString errorString);

private:
    QGeoRouteRequest    m_request;
    QGeoRouteReply     *m_reply;
    QGeoRoute           m_firstRoute;

    QGeoMapRouteObject *m_routeObject;
    //Marker *endMarker;
    //Marker *startMarker;

    QGeoRoutingManager *m_routingManager;
    MobilityMap        *m_mapWidget;
};

#endif // NAVIGATOR_H
