/*****************************************************************************
 * Copyright: 2010-2011 Christian Fetzer <fetzer.ch@googlemail.com>          *
 * Copyright: 2010-2011 Michael Zanetti <mzanetti@kde.org>                   *
 *                                                                           *
 * This program is free software: you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation, either version 3 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This program is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.     *
 *                                                                           *
 ****************************************************************************/

#ifndef GMWMAP_H
#define GMWMAP_H

#include "data/gmwitemsortfilterproxymodel.h"

#include <QtCore/QPointF>

#include <QtGui/QLayout>
#include <QtGui/QWidget>
#include <QtGui/QPushButton>

#include <QtLocation/QGeoPositionInfo>
#include <QtLocation/QGeoBoundingBox>

QTM_USE_NAMESPACE

class GMWItem;

class QMenu;
class QMenuBar;

class GMWMap: public QWidget
{
    Q_OBJECT
public:
    explicit GMWMap(GMWItemSortFilterProxyModel * model, QWidget *parent = 0);

signals:
    void objectClicked(GMWItem *object);
    void showList();

public slots:
    virtual void positionUpdated(const QGeoPositionInfo &info) = 0;
    virtual void moveTo(const QGeoCoordinate &point) = 0;
    virtual void routeTo(const QGeoCoordinate &point) = 0;
    virtual void zoomIn() = 0;
    virtual void zoomOut() = 0;
    virtual void zoomTo(const QGeoBoundingBox &bounds) = 0;
    virtual void refresh() = 0;

    virtual QStringList supportedMapProviders() const = 0;
    virtual QString mapProvider() const = 0;
    virtual bool setMapProvider(const QString &provider) = 0;

    void enableTracking();
    void disableTracking();
    void setTracking(bool tracking);

protected:
    void resizeEvent(QResizeEvent *event);

    GMWItemSortFilterProxyModel *m_model;

protected slots:
    virtual void rowsInserted(const QModelIndex &parent, int start, int end) = 0;
    virtual void rowsAboutToBeRemoved(const QModelIndex &parent, int start, int end) = 0;

private:
    QBoxLayout       *m_layout;
    QWidget          *m_buttons;
    QBoxLayout       *m_buttonLayout;
    QPushButton      *m_pbZoomIn;
    QPushButton      *m_pbZoomOut;
    QPushButton      *m_pbGoToPos;
    QPushButton      *m_pbShowList;

    bool              m_tracking;
    QGeoPositionInfo  m_currentPosition;
};

#endif // GMWMAP_H
