/*
 * Copyright 2010 Felipe Crochik <foss@crochik.com>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "maemo5wnd.h"

#include <QMenuBar>
#include <QDebug>
#include <QApplication>

// #include <QMaemo5InformationBox>

#include "pickselectoraction.h"
#include "fullscreenexitbutton.h"

#include <QtGui/QX11Info>
#include <X11/Xlib.h>
#include <X11/Xatom.h>

Maemo5Wnd::Maemo5Wnd(QWidget *parent) :
    QMainWindow(parent)
{
    m_pOrientationSelector = NULL;
}

Maemo5Wnd::~Maemo5Wnd() {
}

void Maemo5Wnd::ShowProgressIndicator(QWidget *pWidget, bool show) {
    if ( !pWidget ) return;
#ifdef Q_WS_MAEMO_5
    // http://qt.nokia.com/doc/qt-maemo-4.6/maemo5-windowstates.html
    pWidget->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, show);
#endif

    QApplication::processEvents();
}

void Maemo5Wnd::addFullscreenToMenu() {
    // full screen
    new FullScreenExitButton(this);
    menuBar()->addAction("Fullscreen", this, SLOT(onFullscreen()));
}

void Maemo5Wnd::addOrientationToMenu() {
     // orientation
    m_pOrientationSelector = new PickSelectorAction(this);
    m_pOrientationSelector->setText("Orientation");
    m_pOrientationSelector->items() << "Auto" << "Landscape" << "Portrait";
    connect(m_pOrientationSelector, SIGNAL(selectionChanged(int)), this, SLOT(onOrientationChanged(int)));
    menuBar()->addAction(m_pOrientationSelector);
    setAutoRotate(); // default for now
}

void Maemo5Wnd::onOrientationChanged(int index) {
    switch ( index ) {
        case 0: // auto
            setAutoRotate(true);
            break;

        case 1: // landscape
            setAutoRotate(false);
            setLandscapeOrPortrait(true);
            break;

        case 2: // portrait
            setAutoRotate(false);
            setLandscapeOrPortrait(false);
            break;
    }
}

void Maemo5Wnd::setLandscapeOrPortrait(bool landscape) {
    if ( m_pOrientationSelector ) m_pOrientationSelector->setSelectedIndex(landscape?1:2);

    if ( landscape ) {
        qDebug() << ">> set Landscape";
        //setAttribute(Qt::WA_Maemo5PortraitOrientation, false);
        setAttribute(Qt::WA_Maemo5LandscapeOrientation, true); //
        if ( m_pOrientationSelector ) m_pOrientationSelector->setSelectedIndex(1);

    } else {
        qDebug() << ">> set Portrait";
        //setAttribute(Qt::WA_Maemo5LandscapeOrientation, false);
        setAttribute(Qt::WA_Maemo5PortraitOrientation, true);
        if ( m_pOrientationSelector ) m_pOrientationSelector->setSelectedIndex(2);

    }
}

void Maemo5Wnd::setAutoRotate(bool autoRotate /*=true*/) {
    // http://qt.nokia.com/doc/qt-maemo-4.6/maemo5-rotation.html
    if ( autoRotate ) {
        qDebug() << "set autorotate: on";
        setAttribute(Qt::WA_Maemo5AutoOrientation, true);
        if ( m_pOrientationSelector ) m_pOrientationSelector->setSelectedIndex(0);
        return;
    }

    qDebug() << "set autorotate: off";
    setAttribute(Qt::WA_Maemo5AutoOrientation, false);
}

bool Maemo5Wnd::isAutoRotate(){
    return testAttribute(Qt::WA_Maemo5AutoOrientation);
}

bool Maemo5Wnd::isLandscape(){
    return width()>height();
    // return testAttribute(Qt::WA_Maemo5LandscapeOrientation) || !testAttribute(Qt::WA_Maemo5PortraitOrientation);
}

void Maemo5Wnd::onFullscreen() {
    showFullScreen();
}

void Maemo5Wnd::grabZoomKeys(bool grab) {
    if (!this->winId()) {
        qWarning("Can't grab keys unless we have a window id");
        return;
    }

    unsigned long val = (grab) ? 1 : 0;
    Atom atom = XInternAtom(QX11Info::display(), "_HILDON_ZOOM_KEY_ATOM", False);
    if (!atom) {
        qWarning("Unable to obtain _HILDON_ZOOM_KEY_ATOM. This example will only work "
                 "on a Maemo 5 device!");
        return;
    }

    XChangeProperty (QX11Info::display(),
            this->winId(),
            atom,
            XA_INTEGER,
            32,
            PropModeReplace,
            reinterpret_cast<unsigned char *>(&val),
            1);

}
