/*
 * Copyright 2010 Felipe Crochik <foss@crochik.com>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef DIRECTIONSDLG_H
#define DIRECTIONSDLG_H

#include <QDialog>

namespace Ui {
    class DirectionsDlg;
}

class DirectionsDlg : public QDialog
{
    Q_OBJECT

public:
    explicit DirectionsDlg(QWidget *parent = 0);
    ~DirectionsDlg();

public:
    QString startAddress();
    QString destinationAddress();
    void setStartAddress(QString value);
    void setStartAddressToCurrentPos(bool isCurrent=true);
    void setDestinationAddress(QString value);

    QString mode();
    QStringList avoid();
    QString units();
    bool showAlternatives();

protected:
    void changeEvent(QEvent *e);

private:
    Ui::DirectionsDlg *ui;
};

#endif // DIRECTIONSDLG_H
