/*
 * Copyright 2010 Felipe Crochik <foss@crochik.com>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "directions.h"

#include <QDebug>
#include <QRegExp>

QString Step::toString() {
    return QString("%1 (%2 %3) --> %4 %5").arg(
        m_description,
        m_distanceStr,
        m_durationStr,
        latitudeStr(),
        longitudeStr()
    );
}

QString Step::plainDescription() {
    QString str = m_description;
    str = str.replace(QRegExp("<[/A-Za-z][a-zA-Z0-9]*[^>]*>"), QString(" "));
    str = str.replace(QRegExp("\\s\\s"), QString(" "));
    return str;
}

// ------------------------------------------------------------------------------------
Directions::Directions()
{
}
