/*
 * Copyright 2010 Felipe Crochik <foss@crochik.com>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "directionsmodel.h"

#include <QDebug>

DirectionsModel::DirectionsModel(Directions& directions, QObject *parent) :
    QAbstractListModel(parent),
    m_directions(directions)
{
}


int DirectionsModel::rowCount(const QModelIndex &parent/*=QModelIndex()*/ ) const {
    return m_directions.m_steps.length() + 1;
}

int DirectionsModel::ceiling(float val) const {
    return (int)val + ((val - (int)val > 0) ? 1 : 0);
}

QVariant DirectionsModel::data(const QModelIndex & index, int role/*=Qt::DisplayRole*/) const {
    if ( index.row()<0 || index.row()>m_directions.m_steps.length() ) return QVariant();

    switch ( role ) {
        case Qt::DisplayRole:
            if ( index.row()>=m_directions.m_steps.length() ) {
                // total
                return QString("Distance: %1km (%3 mi) - Duration: %2min").arg(
                    QString::number(ceiling(m_directions.m_distance/100.f)/10.f),
                    QString::number(ceiling(m_directions.m_duration/60.f)),
                    QString::number(ceiling(m_directions.m_distance / 1609.344))
                );
            }
            return m_directions.m_steps[index.row()].plainDescription();

    }

    return QVariant();
}

QModelIndex DirectionsModel::index(int row, int column /*= 0*/, const QModelIndex &parent /*= QModelIndex()*/ ) const {
    Q_ASSERT(column==0);
    Q_ASSERT(!parent.isValid());
    Q_ASSERT(row>=0 && row<=m_directions.m_steps.length());

    if ( row>=m_directions.m_steps.length() ) return createIndex(row, column, NULL);
    return createIndex(row, column, &m_directions.m_steps[row]);
}
