/*
 * Copyright 2010 Felipe Crochik <foss@crochik.com>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "directionsdlg.h"
#include "ui_directionsdlg.h"

DirectionsDlg::DirectionsDlg(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::DirectionsDlg)
{
    ui->setupUi(this);

    connect(ui->okBtt, SIGNAL(clicked()), SLOT(accept()));
}

DirectionsDlg::~DirectionsDlg()
{
    delete ui;
}

void DirectionsDlg::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

QString DirectionsDlg::startAddress() {
    return ui->startEdit->text();
}

QString DirectionsDlg::destinationAddress() {
    return ui->destinationEdit->text();
}

void DirectionsDlg::setStartAddress(QString value) {
    ui->startEdit->setText(value);
}

void DirectionsDlg::setStartAddressToCurrentPos(bool isCurrent) {
    ui->startEdit->setVisible(!isCurrent);
    ui->startLbl->setVisible(!isCurrent);
    // ui->startEdit->setEnabled(false);
}

void DirectionsDlg::setDestinationAddress(QString value) {
    ui->destinationEdit->setText(value);
}

QString DirectionsDlg::mode() {
    return ui->travelModelCombo->currentText().toLower();
}

QStringList DirectionsDlg::avoid() {
    QStringList avoid;
    if ( ui->avoidHighwaysCheck->isChecked() ) avoid << "highways";
    if ( ui->avoidTollsCheck->isChecked() ) avoid << "tolls";
    return avoid;
}

QString DirectionsDlg::units() {
    return ui->unitsCombo->currentText().toLower();
}

bool DirectionsDlg::showAlternatives() {
    return ui->alternativesCheck->isChecked();
}
