/*
 * Copyright 2010 Felipe Crochik <foss@crochik.com>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "currdirectionsdlg.h"
#include "ui_currdirectionsdlg.h"

#include <QFont>

#include "directionsmodel.h"
#include "directionsitemdelegate.h"

CurrDirectionsDlg::CurrDirectionsDlg(QList<Directions> directions, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::CurrDirectionsDlg)
{
    m_pModel = NULL;
    m_pItemDelegate = NULL;
    m_button = ButtonNone;
    m_directions = directions;
    m_stepIndex = -1;

    ui->setupUi(this);

    m_pItemDelegate = new DirectionsItemDelegate(ui->directionsList);

    for ( int c=0; c<m_directions.length(); c++ ) {
        ui->routesCombo->addItem(m_directions[c].m_summary);
    }
    ui->routesCombo->setVisible(m_directions.length()>1);

#ifdef Q_WS_MAEMO_5
    ui->copyrightLbl->setStyleSheet("QLabel{font: 'Nokia Sans'; font-size: 8pt;}");

    m_pItemDelegate->m_font = QFont("Nokia Sans", 24);
#else
    m_pItemDelegate->m_font = ui->directionsList->font();
#endif

    ui->directionsList->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    ui->directionsList->setWordWrap(true);
    ui->directionsList->setItemDelegate(m_pItemDelegate);
}

CurrDirectionsDlg::~CurrDirectionsDlg()
{
    if ( m_pModel ) { delete m_pModel; m_pModel=NULL; }

    delete ui;
}

void CurrDirectionsDlg::on_routesCombo_currentIndexChanged(int index) {
    if ( index<0 || index>m_directions.length() ) return;
    Directions& dir(m_directions[index]);

    if ( m_pModel ) { delete m_pModel; m_pModel=NULL; }
    m_pModel = new DirectionsModel(dir,this);

    QFontMetrics metrics(ui->directionsList->font());

    int right = 0;
    for ( int c=0; c<dir.m_steps.length(); c++ ) {
        int w = metrics.width(dir.m_steps[c].m_distanceStr);
        if ( w>right ) right = w;

        w = metrics.width(dir.m_steps[c].m_durationStr);
        if ( w>right ) right = w;
    }

    Q_ASSERT(m_pItemDelegate);
    m_pItemDelegate->m_leftMargin = metrics.width("000");
    m_pItemDelegate->m_rightMargin = right + 10;
    m_pItemDelegate->m_vertMargin = QFontMetrics(m_pItemDelegate->m_font).height() / 2;

    ui->directionsList->setModel(m_pModel);

    /*
    ui->directionsList->clear();
    for ( int c=0; c<dir.m_steps.length(); c++ ) {
        QString str = dir.m_steps[c].description();
        str = str.replace(QRegExp("<[/A-Za-z][a-zA-Z0-9]*[^>]*>"), QString(" "));
        str = str.replace(QRegExp("\\s\\s"), QString(" "));
        ui->directionsList->addItem(str);
    }
    */

    if (dir.m_copyrights.isEmpty()) {
        ui->copyrightLbl->setVisible(false);
    } else {
        ui->copyrightLbl->setText(dir.m_copyrights);
        ui->copyrightLbl->setVisible(true);
    }
}

void CurrDirectionsDlg::on_recalculateBtt_clicked() {
    m_button = ButtonRecalculate;
    accept();
}

void CurrDirectionsDlg::on_newBtt_clicked() {
    m_button = ButtonNew;
    accept();
}

void CurrDirectionsDlg::on_clearBtt_clicked() {
    m_button = ButtonClear;
    accept();
}

int CurrDirectionsDlg::selectedRoutIndex() {
    return ui->routesCombo->currentIndex();
}

int CurrDirectionsDlg::selectedStepIndex() {
    return m_stepIndex;
}

void CurrDirectionsDlg::on_directionsList_doubleClicked(QModelIndex index) {
}

void CurrDirectionsDlg::on_directionsList_clicked(QModelIndex index) {
    int routeIndex = selectedRoutIndex();
    if ( routeIndex<0 || routeIndex>=m_directions.length() ) return;

    Directions& dir(m_directions[routeIndex]);
    if ( index.row()<0 || index.row()>=dir.m_steps.length() ) return;

    m_stepIndex = index.row();
    m_button = ButtonStep;
    accept();
}
