#!/usr/bin/env python
import sys
import os
import cPickle

from gargoyle_launcher_gui import *

CURRENTVERSION = "0.1.1"

class GLaunch(QtGui.QMainWindow):
    def __init__(self, argv, parent=None):
        #build parent user interface
        QtGui.QWidget.__init__(self, parent)
        self.closeOnExit = True
        self.ui = Ui_MainWindow()
        self.ui.setupUi(self)
        self.setup_settings()
        #connect buttons
        QtCore.QObject.connect(self.ui.pushButtonBrowse, QtCore.SIGNAL('clicked()'), self.doBrowse)
        QtCore.QObject.connect(self.ui.pushButtonAddGame, QtCore.SIGNAL('clicked()'), self.doAddGame)
        QtCore.QObject.connect(self.ui.pushButtonDelete, QtCore.SIGNAL('clicked()'), self.doDelGame)
        QtCore.QObject.connect(self.ui.pushButtonLaunch, QtCore.SIGNAL('clicked()'), self.doLaunch)

        QtCore.QObject.connect(self.ui.actionAbout, QtCore.SIGNAL('triggered()'), self.showAbout)


        try:                                
            self.ui.lineEditPath.setText(sys.argv[1])
        except:          
            print "no arguments"
            self.load_settings()
        
        if(self.closeOnExit):
            self.ui.checkBoxShutdown.setCheckState(QtCore.Qt.Checked)
        else:
            self.ui.checkBoxShutdown.setCheckState(QtCore.Qt.Unchecked)


    def doBrowse(self):
        self.fileName = QtGui.QFileDialog.getOpenFileName(self, "Open", self.ui.lineEditPath.text(), "All Files (*)")
        self.ui.lineEditPath.setText(self.fileName)

    def doLaunch(self):
#        os.system("cd /home/user/MyDocs/ && /usr/bin/gargoyle " + str(self.ui.lineEditPath.text()) + " &")
#        self.settings.setValue("last_path", self.ui.lineEditPath.text())
#        self.settings.setValue("close_on_exit", self.ui.checkBoxShutdown.isChecked())
        os.system("cd /home/user/MyDocs/ && /usr/bin/gargoyle " 
                        + str(self.ui.listWidgetGames.item(self.ui.listWidgetGames.currentRow()).text()) 
                        + " &")
        if(self.ui.checkBoxShutdown.isChecked()):
            self.close()


    def doAddGame(self):
        add = 1
        for i in range(self.ui.listWidgetGames.count()): #let's not create duplicates, so lets do a search.
            if self.ui.listWidgetGames.item(i).text() == self.ui.lineEditPath.text():
                add = 0
        if add: #Okay, it wasn't found.  Let's add it.
            self.ui.listWidgetGames.addItem(self.ui.lineEditPath.text())

    def doDelGame(self):
        self.ui.listWidgetGames.takeItem(self.ui.listWidgetGames.currentRow())

    def setup_settings(self):
        settings = QtCore.QSettings()
        QtCore.QCoreApplication.setOrganizationName('gman.me.uk')
        QtCore.QCoreApplication.setOrganizationDomain('gman.me.uk')
        QtCore.QCoreApplication.setApplicationName('Gargoyle Launcher')
        self.settings = settings

    def load_settings(self):
        try:
            self.ui.lineEditPath.setText(str(self.settings.value("last_path").toString()))
            self.closeOnExit = self.settings.value("close_on_exit").toBool()
            print str(self.settings.value("last_path").toString())

            games_list = cPickle.loads(str(self.settings.value("games_list").toString()))
            for path in games_list:
                 self.ui.listWidgetGames.addItem(path)
            

        except:
            print "firstRun... no Savefile found"
            self.ui.lineEditPath.setText("/home/user/MyDocs/.documents/")


    def closeEvent(self, event):
        print "closing"        
        self.settings.setValue("last_path", self.ui.lineEditPath.text())
        self.settings.setValue("close_on_exit", self.ui.checkBoxShutdown.isChecked())
        
        items = []
        for index in xrange(self.ui.listWidgetGames.count()):
            items.append(self.ui.listWidgetGames.item(index).text())

        saveData = cPickle.dumps(items)
        self.settings.setValue("games_list", saveData)

    def showAbout(self):
        aboutString = "Gargoyle Launcher: v" + CURRENTVERSION + "\nGirish Gopi (maemo@gman.me.uk)\nSimple Gui to act as a frontend for Gargoyle, the Interactive Fiction Player (http://ccxvii.net/gargoyle/)"
        QtGui.QMessageBox.information(self, "About Gargoyle Launch", aboutString)


if __name__ == "__main__":
    #This function means this was run directly, not called from another python file.

    # We instantiate a QApplication passing the arguments of the script to it:
    app = QtGui.QApplication(sys.argv)

    glaunch = GLaunch(sys.argv[1:])
    glaunch.show()

    # Now we can start it.
    sys.exit(app.exec_())

