#!/usr/bin/python
# -*- coding: utf-8 -*-

import sys
from juegoVida import Matriz
from PyQt4 import QtCore, QtGui


class About(object):
    def setupUi(self, Form):
        Form.setObjectName("About")
        Form.resize(400, 300)
        self.verticalLayout = QtGui.QVBoxLayout(Form)
        self.verticalLayout.setObjectName("verticalLayout")
        self.label = QtGui.QLabel(Form)
        self.label.setAlignment(QtCore.Qt.AlignCenter)
        self.label.setObjectName("label")
        self.verticalLayout.addWidget(self.label)

        self.retranslateUi(Form)
        QtCore.QMetaObject.connectSlotsByName(Form)

    def retranslateUi(self, Form):
        Form.setWindowTitle(QtGui.QApplication.translate("About", "About", None, QtGui.QApplication.UnicodeUTF8))
        self.label.setText(QtGui.QApplication.translate("About", "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\" \"http://www.w3.org/TR/REC-html40/strict.dtd\">\n"
"<html><head><meta name=\"qrichtext\" content=\"1\" /><style type=\"text/css\">\n"
"p, li { white-space: pre-wrap; }\n"
"</style></head><body style=\" font-family:\'Ubuntu\'; font-size:11pt; font-weight:400; font-style:normal;\">\n"
"<p align=\"center\" style=\" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-size:16pt; font-weight:600;\">Game of Life</span></p>\n"
"<p align=\"center\" style=\" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-size:12pt; font-weight:600;\">v0.1</span></p>\n"
"<p align=\"center\" style=\"-qt-paragraph-type:empty; margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px; font-size:12pt; font-weight:600;\"></p>\n"
"<p align=\"center\" style=\" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><img src=\"/usr/share/icons/hicolor/48x48/hildon/gameoflife.png\" /></p>\n"
"<p align=\"center\" style=\"-qt-paragraph-type:empty; margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px; font-size:12pt; font-weight:600;\"></p>\n"
"<p align=\"center\" style=\" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\">by NerdKnight </p>\n"
"<p align=\"center\" style=\" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\">&lt;<a href=\"mailto:nerdknight@gmail.com\">nerdknight@gmail.com</a>&gt;</p></body></html>", None, QtGui.QApplication.UnicodeUTF8))
        
class MainWindow(QtGui.QMainWindow):
    def __init__(self,parent=None):
        QtGui.QMainWindow.__init__(self,parent)
        self.ui=Ui_MainWindow()
        self.ui.setupUi(self)
    def closeEvent(self,ev):
        self.ui.close()
class Ui_MainWindow(object):
    def setupUi(self, MainWindow):
        self.mw=MainWindow
        MainWindow.setObjectName("MainWindow")
        MainWindow.resize(800, 480)
        self.centralwidget = QtGui.QWidget(MainWindow)
        self.centralwidget.setObjectName("centralwidget")
        self.horizontalLayout = QtGui.QHBoxLayout(self.centralwidget)
        self.horizontalLayout.setObjectName("horizontalLayout")
        self.gridLayout = QtGui.QGridLayout()
        self.gridLayout.setObjectName("gridLayout")
        self.btnStart = QtGui.QPushButton(self.centralwidget)
        self.btnStart.setObjectName("btnStart")
        self.gridLayout.addWidget(self.btnStart, 0, 4, 1, 1)
        self.btnStep = QtGui.QPushButton(self.centralwidget)
        self.btnStep.setObjectName("btnStep")
        self.gridLayout.addWidget(self.btnStep, 0, 5, 1, 1)
        self.horizontalLayout_2 = QtGui.QHBoxLayout()
        self.horizontalLayout_2.setObjectName("horizontalLayout_2")
        self.matriz = Matriz(cantX=44,cantY=40)
        self.matriz.setObjectName("matriz")
        self.horizontalLayout_2.addWidget(self.matriz)
        self.gridLayout.addLayout(self.horizontalLayout_2, 0, 0, 7, 4)
        self.btnKill = QtGui.QPushButton(self.centralwidget)
        self.btnKill.setObjectName("btnKill")
        self.gridLayout.addWidget(self.btnKill, 2, 4, 1, 2)
        self.btnRandomize = QtGui.QPushButton(self.centralwidget)
        self.btnRandomize.setObjectName("btnRandomize")
        self.gridLayout.addWidget(self.btnRandomize, 1, 4, 1, 2)
        self.cboPatterns = QtGui.QComboBox(self.centralwidget)
        self.cboPatterns.setObjectName("cboPatterns")
        self.gridLayout.addWidget(self.cboPatterns, 3, 4, 1, 2)
        self.txtInterval = QtGui.QDoubleSpinBox(self.centralwidget)
        self.txtInterval.setMinimum(0.25)
        self.txtInterval.setMaximum(5.0)
        self.txtInterval.setSingleStep(0.25)
        self.txtInterval.setProperty("value", self.matriz.getInterval())
        self.txtInterval.setObjectName("txtInterval")
        self.gridLayout.addWidget(self.txtInterval, 4, 4, 1, 1)
        self.gridLayout.setColumnStretch(0, 10)
        self.horizontalLayout.addLayout(self.gridLayout)
        MainWindow.setCentralWidget(self.centralwidget)
        self.menuBar = QtGui.QMenuBar(MainWindow)
        self.menuBar.setGeometry(QtCore.QRect(0, 0, 651, 23))
        self.menuBar.setObjectName("menuBar")
        self.menuGame = QtGui.QMenu(self.menuBar)
        self.menuGame.setObjectName("menuGame")
        MainWindow.setMenuBar(self.menuBar)
        self.actionAbout = QtGui.QAction(MainWindow)
        self.actionAbout.setObjectName("actionAbout")
        self.menuGame.addAction(self.actionAbout)
        
        self.actionExit = QtGui.QAction(MainWindow)
        self.actionExit.setObjectName("actionExit")
        self.menuGame.addAction(self.actionExit)
        self.menuBar.addAction(self.menuGame.menuAction())

        self.retranslateUi(MainWindow)

        """
        Inicialización de matriz
        """
        self.cboPatterns.addItem("Point",None)
        for i in range(len(self.matriz.getPatrones())):
            p=self.matriz.getPatrones()[i]
            self.cboPatterns.addItem(p.getNombre(),p)
        QtCore.QObject.connect(self.matriz,QtCore.SIGNAL("start"),self.lblBtnStop)
        QtCore.QObject.connect(self.matriz,QtCore.SIGNAL("stop"),self.lblBtnStart)
        """
        Signals
        """
        QtCore.QMetaObject.connectSlotsByName(MainWindow)
        QtCore.QObject.connect(self.btnStart, QtCore.SIGNAL("clicked()"), self.startStop)
        QtCore.QObject.connect(self.btnStep, QtCore.SIGNAL("clicked()"), self.step)
        QtCore.QObject.connect(self.btnRandomize, QtCore.SIGNAL("clicked()"), self.matriz.initCelulas)
        QtCore.QObject.connect(self.txtInterval, QtCore.SIGNAL("valueChanged(double)"), self.matriz.setInterval)
        QtCore.QObject.connect(self.btnKill, QtCore.SIGNAL("clicked()"), self.matriz.killAll)
        QtCore.QObject.connect(self.cboPatterns, QtCore.SIGNAL("currentIndexChanged(int)"), self.cboPatternClick)
        QtCore.QObject.connect(self.menuBar, QtCore.SIGNAL("triggered(QAction*)"), self.menuEvt)
    def lblBtnStop(self):
        self.btnStart.setText("Stop")
    def lblBtnStart(self):
        self.btnStart.setText("Start")    
    def menuEvt(self,qa):
        if qa==self.actionExit:
            self.mw.close()
        elif qa==self.actionAbout:
            Form = QtGui.QDialog(self.mw)
            ui = About()
            ui.setupUi(Form)
            Form.setModal(True)
            Form.show()
          
    def startStop(self):
        if self.btnStart.text()=="Start":
            self.matriz.start()
        else:
            self.matriz.stop()
    def step(self):
        self.matriz.stop()
        self.matriz.stepForward()
    def cboPatternClick(self,index):
        patron=self.cboPatterns.itemData(index)
        if patron!=None:
            self.matriz.setPatronActual(patron.toPyObject())
        else:
            self.matriz.setPatronActual(None)
    def retranslateUi(self, MainWindow):
        MainWindow.setWindowTitle(QtGui.QApplication.translate("MainWindow", "Game of Life", None, QtGui.QApplication.UnicodeUTF8))
        self.btnStart.setText(QtGui.QApplication.translate("MainWindow", "Start", None, QtGui.QApplication.UnicodeUTF8))
        self.btnStep.setText(QtGui.QApplication.translate("MainWindow", "Step", None, QtGui.QApplication.UnicodeUTF8))
        self.btnKill.setText(QtGui.QApplication.translate("MainWindow", "Kill all", None, QtGui.QApplication.UnicodeUTF8))
        self.btnRandomize.setText(QtGui.QApplication.translate("MainWindow", "Randomize", None, QtGui.QApplication.UnicodeUTF8))
        self.menuGame.setTitle(QtGui.QApplication.translate("MainWindow", "Game", None, QtGui.QApplication.UnicodeUTF8))
        self.actionAbout.setText(QtGui.QApplication.translate("MainWindow", "About", None, QtGui.QApplication.UnicodeUTF8))
        self.actionExit.setText(QtGui.QApplication.translate("MainWindow", "Exit", None, QtGui.QApplication.UnicodeUTF8))
    def close(self):
        self.matriz.stop()


if __name__ == "__main__":
    app = QtGui.QApplication(sys.argv)
    MainWindow = MainWindow()
    MainWindow.show()
    sys.exit(app.exec_())

