#include "shultetable.h"
#include <QPainter>
#include <QTime>

ShulteTable::ShulteTable(QWidget *parent) :
    QWidget(parent)
{
    m_rowsCount = 5;
    m_vector.resize(m_rowsCount*m_rowsCount);
    qsrand(QTime::currentTime().msec());
    generateNew();
}

void ShulteTable::setRowsCount(int n){
    m_rowsCount = n;
    m_vector.resize(n*n);
}

void ShulteTable::paintEvent(QPaintEvent *){
    QPainter p(this);
    int deltaX, deltaY;

    QPixmap pxm(":/img/greenpoint.png");

    p.drawPixmap((width()-pxm.width())/2,(height()-pxm.height())/2,pxm);

    if (width()>height()){
        m_tableSize=height();
        deltaX = (width()-height())/2;
        deltaY = 0;
    } else {
        m_tableSize=width();
        deltaY = (height()-width())/2;
        deltaX = 0;
    }

    p.drawRect(deltaX,deltaY,m_tableSize-1,m_tableSize-1);

    int step = m_tableSize/m_rowsCount;
    int i,j;

    for (i=0;i<m_rowsCount;i++)
        for (j=0;j<m_rowsCount;j++)
            p.drawText(QRect(deltaX+step*i,deltaY+step*j,step,step),Qt::AlignCenter,QString().setNum(m_vector[i*m_rowsCount+j]));

    for (i=1;i<m_rowsCount;i++)
        p.drawLine(deltaX+step*i,deltaY,deltaX+step*i,deltaY+m_tableSize-1);

    for (i=1;i<m_rowsCount;i++)
        p.drawLine(deltaX,deltaY+step*i,deltaX+m_tableSize-1,deltaY+step*i);

    p.end();
}

void ShulteTable::generateNew(){
    int i,k,l,t;

    for (i=0;i<m_vector.size();i++)
        m_vector[i]=i+1;

    for (i=0;i<m_vector.size();i++){
        k = qrand()%m_vector.size();
        l = qrand()%m_vector.size();
        t = m_vector[k];
        m_vector[k]=m_vector[l];
        m_vector[l]=t;
    }
}

int ShulteTable::rowsCount(){
   return m_rowsCount;
}
