#ifndef EXERCISEWIDGET_H
#define EXERCISEWIDGET_H

#include "exercise.h"
#include "exerciserapid.h"
#include "exerciseclassic.h"
#include "exerciseshulte.h"

#include <QWidget>
#include <QVBoxLayout>
#include <QSlider>
#include <QAction>

class ExerciseWidget : public QWidget
{
Q_OBJECT
public:
    explicit ExerciseWidget(QWidget *parent = 0);
    void setText(QString&);
    void showPauseNotification();

signals:
    void showEditor();
    void gotoStart();
    void exerciseChanged(bool);

public slots:
    void selectExercise(int);

private slots:
    void emitShowEditor();
    void emitGotoStart();
    void startPause();
    void start();
    void pause();
    void stop();
    void showSettings();
    void setMaxProgress(int);

private:
    Exercise *exercise;
    QVBoxLayout m_vbLayout;
    QSlider m_slider;
    QAction *m_actionOpen;
    QAction *m_actionSettings;
    QAction *m_actionFaster;
    QAction *m_actionSlower;
    QAction *m_actionZoomIn;
    QAction *m_actionZoomOut;
    QAction *m_actionStartPause;
    QAction *m_actionStop;
    QAction *m_actionGotoStart;
    QLabel m_lblSpeed;
    QLabel *m_lblProgress;
    QWidget *m_settingsWidget;
};

#endif // EXERCISEWIDGET_H
