#ifndef EXERCISE_H
#define EXERCISE_H

#include <QWidget>

class Exercise : public QWidget
{
Q_OBJECT
public:
    explicit Exercise(QWidget *parent = 0);
    virtual QWidget* settingsWidget() {return NULL;};
    virtual bool advancedMode() {return false;};
    virtual void setText(QString&) {};
    virtual void showExerciseInfo() {};
    virtual bool isEmptyText() {return false;};
    virtual bool isActive() {return false;};
    virtual int maxProgress() {return 0;};
    virtual int speed(){return 0;};
    virtual int mode(){return Exercise::None;};
    enum Mode {Rapid=0, Classic, Shulte, Numbers, Flick, None};
signals:
    void progressChanged(int);
    void clicked();
    void maxZoomExceed(bool);
    void minZoomExceed(bool);
    void maxSpeedExceed(bool);
    void minSpeedExceed(bool);
    void speedChanged(int);
    void maxProgressChanged(int);
public slots:
    virtual void start(){};
    virtual void pause(){};
    virtual void stop(){};
    virtual void tick(){};
    virtual void zoomIn(){};
    virtual void zoomOut(){};
    virtual void faster(){};
    virtual void slower(){};
    virtual void setOffset(int){};
};

#endif // EXERCISE_H
