#include "editorwidget.h"

#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QPushButton>
#include <QFileDialog>
#include <QTextStream>
#include <QFile>
#include <QIcon>
#include <QApplication>
#include <QDir>

EditorWidget::EditorWidget(QWidget *parent):
    QWidget(parent)
{
    setWindowFlags(Qt::Dialog);
    QVBoxLayout *vbLayout = new QVBoxLayout;
    vbLayout->setSpacing(2);
    vbLayout->setMargin(2);

    txtEditor = new QPlainTextEdit;

    vbLayout->addWidget(txtEditor);

    QPushButton *btnOK = new QPushButton(tr("OK"));
    btnOK->setIcon(QIcon::fromTheme("window-close", QIcon(":/img/ok.png")));
    QPushButton *btnOpenFile = new QPushButton(tr("Open File"));
    btnOpenFile->setIcon(QIcon::fromTheme("document-open", QIcon(":/img/open.png")));
    QPushButton *btnSaveFile = new QPushButton(tr("Save As File"));
    btnSaveFile->setIcon(QIcon::fromTheme("document-save-as", QIcon(":/img/save.png")));

    QHBoxLayout *hbLayout = new QHBoxLayout;

    hbLayout->addWidget(btnOpenFile);
    hbLayout->addWidget(btnSaveFile);
    hbLayout->addStretch();
    hbLayout->addWidget(btnOK);

    vbLayout->addLayout(hbLayout);

    setLayout(vbLayout);

    connect(btnOK,SIGNAL(clicked()),this,SLOT(btnOKClicked()));
    connect(btnOpenFile,SIGNAL(clicked()),this,SLOT(load()));
    connect(btnSaveFile,SIGNAL(clicked()),this,SLOT(save()));
    connect(txtEditor,SIGNAL(textChanged()),this,SLOT(textChanged()));

    m_isChanged = false;
}

void EditorWidget::save(){
    QString fileName;
    fileName = QFileDialog::getSaveFileName(this,tr("Save text to file"),QDir::homePath(),tr("Text files (*.txt)"));
    if (!fileName.isEmpty()) {
        QFile file(fileName);
        file.open(QIODevice::WriteOnly|QIODevice::Text);

        QTextStream txtStream(&file);
        txtStream << txtEditor->toPlainText();

        file.close();
    }
}

void EditorWidget::load(){
    QString fileName;
    fileName = QFileDialog::getOpenFileName(this,tr("Load text from file"),QDir::homePath(),tr("Text files (*.txt)"));
    if (!fileName.isEmpty()) {
        QApplication::setOverrideCursor(QCursor(Qt::WaitCursor));
        QFile file(fileName);
        file.open(QIODevice::ReadOnly|QIODevice::Text);

        QTextStream txtStream(&file);
        txtEditor->setPlainText(txtStream.readAll());

        file.close();
        m_isChanged = true;
        QApplication::restoreOverrideCursor();
    }
}

QString& EditorWidget::getText(){
    m_isChanged = false;
    m_text = txtEditor->toPlainText();
    return m_text;
}

void EditorWidget::btnOKClicked(){
    emit done(m_isChanged);
}

void EditorWidget::textChanged(){
    m_isChanged = true;
}
