/* 
 * This file is part of fuelpad, the fuel diary
 *
 * Copyright (c) 2007-2010 Julius Luukko <julle.luukko@quicknet.inet.fi>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

/**
 *
 * \file
 * \brief  Utility functions to fuelpad
 * \author Julius Luukko
 *
 *
 */

#ifndef _UTIL_H_
#define _UTIL_H_

#include <gdk/gdk.h>

enum unit {SI, US, IMPERIAL};

/* Units */
struct _unit {
  enum unit mainunit;
  enum unit lengthunit;
  enum unit volumeunit;
  enum unit consumeunit;
  enum unit massunit;
  gboolean individualunit;
  GString *currency;
  gint dateformat;
};

typedef struct _unit unit_t;

/*******************************************************************
 *
 * Public variables
 *
 *******************************************************************/

extern unit_t curunit;

/*******************************************************************
 *
 * Public functions 
 *
 *******************************************************************/

/* Unit conversion functions */
double SIlength2user(double length);
double user2SIlength(double length);
double SIvolume2user(double length);
double user2SIvolume(double length);
double SIconsumption2user(double consum);
double user2SIconsumption(double consum);
double SIppl2user(double ppl);
double SImass2user(double mass);
double SIemission2user(double emission);
double SIpricepertrip2user(double ppt);
double user2SIpricepertrip(double ppt);
double grams2kg(double grams);

void convdate(char **s, const char *outformat, 
	      const char *informat, const char *date);
void convunixtime(char **s, const char *outformat, time_t time);
void date2sqlite(char **s, const char *format, const char *date);
void gettimefmt(char **aika, const char *format);
void unixtimefmt(const time_t unixtime, char **aika, const char *format);
void gettime(char **aika);
int getyear(void);
void getyearmonthday(const char *datestr, int *year, int *month, int *day);
time_t getmktime(void);
double doubleornothing(double input);
char *store_locale(int category);
void restore_locale(int category, char *psave);
double atof_l(const char *nptr, const char *locale);
float get_emission_per_litre(int fueltype);
gboolean is_sqlite3_file(const char *filename);

#endif
