/* 
 * This file is part of fuelpad, the fuel diary
 *
 * Copyright (c) 2007-2010 Julius Luukko <julle.luukko@quicknet.inet.fi>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef _UIFILTER_H_
#define _UIFILTER_H_

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include "ui.h"

/*******************************************************************
 *
 * Public defines
 *
 *******************************************************************/

typedef struct filterentry {
  GtkWidget *removebutton;
#if MAEMO_VERSION_MAJOR == 5
  GtkWidget *andorbutton;
#else
  GtkWidget *label;
#endif
  GtkWidget *andorcombo;
  GtkWidget *minentry;
  GtkWidget *maxentry;
} filterentry_t;

typedef struct recordfilter {
  filterentry_t entry;
  GString *mindate;
  GString *maxdate;
  GString *notes;
  GPatternSpec *pattern;
  gdouble minval;
  gdouble maxval;
  gboolean and;
  int column;
} recordfilter_t;

/*******************************************************************
 *
 * Public variables
 *
 *******************************************************************/

extern recordfilter_t recfilter;
extern GList *filterqueue;

/*******************************************************************
 *
 * Public functions
 *
 *******************************************************************/

void filter_init(recordfilter_t *filt);
void filter_clear(recordfilter_t *filt);
guint filter_filterqueue_length(void);
void callback_filter_records( GtkAction * action, AppUIData *pui );

#endif
