/*
 * This file is part of fuelpad, the fuel diary
 *
 * Copyright (c) 2007-2010 Julius Luukko <julle.luukko@quicknet.inet.fi>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef _UI_H_
#define _UI_H_

#define _GNU_SOURCE

#include <config.h>

#if PLAINGTK == 0
# if HILDON == 1
#  if MAEMO_VERSION_MAJOR == 5
#     include <hildon/hildon.h>
#  endif
#  include <hildon/hildon-program.h>
#  include <hildon/hildon-banner.h>
#  include <hildon/hildon-wizard-dialog.h>
#  include <hildon/hildon-note.h>
#  include <hildon/hildon-number-editor.h>
#  include <hildon/hildon-date-editor.h>
#  include <hildon-fm-2/hildon/hildon-file-chooser-dialog.h>
#  include <hildon-fm-2/hildon/hildon-file-system-model.h>
#  include <dbus/dbus.h>
#  if MAEMO_VERSION_MAJOR == 5
#     include <mce/mode-names.h>
#     include <mce/dbus-names.h>
#  endif
#  if LIBHELP == 1
#    include <hildon/hildon-help.h>
#  endif
# else
#  include <hildon-widgets/hildon-program.h>
#  include <hildon-widgets/hildon-banner.h>
#  include <hildon-widgets/hildon-input-mode-hint.h>
#  include <hildon-widgets/hildon-number-editor.h>
#  include <hildon-widgets/hildon-date-editor.h>
#  include <hildon-widgets/hildon-file-chooser-dialog.h>
#  include <hildon-widgets/hildon-file-system-model.h>
#  include <osso-helplib.h>
# endif
# include <libosso.h>
#endif
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/gdkkeysyms.h>
#include <gconf/gconf-client.h>

#include <gtkextra/gtkplot.h>
#include <gtkextra/gtkplotdata.h>
#include <gtkextra/gtkplotbar.h>
#include <gtkextra/gtkplotcanvas.h>
#include <gtkextra/gtkplotcanvastext.h>
#include <gtkextra/gtkplotcanvasline.h>
#include <gtkextra/gtkplotcanvasplot.h>
#include <gtkextra/gtkplotprint.h>

#include <libintl.h>
#include <locale.h>

#include <stdlib.h>
#define _GNU_SOURCE
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <locale.h>
#include <time.h>

#include "fuelpad.h"
#include "util.h"

/* For rotation support */
#if PLAINGTK == 0
#if MAEMO_VERSION_MAJOR == 5
#define MCE_SIGNAL_MATCH "type='signal'," \
        "sender='"    MCE_SERVICE     "'," \
        "path='"      MCE_SIGNAL_PATH "'," \
        "interface='" MCE_SIGNAL_IF   "'"
#endif
#endif

#define _(String) gettext(String)
#define gettext_noop(String) String

/* Import window */
#define IMPORTCOLS 9

/* Add record dialog */
#define ENTRYDATEMAX 20
#define ENTRYKMMAX 8
#define ENTRYTRIPMAX 8
#define ENTRYFILLMAX 8
#define ENTRYPRICEMAX 8
#define ENTRYNOTESMAX 50
#define ENTRYSERVICEMAX 8
#define ENTRYOILMAX 8
#define ENTRYTIRESMAX 8

/* Maximum lengths of some buffers */
#define DFFORMATLEN 7
#define BUFMAX 10

#define HELP_ID_PREFIX "help_fuelpad_"
#define HELP_ID_INTRO HELP_ID_PREFIX"intro"
#define HELP_ID_SETTINGS HELP_ID_PREFIX"settings"
#define HELP_ID_ADDCAR HELP_ID_PREFIX"addcardialog"
#define HELP_ID_ADDDRIVER HELP_ID_PREFIX"adddriverdialog"
#define HELP_ID_ADDRECORD HELP_ID_PREFIX"addrecorddialog"
#define HELP_ID_REPORT HELP_ID_PREFIX"yearly"
#define HELP_ID_ALARM HELP_ID_PREFIX"reminders"
#define HELP_ID_EDITEVENT HELP_ID_PREFIX"editevent"
#define HELP_ID_ADDEVENT HELP_ID_PREFIX"addevent"
#define HELP_ID_ADDREMINDER HELP_ID_PREFIX"addreminder"
#define HELP_ID_EDITREMINDER HELP_ID_PREFIX"editreminder"
#define HELP_ID_STATISTICS HELP_ID_PREFIX"monthly"
#define HELP_ID_DATABASE HELP_ID_PREFIX"database"
#define HELP_ID_MAINWIN HELP_ID_PREFIX"mainwindow"
#define HELP_ID_FILTER HELP_ID_PREFIX"filter"

#define YSCALE(y) ((y)*(400.0/700.0*GTK_PLOT_A4_W/GTK_PLOT_A4_H))

#define DIALOG_MIN_HEIGHT0 300
#define DIALOG_MIN_HEIGHT1 200
#define DIALOG_MIN_HEIGHT2 150
#define DIALOG_MIN_HEIGHTMAX 400
#define DIALOG_MIN_WIDTH1 720

enum
{
  COL_DAY = 0,
  COL_KM,
  COL_TRIP,
  COL_FILL,
  COL_CONSUM,
  COL_PRICE,
  COL_PRICEPERTRIP,
  COL_PRICEPERLITRE,
  COL_SERVICE,
  COL_OIL,
  COL_TIRES,
/*   COL_INSURANCE, */
/*   COL_OTHER, */
  COL_CO2EMISSION,
  COL_NOTES,
  COL_ICON,
  COL_COMBINED,
  COL_ID,
  COL_VISIBLE,
  NUM_COLS
};

/* for tree view data function */
typedef struct {
  int col;
  char format[DFFORMATLEN];
} data_func_t;

/* Unit combo type */
enum {
  UNITCOMBO=0,
  LENGTHCOMBO,
  VOLUMECOMBO,
  CONSUMECOMBO,
  MASSCOMBO
};

/* Paper */
enum papertype {
  A4PAPER,
  LETTERPAPER
};

/* UI style */
enum userinterfacestyle {
  UIFANCY,
  UICLASSIC,
};

enum fontscale {
  XSMALL=1,
  SMALL,
  MEDIUM,
  LARGE
};

typedef struct _AppData AppData;

struct _AppData
{
#if PLAINGTK == 0
  HildonProgram *program;     /* handle to application */
#if MAEMO_VERSION_MAJOR == 5
  GtkWidget *mainwindow;   /* handle to main window */
#else
  HildonWindow *mainwindow;   /* handle to main window */
#endif
  HildonWindow *statwindow;   /* handle to statistics window */
  HildonWindow *reportwindow; /* handle to report window */
  HildonWindow *alarmwindow;  /* handle to alarm window */
  HildonWindow *drivinglogwindow;  /* handle to driving log window */
  HildonWindow *locationswindow;  /* handle to locations window */
  osso_context_t *osso;       /* handle to osso */
#if MAEMO_VERSION_MAJOR == 5
  DBusConnection *system_bus; /* handle to dbus */
#endif
  DBusConnection *session_bus;
#else
  GtkWidget *mainwindow;
  GtkWidget *statwindow;
  GtkWidget *reportwindow;
  GtkWidget *alarmwindow;
#endif
};

typedef struct _AppUIData AppUIData;
struct _AppUIData
{
  /* Handle to app's data */
  AppData *app;

  /* Fullscreen for different windows */
  gboolean mainfullscreen;
  gboolean statfullscreen;
  gboolean reportfullscreen;
  gboolean alarmfullscreen;

  /* Warnings active */
  gboolean warn;

  /* Main window */
  GtkWidget *mainvbox;
  GtkWidget *view;
  GtkWidget *carlabel;
  GtkWidget *driverlabel;
  GtkWidget *servicelabel;
  GtkWidget *oillabel;
  GtkWidget *tireslabel;
  GtkWidget *totalkmlabel;
  GtkWidget *mpglabel;
  GtkWidget *avgconsumlabel;
  GtkWidget *totcostlabel;
  GtkWidget *datascrollwin;
  GtkWidget *main_menu_item_fullscreen;
  GtkWidget *stat_menu_item_fullscreen;
  GtkWidget *report_menu_item_fullscreen;
  GtkWidget *alarm_menu_item_fullscreen;

  /* Main menu */
#if MAEMO_VERSION_MAJOR == 5
  HildonAppMenu *main_menu;
#else
  GtkWidget *main_menu;
#endif
  GtkWidget *mm_menu_db;
  GtkWidget *mm_menu_record;
  GtkWidget *mm_menu_stat;
  GtkWidget *mm_menu_view;
  GtkWidget *mm_menu_toolbar;
  GtkWidget *mm_menu_fontsize;
  GtkWidget *mm_item_db;
  GtkWidget *mm_item_record;
  GtkWidget *mm_item_view;
  GtkWidget *mm_item_sortcolumn;
  GtkWidget *mm_item_settings;
  GtkWidget *mm_item_stat;
  GtkWidget *mm_item_alarm;
  GtkWidget *mm_item_help;
  GtkWidget *mm_item_driving_log;
  GtkWidget *mm_item_about;
  GtkWidget *mm_item_exit;
  GtkWidget *mm_combo_sortcolumn;

  /* Database menu (in main menu) */
  GtkWidget *mm_item_open;
  GtkWidget *mm_item_close;
  GtkWidget *mm_item_import;
  GtkWidget *mm_item_export;

  /* Record menu (in main menu) */
  GtkWidget *mm_item_new;
  GtkWidget *mm_item_edit;
  GtkWidget *mm_item_delete;

  /* Statistics menu (in main menu) */
  GtkWidget *mm_item_quick;
  GtkWidget *mm_item_monthly;
  GtkWidget *mm_item_report;

  /* View menu (in main menu) */
  GtkWidget *mm_item_columnselect;
  GtkWidget *mm_item_filter;
  GtkWidget *mm_item_toolbar;
  GtkWidget *mm_item_fontsize;

  /* Toolbars menu (in View menu) */
  GtkWidget *mm_item_toolbar_main;
  GtkWidget *mm_item_toolbar_secondary;

  /* Font size menu (in View menu) */
  GtkWidget *mm_item_fontsize_x_small;
  GtkWidget *mm_item_fontsize_small;
  GtkWidget *mm_item_fontsize_medium;
  GtkWidget *mm_item_fontsize_large;

#if PLAINGTK == 1
  GtkWidget *mm_menubar;
  GtkWidget *mm_item_file;
#endif

  /* Settings dialog */
#if MAEMO_VERSION_MAJOR == 5
  GtkWidget *databasebutton;
  GtkWidget *carbutton;
  GtkWidget *driverbutton;
  GtkWidget *datebutton;
  GtkWidget *remindbutton;
  GtkWidget *paperbutton;
  GtkWidget *uibutton;
  GtkWidget *uicombo;
  GtkWidget *selectcolumnsbutton;
  GtkWidget *unitsystembutton;
  GtkWidget *lengthunitbutton;
  GtkWidget *volumeunitbutton;
  GtkWidget *consumeunitbutton;
  GtkWidget *massunitbutton;
  GtkWidget *fueltypebutton;
#endif
  GtkWidget *drivercombo;
  GtkWidget *carcombo;
  GtkWidget *datecombo;
  GtkWidget *unitcombo;
  GtkWidget *lengthcombo;
  GtkWidget *volumecombo;
  GtkWidget *consumecombo;
  GtkWidget *masscombo;
  GtkWidget *entrycurrency;
  GtkWidget *entrywarnkm;
  GtkWidget *labelentrywarn;
  GtkWidget *warntimecombo;
  GtkWidget *autonetcheck;
  GtkWidget *autogpscheck;
  GtkWidget *entrylocationsradius;

  /* Main toolbar */
  GtkWidget *main_toolbar;
  GtkToolItem *mtb_add;
  GtkToolItem *mtb_edit;
  GtkToolItem *mtb_up;
  GtkToolItem *mtb_down;
  GtkToolItem *mtb_delete;
  GtkToolItem *mtb_reminder;
  GtkToolItem *mtb_close;

  /* Secondary toolbar */
  GtkWidget *secondary_toolbar;
  GtkToolItem *stb_car;
  GtkToolItem *stb_carapply;
  GtkToolItem *stb_totalkm;
  GtkToolItem *stb_avgconsum;
  GtkToolItem *stb_totcost;
  GtkWidget *stb_carcombo;
  GtkWidget *stb_totalkmlabel;
  GtkWidget *stb_avgconsumlabel;
  GtkWidget *stb_totcostlabel;
#if MAEMO_VERSION_MAJOR == 5
  GtkWidget *stb_carbutton;
#endif
  /* Add driver dialog */
  GtkWidget *entryname;
  GtkWidget *entrynick;

  /* Add car dialog */
  GtkWidget *entrymark;
  GtkWidget *entrymodel;
  GtkWidget *entryyear;
  GtkWidget *entryregister;
  GtkWidget *combofueltype;
  GtkWidget *entrycarnotes;

  /* Add record dialog */
  GtkWidget *entrydate;
  GtkWidget *entrykm;
  GtkWidget *entrytrip;
  GtkWidget *entryfill;
  GtkWidget *buttonnotfull;
  GtkWidget *entryprice;
  GtkWidget *entrynotes;
  GtkWidget *entryservice;
  GtkWidget *entryoil;
  GtkWidget *entrytires;

  /* Select columns dialog*/
  GtkWidget *columncheck[NUM_COLS];

  /* Filter records dialog */
  GtkWidget *filterwindow;
#if MAEMO_VERSION_MAJOR == 5
  GtkWidget *filteraddandorbutton;
#endif

  /* Add filter dialog */
  GtkWidget *addfilterdialog;
  GtkWidget *filterbutton;
  GtkWidget *filtercombo;
  GtkWidget *filtervbox;
  GtkWidget *filtertable;
  GtkWidget *filteraddandorcombo;
  GtkWidget *filteraddminentry;
  GtkWidget *filteraddmaxentry;

  /* Report window */
  GtkWidget *reportcanvas;
  GtkWidget *reportscrollwin;
  GtkWidget *yearcombo;
  GtkWidget *papercombo;
#if MAEMO_VERSION_MAJOR == 5
  GtkWidget *lastyearbutton;
#endif

  /* Import window */
  GtkWidget *colspin[IMPORTCOLS];
  GtkWidget *flspinner;
  GtkWidget *localecombo;
  GtkWidget *dateformatentry;

  /* Statistics window */
  GtkWidget *statscrollwin;
  GtkWidget *canvas;
  GtkWidget **plots;
  GtkWidget *active_plot;
  GtkPlotArray *months;
  GtkPlotCanvasChild *maintitle;
  GtkPlotCanvasChild *subtitle;

  /* Statistics window menu */
  GtkWidget *sm_item_monthly;
  GtkWidget *sm_item_monthlytrip;
  GtkWidget *sm_item_monthlypriceperlitre;
  GtkWidget *sm_item_consumdistr;
#if MAEMO_VERSION_MAJOR == 5
  GtkWidget *sm_stat_combo;
#endif

  /* Alarm window */
  GtkWidget *alarmview;
  GtkWidget *alarmscrollwin;
  GtkWidget *alarmcarcombo;
  GtkWidget *entryalarmdesc;
  GtkWidget *entryalarmdistance;
  GtkWidget *entryalarminterval;
  GtkWidget *entryalarmlongdesc;
  GtkWidget *entryeventdate;
  GtkWidget *entryeventkm;
  GtkWidget *entryeventservice;
  GtkWidget *entryeventoil;
  GtkWidget *entryeventtires;
  GtkWidget *entryeventnotes;
  GtkWidget *eventview;
#if MAEMO_VERSION_MAJOR == 5
  GtkWidget *alarmcarbutton;
#endif

  /* Alarm secondary toolbar */
  GtkToolItem *stb_alarmdesc;
  GtkWidget *stb_alarmdesclabel;
  GtkToolItem *stb_alarmkm;
  GtkWidget *stb_alarmkmlabel;
  GtkToolItem *stb_alarmtime;
  GtkWidget *stb_alarmtimelabel;

  /* Driving log window */
  GtkWidget *logscrollwin;
  GtkWidget *logstartbutton;
  GtkWidget *logstopbutton;
  GtkWidget *logpausebutton;
  GtkWidget *logcleardistancebutton;
  GtkWidget *logview;
  GtkWidget *logcarbutton;
  GtkWidget *logcarcombo;
  GtkWidget *logdriverbutton;
  GtkWidget *logdrivercombo;
  GtkWidget *logexlanationentry;
  GtkWidget *logendplaceentry;
  GtkWidget *logstartplaceentry;
  GtkWidget *logdistanceentry;

  /* Driving log toolbar */
  GtkToolItem *stb_logdistance;
  GtkWidget *stb_logdistancelabel;

  /* Locations window */
  GtkWidget *locationsview;
  GtkWidget *locationsplacelabel;
  GtkWidget *locationslatlonlabel;
  GtkWidget *locationsaliasentry;

};

/*******************************************************************
 *
 * Public variables
 *
 *******************************************************************/

extern AppData app;
extern AppUIData ui;
extern enum fontscale fontsize;
extern gboolean main_toolbar_visible;
extern gboolean secondary_toolbar_visible;
extern gboolean maintablesorted;
extern gint maintablesortcol;
extern GtkSortType maintablesortorder;
extern gboolean carchanged;


/*******************************************************************
 *
 * Public functions
 *
 *******************************************************************/

void get_store_and_iter(GtkTreeModel *model,
			GtkWidget *view,
			GtkTreeIter *iter,
			GtkListStore **store,
			GtkTreeIter *storeiter);
gchar *interface_file_chooser (gchar *header, 
				GtkFileChooserAction action, 
				const gchar *ext,
				gchar *help_id);
GString *get_entry(GtkWidget *entry);
gboolean get_check_button(GtkWidget *check);
void update_filter_button(AppUIData *pui, gboolean active);
void update_reminder_toolbutton(AppUIData *pui, gboolean warn);
void update_driving_log_button(AppUIData *pui);
void main_toolbar_show_hide(AppUIData *pui);
void secondary_toolbar_show_hide(AppUIData *pui);
void update_car_changed(AppUIData *pui);
void update_driver_combo(gpointer combo);
#if MAEMO_VERSION_MAJOR == 5
GtkWidget *create_driver_combo(AppUIData *pui, GtkWidget *button);
#else
GtkWidget *create_driver_combo(AppUIData *pui);
#endif
void update_car_combo(gpointer widget);
#if MAEMO_VERSION_MAJOR == 5
GtkWidget *create_car_combo(AppUIData *pui, GtkWidget *button);
#else
GtkWidget *create_car_combo(AppUIData *pui);
#endif
#if MAEMO_VERSION_MAJOR == 5
GtkWidget *create_andor_combo(GtkWidget *button);
#else
GtkWidget *create_andor_combo(void);
#endif
#if MAEMO_VERSION_MAJOR == 5
GtkWidget *create_column_combo(AppUIData *pui, GtkWidget *button);
#else
GtkWidget *create_column_combo(AppUIData *pui);
#endif
void callback_editrecord( GtkAction * action, AppUIData *pui );
void callback_about( GtkAction * action, gpointer data );
#if LIBHELP == 1
void help_dialog_help_enable(GtkDialog *dialog,
			     const gchar *topic,
			     osso_context_t *osso);
void help_activated(GtkWidget *win, gchar *help_id);
void callback_help( GtkAction * action, gpointer data );

#endif
void create_mainwin_widgets(AppUIData *pui);
void ui_show_animation(GtkWidget **banner, const char *s);
void ui_show_banner(const char *s);
void ui_remove_banner(GtkWidget *banner);
gboolean ui_connection_ensure(void);
void ui_create_mainwin(void);
void ui_init(int argc, char *argv[]);
void ui_main_loop(void);

#endif
