/*
 * This file is part of fuelpad, the fuel diary
 *
 * Copyright (c) 2007-2011 Julius Luukko <julle.luukko@quicknet.inet.fi>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include <dbus/dbus.h>
#include <stdio.h>     /* printf, fprintf, stderr */
#include <stdlib.h>    /* EXIT_FAILURE, EXIT_SUCCESS */


// Just for app structure
#include "ui.h"

/*******************************************************************
 *
 * Public variables
 *
 *******************************************************************/

/*******************************************************************
 *
 * Private definitions
 *
 *******************************************************************/

#define NOKIAMAPS_NAME  "com.nokia.Navigation.NokiaMapsProvider"
#define NOKIAMAPS_OPATH "/Provider"
#define NOKIAMAPS_IFACE "com.nokia.Navigation.MapProvider"
#define NOKIAMAPS_NOTE  "ShowPlaceGeo"

/*******************************************************************
 *
 * Private enumerations
 *
 *******************************************************************/

/*******************************************************************
 *
 * Private variables
 *
 *******************************************************************/

/*******************************************************************
 *
 * Prototypes of private functions
 *
 *******************************************************************/

/*******************************************************************
 *
 * Private functions
 *
 *******************************************************************/

static
gboolean map_send_message(double lat, double lon)
{
  DBusMessage* msg = NULL;
  dbus_uint32_t unused=0;

  msg = dbus_message_new_method_call(NOKIAMAPS_NAME, /* destination */
                                     NOKIAMAPS_OPATH,  /* obj. path */
                                     NOKIAMAPS_IFACE,  /* interface */
                                     NOKIAMAPS_NOTE); /* method str */
  if (msg == NULL) {
    fprintf(stderr, "Ran out of memory when creating a message\n");
    exit(EXIT_FAILURE);
  }
  if (!dbus_message_append_args(msg,
                                DBUS_TYPE_DOUBLE, &lat,
                                DBUS_TYPE_DOUBLE, &lon,
                                DBUS_TYPE_UINT32, &unused,
                                DBUS_TYPE_INVALID)) {
    fprintf(stderr, "Ran out of memory while constructing args\n");
    exit(EXIT_FAILURE);
  }
  dbus_message_set_no_reply(msg, TRUE);
  if (!dbus_connection_send(app.session_bus, msg, NULL)) {
    fprintf(stderr, "Ran out of memory while queueing message\n");
    exit(EXIT_FAILURE);
  }
 
  dbus_connection_flush(app.session_bus);
 
  dbus_message_unref(msg);

  return TRUE;
}

/*******************************************************************
 *
 * Public functions
 *
 *******************************************************************/

void map_show_location(double lat, double lon)
{
  (void)map_send_message(lat, lon);
}
