/* 
 * This file is part of fuelpad, the fuel diary
 *
 * Copyright (c) 2007-2010 Julius Luukko <julle.luukko@quicknet.inet.fi>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef _GPSUTIL_H_
#define _GPSUTIL_H_

#include <gtk/gtk.h>
#include "ui.h"


/*******************************************************************
 *
 * Public variables
 *
 *******************************************************************/

extern LocationGPSDControl *control;
extern LocationGPSDevice *device;
extern volatile double distance;

/*******************************************************************
 *
 * Public functions
 *
 *******************************************************************/

void gps_init_location(AppUIData *pui);
void gps_stop_location(void);
gboolean gps_get_logging(void);
void gps_set_logging(gboolean set);

#endif
