/* 
 * This file is part of fuelpad, the fuel diary
 *
 * Copyright (c) 2007-2010 Julius Luukko <julle.luukko@quicknet.inet.fi>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef _CSVFUNC_H_
#define _CSVFUNC_H_

/*******************************************************************
 *
 * Public type definitions
 *
 *******************************************************************/

typedef struct _csvlistnode {
  void *data;
  struct _csvlistnode *next;
  struct _csvlistnode *prev;
} csvlistnode;

typedef struct {
  csvlistnode *head;
  csvlistnode *tail;
  int       nodes;
} csvlist;

/*******************************************************************
 *
 * Public functions
 *
 *******************************************************************/

void csvremoverow(csvlist *plist, csvlistnode *prow);
void csvinit(csvlist *plist);
void csvfree(csvlist *rowlist);
int csvparse(char *line, csvlist *rowlist, int *rows, int *cols);
csvlist *csvgetrow(csvlist *rowlist, int row);
csvlistnode *csvgetrowcol(csvlist *rowlist, int row, int col);

#endif
