#include <QtGui>
#include <QAction>
#include <QWidget>
#include <QPushButton>

#include "window.h"


Window::Window()
     : QMainWindow()
{
	QString sufix = "*.oki";
	QString filename = QFileDialog::getSaveFileName(this, "Save file", "", sufix);
}

class BlankWidget : public QWidget
{
    public:
        BlankWidget(char mode){
            //QVBoxLayout *vbox = new QVBoxLayout;
            //setLayout( vbox );
            setAutoFillBackground( true );
            if(mode == 'h') {
        		setFixedHeight(7);
        		setStyleSheet("* { background-image: url(:/hline.png) }");
            }
            else {
        		setFixedWidth(7);
        		setStyleSheet("* { background-image: url(:/vline.png) }");
            }
            //setStyleSheet( "background-color: white;" );
        }
};

Main::Main() : QMainWindow() {
	fSudo = new fSudoku;
	vLevel = 45;
	setAttribute(Qt::WA_Maemo5StackedWindow);
		QResource::registerResource("/scratchbox/users/figa/home/figa/workspace/fsudoku/src/resources.rcc");
		master = new QWidget();
        master->setAttribute(Qt::WA_Maemo5StackedWindow);
		slave = new QWidget(master);
		slave->setAttribute(Qt::WA_Maemo5StackedWindow);
		slave->setWindowFlags(slave->windowFlags() | Qt::Window);
		//neni spustena hra
		running = false;

		setWindowTitle(tr("fSudoku::Menu"));
		master->setWindowTitle(tr("fSudoku::Menu"));
		QLabel * logo= new QLabel(this);
		logo->setPixmap(QPixmap(":/logo.png"));
		QPushButton * newGame = new QPushButton(tr("New Game"));
		QPushButton * continueGame = new QPushButton(tr("Continue"));
		QPushButton * customGame = new QPushButton(tr("Custom"));
		QGridLayout * menu = new QGridLayout();
		level = new QComboBox();
		level->addItem("Easy");
		level->addItem("Normal");
		level->addItem("Hard");
		level->addItem("Extreme");
		menu->addWidget(logo,0,0,1,2,Qt::AlignCenter);
		menu->addWidget(newGame,1,0);
		menu->addWidget(level,1,1);
		menu->addWidget(continueGame,2,0);
		menu->addWidget(customGame,2,1);
		master->setLayout(menu);
		connect(newGame, SIGNAL(clicked()), this, SLOT(newGame()));
		level->connect(level, SIGNAL(currentIndexChanged(int)), this, SLOT(setLevel()));
		connect(continueGame, SIGNAL(clicked()), this, SLOT(loadGame()));
		connect(customGame, SIGNAL(clicked()), this, SLOT(customGame()));

		fSudo->timeTimer = 0;
		timer = new QTimer(this);
		connect(timer, SIGNAL(timeout()), this, SLOT(updateTimer()));
		mainLayout = new QHBoxLayout();
		QHBoxLayout *unfilledCounter = new QHBoxLayout;
		QVBoxLayout *leftLayout = new QVBoxLayout;
		timeLabel = new QLabel("0");
		QLabel *unfilledCounterText = new QLabel(tr("Left:"));

		QAction *save = new QAction(tr("Save To File"), this);
		QAction *load = new QAction(tr("Load From File"), this);

		QMenu *appMenu;
		appMenu = menuBar()->addMenu(tr("Advanced"));
		appMenu->addAction(save);
		appMenu->addAction(load);

		connect(save, SIGNAL(triggered()), this , SLOT(saveToFile()));
		connect(load, SIGNAL(triggered()), this , SLOT(loadCustomGame()));

		//set fonts [INIT]
		defaultFont = timeLabel->font();
		candidateFont.setPointSize(defaultFont.pointSize()/2);
		signalMapperGrid = new QSignalMapper(this);
		grid = new QGridLayout();
		grid->setSpacing(0);
		for(int x =0;x<9;x++) {
			for(int y = 0;y<9;y++) {
				elements[x][y] = new QPushButton(tr(""), this);
				if(x<3) {
					if(y<3) {
						grid->addWidget(elements[x][y], x+1, y+1);
					}
					else if(y<6) {
						grid->addWidget(elements[x][y], x+1, y+2);
					}
					else {
						grid->addWidget(elements[x][y], x+1, y+3);
					}
				}
				else if(x<6){
					if(y<3) {
						grid->addWidget(elements[x][y], x+2, y+1);
					}
					else if(y<6) {
						grid->addWidget(elements[x][y], x+2, y+2);
					}
					else {
						grid->addWidget(elements[x][y], x+2, y+3);
					}
				}
				else {
					if(y<3) {
						grid->addWidget(elements[x][y], x+3, y+1);
					}
					else if(y<6) {
						grid->addWidget(elements[x][y], x+3, y+2);
					}
					else {
						grid->addWidget(elements[x][y], x+3, y+3);
					}
				}
			}
		}

		BlankWidget *hspacer[22];
		BlankWidget *vspacer[22];
		for(int x =0;x<22;++x) {
			hspacer[x] = new BlankWidget('h');
			vspacer[x] = new BlankWidget('v');
		};
		grid->addWidget( hspacer[0], 4, 1 );
		grid->addWidget( hspacer[1], 4, 2 );
		grid->addWidget( hspacer[2], 4, 3 );
		grid->addWidget( hspacer[3], 4, 4 );
		grid->addWidget( hspacer[4], 4, 5 );
		grid->addWidget( hspacer[5], 4, 6 );
		grid->addWidget( hspacer[6], 4, 7 );
		grid->addWidget( hspacer[7], 4, 8 );
		grid->addWidget( hspacer[8], 4, 9 );
		grid->addWidget( hspacer[9], 4, 10 );
		grid->addWidget( hspacer[10], 4, 11 );
		grid->addWidget( hspacer[11], 8, 1 );
		grid->addWidget( hspacer[12], 8, 2 );
		grid->addWidget( hspacer[13], 8, 3 );
		grid->addWidget( hspacer[14], 8, 4 );
		grid->addWidget( hspacer[15], 8, 5 );
		grid->addWidget( hspacer[16], 8, 6 );
		grid->addWidget( hspacer[17], 8, 7 );
		grid->addWidget( hspacer[18], 8, 8 );
		grid->addWidget( hspacer[19], 8, 9 );
		grid->addWidget( hspacer[20], 8, 10 );
		grid->addWidget( hspacer[21], 8, 11 );
		//vspacers
		grid->addWidget( vspacer[0], 1, 4 );
		grid->addWidget( vspacer[1], 2, 4 );
		grid->addWidget( vspacer[2], 3, 4 );
		grid->addWidget( vspacer[3], 4, 4 );
		grid->addWidget( vspacer[4], 5, 4 );
		grid->addWidget( vspacer[5], 6, 4 );
		grid->addWidget( vspacer[6], 7, 4 );
		grid->addWidget( vspacer[7], 8, 4 );
		grid->addWidget( vspacer[8], 9, 4 );
		grid->addWidget( vspacer[9], 10, 4 );
		grid->addWidget( vspacer[10], 11, 4 );
		grid->addWidget( vspacer[11], 1, 8 );
		grid->addWidget( vspacer[12], 2, 8 );
		grid->addWidget( vspacer[13], 3, 8 );
		grid->addWidget( vspacer[14], 4, 8 );
		grid->addWidget( vspacer[15], 5, 8 );
		grid->addWidget( vspacer[16], 6, 8 );
		grid->addWidget( vspacer[17], 7, 8 );
		grid->addWidget( vspacer[18], 8, 8 );
		grid->addWidget( vspacer[19], 9, 8 );
		grid->addWidget( vspacer[20], 10, 8 );
		grid->addWidget( vspacer[21], 11, 8 );

		defaultStyle = elements[0][0]->styleSheet();

		slave->setWindowTitle(tr("fSudoku::Game"));

		xy = new QLabel();
		sprintf(cacheCharSmall,"%i",fSudo->unfilled);
		unfilledCounterLabel = new QLabel(cacheCharSmall);
		unfilledCounter->addWidget(unfilledCounterText);
		unfilledCounter->addWidget(unfilledCounterLabel);
		leftLayout->addWidget(timeLabel);
		leftLayout->addWidget(xy);
		leftLayout->addLayout(unfilledCounter);
		mainLayout->addLayout(leftLayout);
		mainLayout->addLayout(grid);
		setControl();
		slave->setLayout(mainLayout);
		slave->setFixedSize(800,480);
		master->show();
		setCentralWidget(master);
}

void Main::init() {
	delete fSudo;
	fSudo = new fSudoku;
	//cyklus jen do osmi 9 chybi
	control[9]->setEnabled(true);
	candidateButton->setEnabled(true);
	solveButton->setEnabled(true);
	undoButton->setEnabled(true);
	redoButton->setEnabled(true);
	for(int x=0;x<9;x++) {
		control[x]->setEnabled(TRUE);
		for(int y=0;y<9;y++) {
			elements[x][y]->setEnabled(TRUE);
			elements[x][y]->setText("");
			elements[x][y]->setFont(defaultFont);
			elements[x][y]->setChecked(false);
			elements[x][y]->setStyleSheet(defaultStyle);
		}
	}

}

void Main::setGameField(int mode) {
	init();
	if(mode==0) {
		fSudo->newSudoku(vLevel);
		fSudo->save();
		fSudo->game=true;
	}
	else if (mode==1) {
		fSudo->game=true;
		fSudo->load();
	}
	else {

	}
	for(int x=0;x<9;x++) {
		for(int y=0;y<9;y++) {
			char buffer[2];
			sprintf(buffer,"%i",fSudo->unsolved[x][y]);
			if(buffer[0]=='0' || mode==2) {
				if(fSudo->candidates[x][y][0]=='0') {
					elements[x][y]->setText("");
					fSudo->unsolved[x][y]=0;
					fSudo->base[x][y]=0;
				}
				else {
					//candidates
					elements[x][y]->setText(fSudo->candidates[x][y].c_str());
					elements[x][y]->setFont(candidateFont);
				}
				elements[x][y]->setFixedSize(43,43);
			}
			else {
				elements[x][y]->setText(tr(buffer));
				if(fSudo->unsolved[x][y] == fSudo->base[x][y]) {
					elements[x][y]->setEnabled(false);
				}
				else {
	   				if(!fSudo->isValid(x,y)) {
	   					elements[x][y]->setStyleSheet("* { color: #ff0000 }");
	   				}
				}
				elements[x][y]->setFixedSize(43,43);
				--fSudo->unfilled;
			}
			elements[x][y]->setCheckable(true);
			connect(elements[x][y], SIGNAL(clicked()), signalMapperGrid, SLOT(map()));
			signalMapperGrid->setMapping(elements[x][y], elements[x][y]);
		}
	}
	//set undo and redo deactivated
	undoButton->setEnabled(false);
	redoButton->setEnabled(false);
	//update unfilled counter
	sprintf(cacheCharSmall,"%i",fSudo->unfilled);
	unfilledCounterLabel->setText(cacheCharSmall);
	connect(signalMapperGrid, SIGNAL(mapped(QWidget*)),this, SLOT(oneChecked(QWidget*)));
	timer->start(1000);
}

void Main::setControl() {
	signalMapper = new QSignalMapper(this);
	touchControl = new QGridLayout();
	undoButton = new QPushButton(this);
	undoButton->setIcon(QIcon(":/undo.png"));
	redoButton = new QPushButton(this);
	redoButton->setIcon(QIcon(":/redo.png"));
	solveButton = new QPushButton(this);
	solveButton->setIcon(QIcon(":/solve.png"));
	candidateButton = new QPushButton(this);
	candidateButton->setIcon(QIcon(":/candidate.png"));
	candidateButton->setCheckable(true);
	touchControl->setSpacing(0);
	//slots
	connect(undoButton, SIGNAL(clicked()), this, SLOT(undo()));
	connect(redoButton, SIGNAL(clicked()), this, SLOT(redo()));
	connect(solveButton, SIGNAL(clicked()), this, SLOT(solve()));
	connect(candidateButton, SIGNAL(clicked()), this, SLOT(addCandidate()));
	for(int i=0; i<10; i++) {
				char buffer[2];
				sprintf(buffer,"%i",i);
				control[i] = new QPushButton(tr(buffer), this);
				connect(control[i], SIGNAL(clicked()), signalMapper, SLOT(map()));
				signalMapper->setMapping(control[i], i);
				if(i==0) {
					touchControl->addWidget(control[i],0,0);
				}
				else if(i==1) {
					touchControl->addWidget(control[i],0,1);
				}
				else if(i==2) {
					touchControl->addWidget(control[i],1,0);
				}
				else if(i==3){
					touchControl->addWidget(control[i],1,1);;
				}
				else if(i==4) {
					touchControl->addWidget(control[i],2,0);
				}
				else if(i==5) {
					touchControl->addWidget(control[i],2,1);
				}
				else if(i==6) {
					touchControl->addWidget(control[i],3,0);
				}
				else if(i==7) {
					touchControl->addWidget(control[i],3,1);
				}
				else if(i==8){
					touchControl->addWidget(control[i],4,0);;
				}
				else {
					touchControl->addWidget(control[i],4,1);
				}
			}

			connect(signalMapper, SIGNAL(mapped(int)),this, SLOT(setElement(int)));
			control[0]->setIcon(QIcon(":/del.png"));
			control[0]->setText("");
			touchControl->addWidget(candidateButton,5,0);
			touchControl->addWidget(solveButton,5,1);
			touchControl->addWidget(undoButton,6,0);
			touchControl->addWidget(redoButton,6,1);
			mainLayout->addLayout(touchControl);
}

void Main::newGame() {
	setGameField(0);
	slave->show();
}

void Main::setLevel() {
	if(level->currentIndex()==0) {
		vLevel=45;
	}
	else if (level->currentIndex()==1) {
		vLevel=35;
	}
	else if(level->currentIndex()==2) {
		vLevel=30;
	}
	else {
		vLevel=25;
	}
}

void Main::loadGame() {
	setGameField(1);
	slave->show();
}

void Main::customGame() {
	setGameField(2);
	slave->show();
}

void Main::loadCustomGame() {
	 QString fileName;
	 fileName = QFileDialog::getOpenFileName(this,tr("Open File"), "/home/MyDocs", tr("Text files (*.fsu)"));
	 if(!fileName.isEmpty()) {
		 FILE * stream = fopen( fileName.toStdString().c_str(), "r" );
		 fseek( stream, 0, SEEK_END );
		 long endPos = ftell( stream );
		 fclose( stream );
		 //new sudoku from file
		 if(endPos<250) {
			 if(endPos!=81) {
				//set Message box
				QMessageBox msgBox;
				msgBox.setWindowTitle(tr("Error"));
				msgBox.setText("This is not valid .fsu file!");
				msgBox.exec();
			 }
			 //valid fsu file
			 else {
				 char loadUnsolved[81];
				 FILE * file;
				 file = fopen ( fileName.toStdString().c_str() , "r" );
				 //load unsolved string
				 fread (loadUnsolved,1,81,file);
				 int i = 0;
				 for(int x=0;x<9;x++) {
					 for(int y=0;y<9;y++) {
						 char buffer[2];
						 sprintf(buffer,"%c",loadUnsolved[i]);
						 buffer[1]='\0';
						 int value = atoi(buffer);
						 fSudo->unsolved[x][y] = value;
						 fSudo->base[x][y] = value;
						 i++;
					 }
				 }
				 fclose (file);
				 fSudo->save();
			 }
		 }
		 //saved sudoku
		 else {
			ifstream ifs(fileName.toStdString().c_str(), ios::binary);
			ofstream ofs("save.txt", ios::binary);
			ofs << ifs.rdbuf();
		 }
		 loadGame();
	 }
}

void Main::saveToFile() {
	QString sufix = "*.fsu";
	QString filename = QFileDialog::getSaveFileName(this, "Save file", "", sufix);
	//byl vybran soubor
	if(!filename.isEmpty()) {
		ifstream ifs("save.txt", ios::binary);
		ofstream ofs(filename.toStdString().c_str(), ios::binary);
		ofs << ifs.rdbuf();
		string newName = filename.toStdString() + ".fsu";
		rename( filename.toStdString().c_str() , newName.c_str());
		FILE* fp = fopen(newName.c_str(), "r");
		if(fp) {
			fclose(fp);
			QMessageBox *msgBox = new QMessageBox();
			msgBox->setWindowTitle(tr("Succesfully Saved"));
			msgBox->setText("Your sudoku game was save.");
			msgBox->exec();
		}
		else {
			fclose(fp);
			QMessageBox *msgBox = new QMessageBox();
			msgBox->setWindowTitle(tr("Error"));
			msgBox->setText("Your sudoku game was not save!");
			msgBox->exec();
		}
	}

}

void Main::setElement(int value) {
	bool changed = 0;
	char buffer[2];
    for(int x=0;x<9;x++) {
    	for(int y=0;y<9;y++) {
    		if(elements[x][y]->isChecked()) {
    			saveUndo(x,y,fSudo->unsolved[x][y],elements[x][y]->styleSheet(), elements[x][y]->font(), fSudo->candidates[x][y], fSudo->unfilled);
    			//add value to grid
    			if(!candidateButton->isChecked()) {
    				elements[x][y]->setStyleSheet("* { color: #ffffff }");
					changed = true;
					sprintf(buffer,"%i",value);
					if(buffer[0]=='0') {
						elements[x][y]->setText("");
						if(fSudo->unsolved[x][y] != 0){fSudo->unfilled++;}//only after change
						fSudo->unsolved[x][y]=value;
						fSudo->candidates[x][y]='0';
					}
					else {
						elements[x][y]->setText(buffer);
						if(fSudo->unsolved[x][y]==0) {fSudo->unfilled--;}
						fSudo->unsolved[x][y]=value;
						//kontrola validity
		   				if(!fSudo->isValid(x,y)) {
		   					elements[x][y]->setStyleSheet("* { color: #ff0000 }");
		   				}
					}
				elements[x][y]->setFont(defaultFont);
    			sprintf(cacheCharSmall,"%i",fSudo->unfilled);
    			unfilledCounterLabel->setText(cacheCharSmall);
    		}
    		//add candidate to grid
    		else {
    			if(value!=0) {
    				changed = true;
    				elements[x][y]->setFont(candidateFont);
					QString  origin;
					QString newStr;
					origin = elements[x][y]->text();
					newStr.setNum(value);
					candidateButton->setChecked(FALSE);
					origin.operator +=(newStr);
					elements[x][y]->setText(origin);
					//save candidates to string
					fSudo->candidates[x][y] = origin.toStdString();
    			}
    			}
    			break;
    		}
    	}
    }
    //available if was changed value
    if(changed) {
		redoButton->setEnabled(FALSE);
		undoButton->setEnabled(TRUE);
	}
    fSudo->save();
}

void Main::oneChecked(QWidget* element) {
	QPushButton *bt = qobject_cast<QPushButton *>( element );
	Q_ASSERT( bt );
	for(int x=0;x<9;x++) {
	    for(int y=0;y<9;y++) {
	    	if(elements[x][y] != bt) {
	    		elements[x][y]->setChecked(FALSE);
			}
	    }
	}
}

void Main::addCandidate() {

}

void Main::saveUndo(int x, int y, char value, QString color, QFont font, string candidates, int unfilled) {
	fSudo->undo->x = x;
	fSudo->undo->y = y;
	fSudo->undo->value[0] = value;
	fSudo->undo->value[1] = '\0';
	fSudo->undo->color = color;
	fSudo->undo->font = font;
	fSudo->undo->candidates = candidates;
	fSudo->undo->unfilled = unfilled;
}

void Main::saveRedo(int x, int y, char value, QString color, QFont font, string candidates, int unfilled) {
	fSudo->redo->x = x;
	fSudo->redo->y = y;
	fSudo->redo->value[0] = value;
	fSudo->redo->value[1] = '\0';
	fSudo->redo->color = color;
	fSudo->redo->font = font;
	fSudo->redo->candidates = candidates;
	fSudo->redo->unfilled = unfilled;
}

void Main::undo() {
	saveRedo(fSudo->undo->x, fSudo->undo->y,fSudo->unsolved[fSudo->undo->x][fSudo->undo->y],elements[fSudo->undo->x][fSudo->undo->y]->styleSheet(), elements[fSudo->undo->x][fSudo->undo->y]->font(), fSudo->candidates[fSudo->undo->x][fSudo->undo->y], fSudo->unfilled);
	if(fSudo->undo->value[0] == 0) {
		//ukladam kandidaty
		if(fSudo->undo->candidates[0] != '0') {
			QString newStr;
			int value = atoi(fSudo->undo->candidates.c_str());
			newStr.setNum(value);
			elements[fSudo->undo->x][fSudo->undo->y]->setText(newStr);
			fSudo->candidates[fSudo->undo->x][fSudo->undo->y] = fSudo->undo->candidates;
		}
		//nastavuji hodnotu nula kandidat je take nula
		else {
			fSudo->unsolved[fSudo->undo->x][fSudo->undo->y] = '0';
			elements[fSudo->undo->x][fSudo->undo->y]->setText("");
		}
	}
	//hodnota neni nulova
	else {
		char buffer[2];
		sprintf(buffer,"%i",fSudo->undo->value[0]);
		fSudo->unsolved[fSudo->undo->x][fSudo->undo->y] = fSudo->undo->value[0];
		elements[fSudo->undo->x][fSudo->undo->y]->setText(buffer);
	}
	elements[fSudo->undo->x][fSudo->undo->y]->setStyleSheet(fSudo->undo->color);
	elements[fSudo->undo->x][fSudo->undo->y]->setFont(fSudo->undo->font);
	sprintf(cacheCharSmall,"%i",fSudo->undo->unfilled);
	unfilledCounterLabel->setText(cacheCharSmall);
    redoButton->setEnabled(TRUE);
    undoButton->setEnabled(FALSE);

    //vynulovani struktury
   fSudo->nullUndo();
}

void Main::redo() {
	saveUndo(fSudo->redo->x, fSudo->redo->y,fSudo->unsolved[fSudo->redo->x][fSudo->redo->y],elements[fSudo->redo->x][fSudo->redo->y]->styleSheet(), elements[fSudo->redo->x][fSudo->redo->y]->font(), fSudo->candidates[fSudo->redo->x][fSudo->redo->y], fSudo->unfilled);
	if(fSudo->redo->value[0] == 0) {
		if(fSudo->redo->candidates[0] != '0') {
			QString newStr;
			int value = atoi(fSudo->redo->candidates.c_str());
			newStr.setNum(value);
			elements[fSudo->redo->x][fSudo->redo->y]->setText(newStr);
			fSudo->candidates[fSudo->redo->x][fSudo->redo->y] = fSudo->redo->candidates;
		}
		else {
			fSudo->unsolved[fSudo->redo->x][fSudo->redo->y] = '0';
			elements[fSudo->redo->x][fSudo->redo->y]->setText("");
		}
	}
	else {
		char buffer[2];
		sprintf(buffer,"%i",fSudo->redo->value[0]);
		fSudo->unsolved[fSudo->redo->x][fSudo->redo->y] = fSudo->redo->value[0];
		elements[fSudo->redo->x][fSudo->redo->y]->setText(buffer);
	}
	elements[fSudo->redo->x][fSudo->redo->y]->setStyleSheet(fSudo->redo->color);
	elements[fSudo->redo->x][fSudo->redo->y]->setFont(fSudo->redo->font);
	sprintf(cacheCharSmall,"%i",fSudo->redo->unfilled);
	unfilledCounterLabel->setText(cacheCharSmall);
    redoButton->setEnabled(FALSE);
    undoButton->setEnabled(TRUE);
    //vynulovani struktury
    fSudo->nullRedo();
}

void Main::solve() {
	//set Message box
	 QMessageBox msgBox;
	 msgBox.setWindowTitle(tr("Solve Game"));
	 msgBox.setText("Do you want solve this game?");
	 msgBox.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
	 msgBox.setDefaultButton(QMessageBox::Save);
	 int ret = msgBox.exec();
	 // if yes solve game
	 switch (ret) {
	   case QMessageBox::Yes:
		   if(fSudo->unfilled<65) {
			   fSudo->solve();
			   char buffer[2];
			   for(int x=0;x<9;x++) {
				   for(int y=0;y<9;y++) {
					   sprintf(buffer,"%i",fSudo->solved[x][y]);
					   if(fSudo->unsolved[x][y] == fSudo->solved[x][y] && elements[x][y]->isEnabled()) {
						   elements[x][y]->setStyleSheet("* { color: #00ff00 }");
						   fSudo->unsolved[x][y]=fSudo->solved[x][y];
						   elements[x][y]->setText(buffer);
					   }
					   if(fSudo->unsolved[x][y] != fSudo->solved[x][y] && elements[x][y]->isEnabled()) {
						   elements[x][y]->setStyleSheet("* { color: #ff0000 }");
						   fSudo->unsolved[x][y]=fSudo->solved[x][y];
						   elements[x][y]->setText(buffer);
					   }
				   }
			   }
		       //stop timeTmer
		       timer->stop();
		       //set control non-active
		       for(int i = 0; i<10; i++) {
		    	   control[i]->setEnabled(FALSE);
		       }
		       //set unfilled to zero
		       fSudo->unfilled = 0;
		       unfilledCounterLabel->setText("0");
		       undoButton->setEnabled(FALSE);
		       redoButton->setEnabled(FALSE);
		       solveButton->setEnabled(FALSE);
		       candidateButton->setEnabled(FALSE);
		   }
		   else {
			   QMessageBox::information(this, tr("Solve Game"), tr("I can't solve this game. You must fill minimal 17 elements!"));
		   }
	       break;
	   default:
	       break;
	 }
}

void Main::updateTimer()
{
	fSudo->timeTimer++;
		double result=fSudo->timeTimer/60;
		double hour;
		double min;
		double sec;
		if(result<1) {
			hour = 0;
			sec = fSudo->timeTimer;
			min = 0;
		}
		else if (result < 60) {
			hour = 0;
			min = floor(result);
			sec = (fSudo->timeTimer-(min*60));
		}
		else {
			hour = floor(result/60);
			min = floor(result-(hour*60));
			sec = (fSudo->timeTimer-(min*60)-(hour*60*60));
		}
		ostringstream s1;
		if((int)sec<10) {
			if(min<10) {
				s1 << hour << ":" << "0" << min << ":" << "0" << sec;
			}
			else {
				s1 << hour << ":" << min << ":" << "0" << sec;
			}
		}
		else {
			if(min<10) {
				s1 << hour << ":" << "0" << min << ":" << sec;
			}
			else {
				s1 << hour << ":" << min << ":" << sec;
			}
		}
		char text[20];
		strcpy (text,s1.str().c_str());
		timeLabel->setText(text);
}

fSudoku::fSudoku() {
	a = new sudoku;
	game = false;
	unfilled = 81;
	timeTimer = 0;
	for(int x=0;x<9;x++) {
		for(int y=0;y<9;y++) {
			candidates[x][y] = '0';
		}
	}
	undo = new step;
	redo = new step;
}

void fSudoku::init() {

}

void fSudoku::newSudoku(int level) {
	a->random_generate(level);
	memcpy(unsolved,a->data,sizeof(a->data));
	memcpy(base,a->data,sizeof(a->data));
	delete a;
}

void fSudoku::save() {
	FILE *file = fopen("save.txt","w");
	//save unsolved
	for (int x = 0; x < 9; x++) {
		for (int y = 0; y < 9; y++) {
			fprintf(file,"%c",unsolved[x][y]);
		}
	}
	//save base
	for (int x = 0; x < 9; x++) {
		for (int y = 0; y < 9; y++) {
			fprintf(file,"%c",base[x][y]);
		}
	}
	//save time
	char time[7];
	sprintf(time,"%d",timeTimer);
	int leftZero = 6-strlen(time);
	string fTime;
	if(leftZero>0) {
		for(int i = 0;i<leftZero;i++) {
			fTime += "0";
		}
		fTime += time;
	}
	fprintf(file,"%s",fTime.c_str());
	//save candidates
	char buffer[11];
	string str;
	for (int x = 0; x < 9; x++) {
		for (int y = 0; y < 9; y++) {
			str = candidates[x][y]+';';
			strcpy(buffer,str.c_str());
			fprintf(file,"%s",buffer);
		}
	}
	fclose(file);

}

void fSudoku::load() {
	char loadUnsolved[81];
	char loadBase[81];
	char loadTime[7];

	char *buffer = new char[811];
	char *final = NULL;
	FILE * file;
	file = fopen ( "save.txt" , "r" );
	//load unsolved string
	fread (loadUnsolved,1,81,file);
	//load base string
	fread (loadBase,1,81,file);
	//load time
	fread (loadTime,1,6,file);
	timeTimer = atoi(loadTime);
	//laod candidates
	fread (buffer,1,810,file);
	final = strtok (buffer, ";");
	int x=0;
	int y=0;
	while( final != NULL ) {
		string str(final);
		candidates[x][y]=str;
	    final = strtok( NULL, ";" );
	    y++;
	    if(y >= 9) {
	          x++;
	          if (x >= 9) break;
	          y = 0;
	    }
	}
	memcpy(unsolved,loadUnsolved,sizeof(loadUnsolved));
	memcpy(base,loadBase,sizeof(loadBase));
	fclose (file);
	delete [] buffer;
}

void fSudoku::solve() {
	a = new sudoku;
	for(int x = 0;x<9;x++) {
		for(int y = 0;y<9;y++) {
			if(game) {
				if(base[x][y]!=0) {
					a->set_item(base[x][y],x,y);
				}
			}
			else {
				if(unsolved[x][y]!=0) {
					a->set_item(unsolved[x][y],x,y);
				}
			}
		}
	}
	a->solve();
	memcpy(solved,a->data,sizeof(a->data));
}

bool fSudoku::isValid(int x, int y) {
	bool valid = true;
	int n =0;
	int m = 0;
	if(x<3 && y<3) {
		for(n=0;n<3;n++) {
			for(m=0;m<3;m++) {
				if(unsolved[x][y]==unsolved[n][m] && x!=n && y!=m) {
					valid = false;
					if(!valid){break;}
				}
			}
		}
	}
	else if(x<3 && y<6) {
		for(n=0;n<3;n++) {
			for(m=3;m<6;m++) {
				if(unsolved[x][y]==unsolved[n][m] && x!=n && y!=m) {
					valid = false;
					if(!valid){break;}
				}
			}
		}
	}
	else if(x<3 && y<9) {
		for(n=0;n<3;n++) {
			for(m=6;m<9;m++) {
				if(unsolved[x][y]==unsolved[n][m] && x!=n && y!=m) {
					valid = false;
					if(!valid){break;}
				}
			}
			if(!valid){break;}
		}
	}
	else if(x<6 && y<3) {
		for(n=3;n<6;n++) {
			for(m=0;m<3;m++) {
				if(unsolved[x][y]==unsolved[n][m] && x!=n && y!=m) {
					valid = false;
					if(!valid){break;}
				}
			}
			if(!valid){break;}
		}
	}
	else if(x<6 && y<6) {
		for(n=3;n<6;n++) {
			for(m=3;m<6;m++) {
				if(unsolved[x][y]==unsolved[n][m] && x!=n && y!=m) {
					valid = false;
					if(!valid){break;}
				}
			}
			if(!valid){break;}
		}
	}
	else if(x<6 && y<9) {
		for(n=3;n<6;n++) {
			for(m=6;m<9;m++) {
				if(unsolved[x][y]==unsolved[n][m] && x!=n && y!=m) {
					valid = false;
					if(!valid){break;}
				}
			}
			if(!valid){break;}
		}
	}
	else if(x<9 && y<3) {
		for(n=6;n<9;n++) {
			for(m=0;m<3;m++) {
				if(unsolved[x][y]==unsolved[n][m] && x!=n && y!=m) {
					valid = false;
					if(!valid){break;}
				}
			}
			if(!valid){break;}
		}
	}
	else if(x<9 && y<6) {
		for(n=6;n<9;n++) {
			for(m=3;m<6;m++) {
				if(unsolved[x][y]==unsolved[n][m] && x!=n && y!=m) {
					valid = false;
					if(!valid){break;}
				}
			}
			if(!valid){break;}
		}
	}
	else {
		for(n=6;n<9;n++) {
			for(m=6;m<9;m++) {
				if(unsolved[x][y]==unsolved[n][m] && x!=n && y!=m) {
					valid = false;
					if(!valid){break;}
				}
			}
			if(!valid){break;}
		}
	}

	for(n=0;n<9;n++) {
		if(unsolved[x][y]==unsolved[x][n] && y != n) {
			valid = false;
			if(!valid){break;}
		}
		if(unsolved[x][y]==unsolved[n][y] && x != n) {
			valid = false;
			if(!valid){break;}
		}

	}
	return valid;
}

void fSudoku::nullUndo() {
	delete undo;
	undo = new step;

}

void fSudoku::nullRedo() {
	delete redo;
	redo = new step;

}
