#!/usr/bin/python2.5
import gobject
import pygst
pygst.require("0.10")
import gst
import pygtk
import gtk
import hildon
import time
gtk.gdk.threads_init()

class CameraApp:
    def __init__(self):
        self.window = gtk.Window()
        self.viewer = gtk.DrawingArea()
        self.viewer.set_size_request(640,480)
        self.viewer.modify_bg(gtk.STATE_NORMAL, self.viewer.style.black)
        capture_button = gtk.Button("capture")
        capture_button.connect("clicked", self.onCapture)
        buttonBox = gtk.VBox(False)
        content = gtk.HBox(False)
        content.pack_start(self.viewer, False, False, 0)
        buttonBox.pack_start(capture_button, False, False, 0)
        align = gtk.Alignment(0.5, 0.5, 0.0, 0.0)
        align.add(buttonBox)
        content.pack_start(align, True, True, 0)
        self.createPipeline()
        bus = self.pipeline.get_bus()
        bus.set_sync_handler(self.bus_handler)
        self.window.connect("destroy", self.destroyWindow)
        self.window.connect("map-event", self.mapWindow)
        self.window.add(content)
        self.window.show_all()

    def createPipeline(self):
        self.pipeline = gst.Pipeline()
        self.output_selector = gst.element_factory_make("output-selector")
        self.viewfinder = gst.element_factory_make("xvimagesink")
        self.filesink = gst.element_factory_make("filesink")
        csp = gst.element_factory_make("ffmpegcolorspace")
        csp2 = gst.element_factory_make("ffmpegcolorspace")
        queue = gst.element_factory_make("queue")
        image_enc = gst.element_factory_make("jpegenc")
        self.videosrc = gst.element_factory_make("v4l2camsrc")
        self.pipeline.add(self.videosrc, self.viewfinder, self.output_selector, csp, csp2, queue, image_enc, self.filesink)
        self.videosrc.link(self.output_selector)
        csp.link(self.viewfinder)
        csp2.link(queue)
        queue.link(image_enc)
        image_enc.link(self.filesink)
        queue.set_property("max-size-buffers", 0)
        queue.set_property("max-size-bytes", 0)
        queue.set_property("max-size-time", 0)

        self.pad_src_img = self.output_selector.get_request_pad("src%d")
        self.pad_src_view = self.output_selector.get_request_pad("src%d")
        self.pad_src_view.link(csp.get_pad("sink"))
        self.pad_src_img.link(csp2.get_pad("sink"))
        self.output_selector.set_property("active-pad", self.pad_src_view)
        self.videosrc.set_property("driver-name", "omap3cam")
        self.videosrc.set_property("device", "/dev/video1")
        self.viewfinder.set_property("async", False)
        self.filesink.set_property("async", False)
        self.filesink.set_property("location", "/dev/null")
        self.pipeline.set_state(gst.STATE_PLAYING)

    def mapWindow(self, widget, event):
        print "nothing"

    def destroyWindow(self, widget, data=None):
        self.pipeline.set_state(gst.STATE_NULL)
        gtk.main_quit()

    def onCapture(self, widget):
        self.pipeline.set_state(gst.STATE_READY)
        self.filesink.set_state(gst.STATE_NULL)
        filename = "/home/user/MyDocs/DCIM/" + time.strftime('%Y%m%d_%H%M%S') + ".jpg"
        self.filesink.set_property("location", filename)
        self.videosrc.set_property("num-buffers", 1)
        self.output_selector.set_property("active-pad", self.pad_src_img)
        self.pipeline.set_state(gst.STATE_PLAYING)

    def bus_handler(self, bus, message):
        if message.type == gst.MESSAGE_ELEMENT:
            if message.structure.get_name() == 'prepare-xwindow-id':
                print "set xid" 
                self.set_xid()

        if message.type == gst.MESSAGE_EOS:
            gobject.idle_add(self.switch_to_viewfinder)
        
        return gst.BUS_PASS
    def switch_to_viewfinder(self):
        self.pipeline.set_state(gst.STATE_READY)
        self.output_selector.set_property("active-pad", self.pad_src_view)
        self.videosrc.set_property("num-buffers", -1)
        self.pipeline.set_state(gst.STATE_PLAYING)

    def set_xid(self):
        gtk.gdk.threads_enter()
        self.viewfinder.set_xwindow_id(self.viewer.window.xid)
        gtk.gdk.threads_leave()

def main():
    start = CameraApp()
    gtk.main()

if __name__ == '__main__':
 main()

