/****************************************************************************
**
**    Friendly FM - The Friendly FM Widget
**    Copyright (C) 2011 Percy Leonhardt
**
**    This program is free software: you can redistribute it and/or modify
**    it under the terms of the GNU General Public License as published by
**    the Free Software Foundation, either version 3 of the License, or
**    (at your option) any later version.
**
**    This program is distributed in the hope that it will be useful,
**    but WITHOUT ANY WARRANTY; without even the implied warranty of
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**    GNU General Public License for more details.
**
**    You should have received a copy of the GNU General Public License
**    along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#include "qmaemo5homescreenadaptor.h"
#include "ffmwidget.h"

#include <QtGui>

int main(int argc, char *argv[])
{
    QApplication::setGraphicsSystem("native");

    QApplication app(argc, argv);

    FFMWidget w;
    QMaemo5HomescreenAdaptor *adaptor = new QMaemo5HomescreenAdaptor(&w);
    adaptor->setSettingsAvailable(true);
    QObject::connect(adaptor, SIGNAL(settingsRequested()), &w, SLOT(showSettingsDialog()));

//    QWidget container;
//    QHBoxLayout *hbox = new QHBoxLayout;
//    hbox->addWidget(&w);
//    hbox->addStretch();
//    QVBoxLayout *vbox = new QVBoxLayout;
//    vbox->addLayout(hbox);
//    vbox->addStretch();
//    container.setLayout(vbox);

    w.show();

    app.exec();
}

